/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.BuyerSellerModel;
import fpml.confirmation.Exercise;
import fpml.confirmation.ExerciseProcedure;
import fpml.confirmation.Money;
import fpml.confirmation.NotionalAmountReference;
import fpml.confirmation.OptionBase;
import fpml.confirmation.OptionDenominationModel;
import fpml.confirmation.OptionFeature;
import fpml.confirmation.OptionSettlementModel;
import fpml.confirmation.OptionTypeEnum;
import fpml.confirmation.Premium;
import fpml.confirmation.ProductModel;
import fpml.confirmation.meta.OptionBaseExtendedMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="OptionBaseExtended", builder=OptionBaseExtendedBuilderImpl.class, version="0.17.2")
@RuneDataType(value="OptionBaseExtended", model="fpml", builder=OptionBaseExtendedBuilderImpl.class, version="0.17.2")
public interface OptionBaseExtended
extends OptionBase {
    public static final OptionBaseExtendedMeta metaData = new OptionBaseExtendedMeta();

    public Premium getPremium();

    public Exercise getExercise();

    public ExerciseProcedure getExerciseProcedure();

    public OptionFeature getFeature();

    public NotionalAmountReference getNotionalReference();

    public Money getNotionalAmount();

    public OptionDenominationModel getOptionDenominationModel();

    public OptionSettlementModel getOptionSettlementModel();

    @Override
    public OptionBaseExtended build();

    @Override
    public OptionBaseExtendedBuilder toBuilder();

    public static OptionBaseExtendedBuilder builder() {
        return new OptionBaseExtendedBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionBaseExtended> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionBaseExtended> getType() {
        return OptionBaseExtended.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, Premium.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exercise"), processor, Exercise.class, this.getExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.class, this.getFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalReference"), processor, NotionalAmountReference.class, this.getNotionalReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, Money.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionDenominationModel"), processor, OptionDenominationModel.class, this.getOptionDenominationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.class, this.getOptionSettlementModel(), new AttributeMeta[0]);
    }

    public static class OptionBaseExtendedBuilderImpl
    extends OptionBase.OptionBaseBuilderImpl
    implements OptionBaseExtendedBuilder {
        protected Premium.PremiumBuilder premium;
        protected Exercise.ExerciseBuilder exercise;
        protected ExerciseProcedure.ExerciseProcedureBuilder exerciseProcedure;
        protected OptionFeature.OptionFeatureBuilder feature;
        protected NotionalAmountReference.NotionalAmountReferenceBuilder notionalReference;
        protected Money.MoneyBuilder notionalAmount;
        protected OptionDenominationModel.OptionDenominationModelBuilder optionDenominationModel;
        protected OptionSettlementModel.OptionSettlementModelBuilder optionSettlementModel;

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public Premium.PremiumBuilder getPremium() {
            return this.premium;
        }

        @Override
        public Premium.PremiumBuilder getOrCreatePremium() {
            Premium.PremiumBuilder result = this.premium != null ? this.premium : (this.premium = Premium.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public Exercise.ExerciseBuilder getExercise() {
            return this.exercise;
        }

        @Override
        public Exercise.ExerciseBuilder getOrCreateExercise() {
            Exercise.ExerciseBuilder result = this.exercise != null ? this.exercise : (this.exercise = Exercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure", isRequired=true)
        @RuneAttribute(value="exerciseProcedure", isRequired=true)
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure() {
            ExerciseProcedure.ExerciseProcedureBuilder result = this.exerciseProcedure != null ? this.exerciseProcedure : (this.exerciseProcedure = ExerciseProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public OptionFeature.OptionFeatureBuilder getFeature() {
            return this.feature;
        }

        @Override
        public OptionFeature.OptionFeatureBuilder getOrCreateFeature() {
            OptionFeature.OptionFeatureBuilder result = this.feature != null ? this.feature : (this.feature = OptionFeature.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalReference")
        @RuneAttribute(value="notionalReference")
        public NotionalAmountReference.NotionalAmountReferenceBuilder getNotionalReference() {
            return this.notionalReference;
        }

        @Override
        public NotionalAmountReference.NotionalAmountReferenceBuilder getOrCreateNotionalReference() {
            NotionalAmountReference.NotionalAmountReferenceBuilder result = this.notionalReference != null ? this.notionalReference : (this.notionalReference = NotionalAmountReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public Money.MoneyBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateNotionalAmount() {
            Money.MoneyBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionDenominationModel")
        @RuneAttribute(value="optionDenominationModel")
        public OptionDenominationModel.OptionDenominationModelBuilder getOptionDenominationModel() {
            return this.optionDenominationModel;
        }

        @Override
        public OptionDenominationModel.OptionDenominationModelBuilder getOrCreateOptionDenominationModel() {
            OptionDenominationModel.OptionDenominationModelBuilder result = this.optionDenominationModel != null ? this.optionDenominationModel : (this.optionDenominationModel = OptionDenominationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public OptionSettlementModel.OptionSettlementModelBuilder getOptionSettlementModel() {
            return this.optionSettlementModel;
        }

        @Override
        public OptionSettlementModel.OptionSettlementModelBuilder getOrCreateOptionSettlementModel() {
            OptionSettlementModel.OptionSettlementModelBuilder result = this.optionSettlementModel != null ? this.optionSettlementModel : (this.optionSettlementModel = OptionSettlementModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public OptionBaseExtendedBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public OptionBaseExtendedBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public OptionBaseExtendedBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType", isRequired=true)
        @RuneAttribute(value="optionType", isRequired=true)
        public OptionBaseExtendedBuilder setOptionType(OptionTypeEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public OptionBaseExtendedBuilder setPremium(Premium _premium) {
            this.premium = _premium == null ? null : _premium.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public OptionBaseExtendedBuilder setExercise(Exercise _exercise) {
            this.exercise = _exercise == null ? null : _exercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure", isRequired=true)
        @RuneAttribute(value="exerciseProcedure", isRequired=true)
        public OptionBaseExtendedBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public OptionBaseExtendedBuilder setFeature(OptionFeature _feature) {
            this.feature = _feature == null ? null : _feature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalReference")
        @RuneAttribute(value="notionalReference")
        public OptionBaseExtendedBuilder setNotionalReference(NotionalAmountReference _notionalReference) {
            this.notionalReference = _notionalReference == null ? null : _notionalReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public OptionBaseExtendedBuilder setNotionalAmount(Money _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionDenominationModel")
        @RuneAttribute(value="optionDenominationModel")
        public OptionBaseExtendedBuilder setOptionDenominationModel(OptionDenominationModel _optionDenominationModel) {
            this.optionDenominationModel = _optionDenominationModel == null ? null : _optionDenominationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public OptionBaseExtendedBuilder setOptionSettlementModel(OptionSettlementModel _optionSettlementModel) {
            this.optionSettlementModel = _optionSettlementModel == null ? null : _optionSettlementModel.toBuilder();
            return this;
        }

        @Override
        public OptionBaseExtended build() {
            return new OptionBaseExtendedImpl(this);
        }

        @Override
        public OptionBaseExtendedBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionBaseExtendedBuilder prune() {
            super.prune();
            if (this.premium != null && !this.premium.prune().hasData()) {
                this.premium = null;
            }
            if (this.exercise != null && !this.exercise.prune().hasData()) {
                this.exercise = null;
            }
            if (this.exerciseProcedure != null && !this.exerciseProcedure.prune().hasData()) {
                this.exerciseProcedure = null;
            }
            if (this.feature != null && !this.feature.prune().hasData()) {
                this.feature = null;
            }
            if (this.notionalReference != null && !this.notionalReference.prune().hasData()) {
                this.notionalReference = null;
            }
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            if (this.optionDenominationModel != null && !this.optionDenominationModel.prune().hasData()) {
                this.optionDenominationModel = null;
            }
            if (this.optionSettlementModel != null && !this.optionSettlementModel.prune().hasData()) {
                this.optionSettlementModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().hasData()) {
                return true;
            }
            if (this.getExercise() != null && this.getExercise().hasData()) {
                return true;
            }
            if (this.getExerciseProcedure() != null && this.getExerciseProcedure().hasData()) {
                return true;
            }
            if (this.getFeature() != null && this.getFeature().hasData()) {
                return true;
            }
            if (this.getNotionalReference() != null && this.getNotionalReference().hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            if (this.getOptionDenominationModel() != null && this.getOptionDenominationModel().hasData()) {
                return true;
            }
            return this.getOptionSettlementModel() != null && this.getOptionSettlementModel().hasData();
        }

        @Override
        public OptionBaseExtendedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionBaseExtendedBuilder o = (OptionBaseExtendedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremium(), (RosettaModelObjectBuilder)o.getPremium(), this::setPremium);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExercise(), (RosettaModelObjectBuilder)o.getExercise(), this::setExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseProcedure(), (RosettaModelObjectBuilder)o.getExerciseProcedure(), this::setExerciseProcedure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeature(), (RosettaModelObjectBuilder)o.getFeature(), this::setFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalReference(), (RosettaModelObjectBuilder)o.getNotionalReference(), this::setNotionalReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionDenominationModel(), (RosettaModelObjectBuilder)o.getOptionDenominationModel(), this::setOptionDenominationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionSettlementModel(), (RosettaModelObjectBuilder)o.getOptionSettlementModel(), this::setOptionSettlementModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionBaseExtended _that = (OptionBaseExtended)this.getType().cast(o);
            if (!Objects.equals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.feature, _that.getFeature())) {
                return false;
            }
            if (!Objects.equals(this.notionalReference, _that.getNotionalReference())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionDenominationModel, _that.getOptionDenominationModel())) {
                return false;
            }
            return Objects.equals(this.optionSettlementModel, _that.getOptionSettlementModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            _result = 31 * _result + (this.notionalReference != null ? this.notionalReference.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionDenominationModel != null ? this.optionDenominationModel.hashCode() : 0);
            _result = 31 * _result + (this.optionSettlementModel != null ? this.optionSettlementModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionBaseExtendedBuilder {premium=" + this.premium + ", exercise=" + this.exercise + ", exerciseProcedure=" + this.exerciseProcedure + ", feature=" + this.feature + ", notionalReference=" + this.notionalReference + ", notionalAmount=" + this.notionalAmount + ", optionDenominationModel=" + this.optionDenominationModel + ", optionSettlementModel=" + this.optionSettlementModel + '}' + " " + super.toString();
        }
    }

    public static interface OptionBaseExtendedBuilder
    extends OptionBaseExtended,
    OptionBase.OptionBaseBuilder {
        public Premium.PremiumBuilder getOrCreatePremium();

        @Override
        public Premium.PremiumBuilder getPremium();

        public Exercise.ExerciseBuilder getOrCreateExercise();

        @Override
        public Exercise.ExerciseBuilder getExercise();

        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure();

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure();

        public OptionFeature.OptionFeatureBuilder getOrCreateFeature();

        @Override
        public OptionFeature.OptionFeatureBuilder getFeature();

        public NotionalAmountReference.NotionalAmountReferenceBuilder getOrCreateNotionalReference();

        @Override
        public NotionalAmountReference.NotionalAmountReferenceBuilder getNotionalReference();

        public Money.MoneyBuilder getOrCreateNotionalAmount();

        @Override
        public Money.MoneyBuilder getNotionalAmount();

        public OptionDenominationModel.OptionDenominationModelBuilder getOrCreateOptionDenominationModel();

        @Override
        public OptionDenominationModel.OptionDenominationModelBuilder getOptionDenominationModel();

        public OptionSettlementModel.OptionSettlementModelBuilder getOrCreateOptionSettlementModel();

        @Override
        public OptionSettlementModel.OptionSettlementModelBuilder getOptionSettlementModel();

        @Override
        public OptionBaseExtendedBuilder setProductModel(ProductModel var1);

        @Override
        public OptionBaseExtendedBuilder setId(String var1);

        @Override
        public OptionBaseExtendedBuilder setBuyerSellerModel(BuyerSellerModel var1);

        @Override
        public OptionBaseExtendedBuilder setOptionType(OptionTypeEnum var1);

        public OptionBaseExtendedBuilder setPremium(Premium var1);

        public OptionBaseExtendedBuilder setExercise(Exercise var1);

        public OptionBaseExtendedBuilder setExerciseProcedure(ExerciseProcedure var1);

        public OptionBaseExtendedBuilder setFeature(OptionFeature var1);

        public OptionBaseExtendedBuilder setNotionalReference(NotionalAmountReference var1);

        public OptionBaseExtendedBuilder setNotionalAmount(Money var1);

        public OptionBaseExtendedBuilder setOptionDenominationModel(OptionDenominationModel var1);

        public OptionBaseExtendedBuilder setOptionSettlementModel(OptionSettlementModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, Premium.PremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exercise"), processor, Exercise.ExerciseBuilder.class, this.getExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.OptionFeatureBuilder.class, this.getFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalReference"), processor, NotionalAmountReference.NotionalAmountReferenceBuilder.class, this.getNotionalReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, Money.MoneyBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionDenominationModel"), processor, OptionDenominationModel.OptionDenominationModelBuilder.class, this.getOptionDenominationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.OptionSettlementModelBuilder.class, this.getOptionSettlementModel(), new AttributeMeta[0]);
        }

        @Override
        public OptionBaseExtendedBuilder prune();
    }

    public static class OptionBaseExtendedImpl
    extends OptionBase.OptionBaseImpl
    implements OptionBaseExtended {
        private final Premium premium;
        private final Exercise exercise;
        private final ExerciseProcedure exerciseProcedure;
        private final OptionFeature feature;
        private final NotionalAmountReference notionalReference;
        private final Money notionalAmount;
        private final OptionDenominationModel optionDenominationModel;
        private final OptionSettlementModel optionSettlementModel;

        protected OptionBaseExtendedImpl(OptionBaseExtendedBuilder builder) {
            super(builder);
            this.premium = Optional.ofNullable(builder.getPremium()).map(f -> f.build()).orElse(null);
            this.exercise = Optional.ofNullable(builder.getExercise()).map(f -> f.build()).orElse(null);
            this.exerciseProcedure = Optional.ofNullable(builder.getExerciseProcedure()).map(f -> f.build()).orElse(null);
            this.feature = Optional.ofNullable(builder.getFeature()).map(f -> f.build()).orElse(null);
            this.notionalReference = Optional.ofNullable(builder.getNotionalReference()).map(f -> f.build()).orElse(null);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.optionDenominationModel = Optional.ofNullable(builder.getOptionDenominationModel()).map(f -> f.build()).orElse(null);
            this.optionSettlementModel = Optional.ofNullable(builder.getOptionSettlementModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public Premium getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="exercise", isRequired=true)
        @RuneAttribute(value="exercise", isRequired=true)
        public Exercise getExercise() {
            return this.exercise;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure", isRequired=true)
        @RuneAttribute(value="exerciseProcedure", isRequired=true)
        public ExerciseProcedure getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public OptionFeature getFeature() {
            return this.feature;
        }

        @Override
        @RosettaAttribute(value="notionalReference")
        @RuneAttribute(value="notionalReference")
        public NotionalAmountReference getNotionalReference() {
            return this.notionalReference;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public Money getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="optionDenominationModel")
        @RuneAttribute(value="optionDenominationModel")
        public OptionDenominationModel getOptionDenominationModel() {
            return this.optionDenominationModel;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public OptionSettlementModel getOptionSettlementModel() {
            return this.optionSettlementModel;
        }

        @Override
        public OptionBaseExtended build() {
            return this;
        }

        @Override
        public OptionBaseExtendedBuilder toBuilder() {
            OptionBaseExtendedBuilder builder = OptionBaseExtended.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionBaseExtendedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getExercise()).ifPresent(builder::setExercise);
            Optional.ofNullable(this.getExerciseProcedure()).ifPresent(builder::setExerciseProcedure);
            Optional.ofNullable(this.getFeature()).ifPresent(builder::setFeature);
            Optional.ofNullable(this.getNotionalReference()).ifPresent(builder::setNotionalReference);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getOptionDenominationModel()).ifPresent(builder::setOptionDenominationModel);
            Optional.ofNullable(this.getOptionSettlementModel()).ifPresent(builder::setOptionSettlementModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionBaseExtended _that = (OptionBaseExtended)this.getType().cast(o);
            if (!Objects.equals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!Objects.equals(this.exercise, _that.getExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.feature, _that.getFeature())) {
                return false;
            }
            if (!Objects.equals(this.notionalReference, _that.getNotionalReference())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionDenominationModel, _that.getOptionDenominationModel())) {
                return false;
            }
            return Objects.equals(this.optionSettlementModel, _that.getOptionSettlementModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.exercise != null ? this.exercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            _result = 31 * _result + (this.notionalReference != null ? this.notionalReference.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionDenominationModel != null ? this.optionDenominationModel.hashCode() : 0);
            _result = 31 * _result + (this.optionSettlementModel != null ? this.optionSettlementModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionBaseExtended {premium=" + this.premium + ", exercise=" + this.exercise + ", exerciseProcedure=" + this.exerciseProcedure + ", feature=" + this.feature + ", notionalReference=" + this.notionalReference + ", notionalAmount=" + this.notionalAmount + ", optionDenominationModel=" + this.optionDenominationModel + ", optionSettlementModel=" + this.optionSettlementModel + '}' + " " + super.toString();
        }
    }
}

