/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.MasterAgreementId;
import fpml.confirmation.MasterAgreementType;
import fpml.confirmation.MasterAgreementVersion;
import fpml.confirmation.meta.MasterAgreementMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MasterAgreement", builder=MasterAgreementBuilderImpl.class, version="0.17.2")
@RuneDataType(value="MasterAgreement", model="fpml", builder=MasterAgreementBuilderImpl.class, version="0.17.2")
public interface MasterAgreement
extends RosettaModelObject {
    public static final MasterAgreementMeta metaData = new MasterAgreementMeta();

    public List<? extends MasterAgreementId> getMasterAgreementId();

    public MasterAgreementType getMasterAgreementType();

    public MasterAgreementVersion getMasterAgreementVersion();

    public ZonedDateTime getMasterAgreementDate();

    public MasterAgreement build();

    public MasterAgreementBuilder toBuilder();

    public static MasterAgreementBuilder builder() {
        return new MasterAgreementBuilderImpl();
    }

    default public RosettaMetaData<? extends MasterAgreement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MasterAgreement> getType() {
        return MasterAgreement.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("masterAgreementId"), processor, MasterAgreementId.class, this.getMasterAgreementId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("masterAgreementType"), processor, MasterAgreementType.class, this.getMasterAgreementType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("masterAgreementVersion"), processor, MasterAgreementVersion.class, this.getMasterAgreementVersion(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementDate"), ZonedDateTime.class, (Object)this.getMasterAgreementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MasterAgreementBuilderImpl
    implements MasterAgreementBuilder {
        protected List<MasterAgreementId.MasterAgreementIdBuilder> masterAgreementId = new ArrayList<MasterAgreementId.MasterAgreementIdBuilder>();
        protected MasterAgreementType.MasterAgreementTypeBuilder masterAgreementType;
        protected MasterAgreementVersion.MasterAgreementVersionBuilder masterAgreementVersion;
        protected ZonedDateTime masterAgreementDate;

        @Override
        @RosettaAttribute(value="masterAgreementId")
        @RuneAttribute(value="masterAgreementId")
        public List<? extends MasterAgreementId.MasterAgreementIdBuilder> getMasterAgreementId() {
            return this.masterAgreementId;
        }

        @Override
        public MasterAgreementId.MasterAgreementIdBuilder getOrCreateMasterAgreementId(int index) {
            if (this.masterAgreementId == null) {
                this.masterAgreementId = new ArrayList<MasterAgreementId.MasterAgreementIdBuilder>();
            }
            return (MasterAgreementId.MasterAgreementIdBuilder)this.getIndex(this.masterAgreementId, index, () -> {
                MasterAgreementId.MasterAgreementIdBuilder newMasterAgreementId = MasterAgreementId.builder();
                return newMasterAgreementId;
            });
        }

        @Override
        @RosettaAttribute(value="masterAgreementType", isRequired=true)
        @RuneAttribute(value="masterAgreementType", isRequired=true)
        public MasterAgreementType.MasterAgreementTypeBuilder getMasterAgreementType() {
            return this.masterAgreementType;
        }

        @Override
        public MasterAgreementType.MasterAgreementTypeBuilder getOrCreateMasterAgreementType() {
            MasterAgreementType.MasterAgreementTypeBuilder result = this.masterAgreementType != null ? this.masterAgreementType : (this.masterAgreementType = MasterAgreementType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public MasterAgreementVersion.MasterAgreementVersionBuilder getMasterAgreementVersion() {
            return this.masterAgreementVersion;
        }

        @Override
        public MasterAgreementVersion.MasterAgreementVersionBuilder getOrCreateMasterAgreementVersion() {
            MasterAgreementVersion.MasterAgreementVersionBuilder result = this.masterAgreementVersion != null ? this.masterAgreementVersion : (this.masterAgreementVersion = MasterAgreementVersion.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="masterAgreementDate")
        @RuneAttribute(value="masterAgreementDate")
        public ZonedDateTime getMasterAgreementDate() {
            return this.masterAgreementDate;
        }

        @Override
        @RosettaAttribute(value="masterAgreementId")
        @RuneAttribute(value="masterAgreementId")
        public MasterAgreementBuilder addMasterAgreementId(MasterAgreementId _masterAgreementId) {
            if (_masterAgreementId != null) {
                this.masterAgreementId.add(_masterAgreementId.toBuilder());
            }
            return this;
        }

        @Override
        public MasterAgreementBuilder addMasterAgreementId(MasterAgreementId _masterAgreementId, int idx) {
            this.getIndex(this.masterAgreementId, idx, () -> _masterAgreementId.toBuilder());
            return this;
        }

        @Override
        public MasterAgreementBuilder addMasterAgreementId(List<? extends MasterAgreementId> masterAgreementIds) {
            if (masterAgreementIds != null) {
                for (MasterAgreementId masterAgreementId : masterAgreementIds) {
                    this.masterAgreementId.add(masterAgreementId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="masterAgreementId")
        public MasterAgreementBuilder setMasterAgreementId(List<? extends MasterAgreementId> masterAgreementIds) {
            this.masterAgreementId = masterAgreementIds == null ? new ArrayList<MasterAgreementId.MasterAgreementIdBuilder>() : (List)masterAgreementIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType", isRequired=true)
        @RuneAttribute(value="masterAgreementType", isRequired=true)
        public MasterAgreementBuilder setMasterAgreementType(MasterAgreementType _masterAgreementType) {
            this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public MasterAgreementBuilder setMasterAgreementVersion(MasterAgreementVersion _masterAgreementVersion) {
            this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementDate")
        @RuneAttribute(value="masterAgreementDate")
        public MasterAgreementBuilder setMasterAgreementDate(ZonedDateTime _masterAgreementDate) {
            this.masterAgreementDate = _masterAgreementDate == null ? null : _masterAgreementDate;
            return this;
        }

        @Override
        public MasterAgreement build() {
            return new MasterAgreementImpl(this);
        }

        @Override
        public MasterAgreementBuilder toBuilder() {
            return this;
        }

        @Override
        public MasterAgreementBuilder prune() {
            this.masterAgreementId = this.masterAgreementId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.masterAgreementType != null && !this.masterAgreementType.prune().hasData()) {
                this.masterAgreementType = null;
            }
            if (this.masterAgreementVersion != null && !this.masterAgreementVersion.prune().hasData()) {
                this.masterAgreementVersion = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getMasterAgreementId() != null && this.getMasterAgreementId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getMasterAgreementType() != null && this.getMasterAgreementType().hasData()) {
                return true;
            }
            if (this.getMasterAgreementVersion() != null && this.getMasterAgreementVersion().hasData()) {
                return true;
            }
            return this.getMasterAgreementDate() != null;
        }

        public MasterAgreementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MasterAgreementBuilder o = (MasterAgreementBuilder)other;
            merger.mergeRosetta(this.getMasterAgreementId(), o.getMasterAgreementId(), this::getOrCreateMasterAgreementId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMasterAgreementType(), (RosettaModelObjectBuilder)o.getMasterAgreementType(), this::setMasterAgreementType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMasterAgreementVersion(), (RosettaModelObjectBuilder)o.getMasterAgreementVersion(), this::setMasterAgreementVersion);
            merger.mergeBasic((Object)this.getMasterAgreementDate(), (Object)o.getMasterAgreementDate(), this::setMasterAgreementDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MasterAgreement _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.masterAgreementId, _that.getMasterAgreementId())) {
                return false;
            }
            if (!Objects.equals(this.masterAgreementType, _that.getMasterAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.masterAgreementVersion, _that.getMasterAgreementVersion())) {
                return false;
            }
            return Objects.equals(this.masterAgreementDate, _that.getMasterAgreementDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.masterAgreementId != null ? this.masterAgreementId.hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementType != null ? this.masterAgreementType.hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementVersion != null ? this.masterAgreementVersion.hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementDate != null ? this.masterAgreementDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MasterAgreementBuilder {masterAgreementId=" + this.masterAgreementId + ", masterAgreementType=" + this.masterAgreementType + ", masterAgreementVersion=" + this.masterAgreementVersion + ", masterAgreementDate=" + this.masterAgreementDate + '}';
        }
    }

    public static interface MasterAgreementBuilder
    extends MasterAgreement,
    RosettaModelObjectBuilder {
        public MasterAgreementId.MasterAgreementIdBuilder getOrCreateMasterAgreementId(int var1);

        public List<? extends MasterAgreementId.MasterAgreementIdBuilder> getMasterAgreementId();

        public MasterAgreementType.MasterAgreementTypeBuilder getOrCreateMasterAgreementType();

        @Override
        public MasterAgreementType.MasterAgreementTypeBuilder getMasterAgreementType();

        public MasterAgreementVersion.MasterAgreementVersionBuilder getOrCreateMasterAgreementVersion();

        @Override
        public MasterAgreementVersion.MasterAgreementVersionBuilder getMasterAgreementVersion();

        public MasterAgreementBuilder addMasterAgreementId(MasterAgreementId var1);

        public MasterAgreementBuilder addMasterAgreementId(MasterAgreementId var1, int var2);

        public MasterAgreementBuilder addMasterAgreementId(List<? extends MasterAgreementId> var1);

        public MasterAgreementBuilder setMasterAgreementId(List<? extends MasterAgreementId> var1);

        public MasterAgreementBuilder setMasterAgreementType(MasterAgreementType var1);

        public MasterAgreementBuilder setMasterAgreementVersion(MasterAgreementVersion var1);

        public MasterAgreementBuilder setMasterAgreementDate(ZonedDateTime var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("masterAgreementId"), processor, MasterAgreementId.MasterAgreementIdBuilder.class, this.getMasterAgreementId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("masterAgreementType"), processor, MasterAgreementType.MasterAgreementTypeBuilder.class, this.getMasterAgreementType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("masterAgreementVersion"), processor, MasterAgreementVersion.MasterAgreementVersionBuilder.class, this.getMasterAgreementVersion(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementDate"), ZonedDateTime.class, (Object)this.getMasterAgreementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public MasterAgreementBuilder prune();
    }

    public static class MasterAgreementImpl
    implements MasterAgreement {
        private final List<? extends MasterAgreementId> masterAgreementId;
        private final MasterAgreementType masterAgreementType;
        private final MasterAgreementVersion masterAgreementVersion;
        private final ZonedDateTime masterAgreementDate;

        protected MasterAgreementImpl(MasterAgreementBuilder builder) {
            this.masterAgreementId = Optional.ofNullable(builder.getMasterAgreementId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.masterAgreementType = Optional.ofNullable(builder.getMasterAgreementType()).map(f -> f.build()).orElse(null);
            this.masterAgreementVersion = Optional.ofNullable(builder.getMasterAgreementVersion()).map(f -> f.build()).orElse(null);
            this.masterAgreementDate = builder.getMasterAgreementDate();
        }

        @Override
        @RosettaAttribute(value="masterAgreementId")
        @RuneAttribute(value="masterAgreementId")
        public List<? extends MasterAgreementId> getMasterAgreementId() {
            return this.masterAgreementId;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType", isRequired=true)
        @RuneAttribute(value="masterAgreementType", isRequired=true)
        public MasterAgreementType getMasterAgreementType() {
            return this.masterAgreementType;
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public MasterAgreementVersion getMasterAgreementVersion() {
            return this.masterAgreementVersion;
        }

        @Override
        @RosettaAttribute(value="masterAgreementDate")
        @RuneAttribute(value="masterAgreementDate")
        public ZonedDateTime getMasterAgreementDate() {
            return this.masterAgreementDate;
        }

        @Override
        public MasterAgreement build() {
            return this;
        }

        @Override
        public MasterAgreementBuilder toBuilder() {
            MasterAgreementBuilder builder = MasterAgreement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MasterAgreementBuilder builder) {
            Optional.ofNullable(this.getMasterAgreementId()).ifPresent(builder::setMasterAgreementId);
            Optional.ofNullable(this.getMasterAgreementType()).ifPresent(builder::setMasterAgreementType);
            Optional.ofNullable(this.getMasterAgreementVersion()).ifPresent(builder::setMasterAgreementVersion);
            Optional.ofNullable(this.getMasterAgreementDate()).ifPresent(builder::setMasterAgreementDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MasterAgreement _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.masterAgreementId, _that.getMasterAgreementId())) {
                return false;
            }
            if (!Objects.equals(this.masterAgreementType, _that.getMasterAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.masterAgreementVersion, _that.getMasterAgreementVersion())) {
                return false;
            }
            return Objects.equals(this.masterAgreementDate, _that.getMasterAgreementDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.masterAgreementId != null ? this.masterAgreementId.hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementType != null ? this.masterAgreementType.hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementVersion != null ? this.masterAgreementVersion.hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementDate != null ? this.masterAgreementDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MasterAgreement {masterAgreementId=" + this.masterAgreementId + ", masterAgreementType=" + this.masterAgreementType + ", masterAgreementVersion=" + this.masterAgreementVersion + ", masterAgreementDate=" + this.masterAgreementDate + '}';
        }
    }
}

