/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.DealReference;
import fpml.confirmation.FacilityReference;
import fpml.confirmation.LegalActionId;
import fpml.confirmation.LegalActionIdentifier;
import fpml.confirmation.LoanLegalActionDetails;
import fpml.confirmation.PartyReference;
import fpml.confirmation.VersionedLegalActionId;
import fpml.confirmation.meta.LoanLegalActionSummaryMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanLegalActionSummary", builder=LoanLegalActionSummaryBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LoanLegalActionSummary", model="fpml", builder=LoanLegalActionSummaryBuilderImpl.class, version="0.17.2")
public interface LoanLegalActionSummary
extends LegalActionIdentifier {
    public static final LoanLegalActionSummaryMeta metaData = new LoanLegalActionSummaryMeta();

    public LoanLegalActionDetails getActionDetails();

    public DealReference getDealReference();

    public List<? extends FacilityReference> getFacilityReference();

    @Override
    public LoanLegalActionSummary build();

    @Override
    public LoanLegalActionSummaryBuilder toBuilder();

    public static LoanLegalActionSummaryBuilder builder() {
        return new LoanLegalActionSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanLegalActionSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanLegalActionSummary> getType() {
        return LoanLegalActionSummary.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionId"), processor, LegalActionId.class, this.getLegalActionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedLegalActionId"), processor, VersionedLegalActionId.class, this.getVersionedLegalActionId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("actionDetails"), processor, LoanLegalActionDetails.class, this.getActionDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
    }

    public static class LoanLegalActionSummaryBuilderImpl
    extends LegalActionIdentifier.LegalActionIdentifierBuilderImpl
    implements LoanLegalActionSummaryBuilder {
        protected LoanLegalActionDetails.LoanLegalActionDetailsBuilder actionDetails;
        protected DealReference.DealReferenceBuilder dealReference;
        protected List<FacilityReference.FacilityReferenceBuilder> facilityReference = new ArrayList<FacilityReference.FacilityReferenceBuilder>();

        @Override
        @RosettaAttribute(value="actionDetails", isRequired=true)
        @RuneAttribute(value="actionDetails", isRequired=true)
        public LoanLegalActionDetails.LoanLegalActionDetailsBuilder getActionDetails() {
            return this.actionDetails;
        }

        @Override
        public LoanLegalActionDetails.LoanLegalActionDetailsBuilder getOrCreateActionDetails() {
            LoanLegalActionDetails.LoanLegalActionDetailsBuilder result = this.actionDetails != null ? this.actionDetails : (this.actionDetails = LoanLegalActionDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference.DealReferenceBuilder getDealReference() {
            return this.dealReference;
        }

        @Override
        public DealReference.DealReferenceBuilder getOrCreateDealReference() {
            DealReference.DealReferenceBuilder result = this.dealReference != null ? this.dealReference : (this.dealReference = DealReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public List<? extends FacilityReference.FacilityReferenceBuilder> getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference(int index) {
            if (this.facilityReference == null) {
                this.facilityReference = new ArrayList<FacilityReference.FacilityReferenceBuilder>();
            }
            return (FacilityReference.FacilityReferenceBuilder)this.getIndex(this.facilityReference, index, () -> {
                FacilityReference.FacilityReferenceBuilder newFacilityReference = FacilityReference.builder();
                return newFacilityReference;
            });
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public LoanLegalActionSummaryBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LoanLegalActionSummaryBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionId")
        @RuneAttribute(value="legalActionId")
        public LoanLegalActionSummaryBuilder addLegalActionId(LegalActionId _legalActionId) {
            if (_legalActionId != null) {
                this.legalActionId.add(_legalActionId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionSummaryBuilder addLegalActionId(LegalActionId _legalActionId, int idx) {
            this.getIndex(this.legalActionId, idx, () -> _legalActionId.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionSummaryBuilder addLegalActionId(List<? extends LegalActionId> legalActionIds) {
            if (legalActionIds != null) {
                for (LegalActionId legalActionId : legalActionIds) {
                    this.legalActionId.add(legalActionId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legalActionId")
        public LoanLegalActionSummaryBuilder setLegalActionId(List<? extends LegalActionId> legalActionIds) {
            this.legalActionId = legalActionIds == null ? new ArrayList() : (List)legalActionIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedLegalActionId")
        @RuneAttribute(value="versionedLegalActionId")
        public LoanLegalActionSummaryBuilder addVersionedLegalActionId(VersionedLegalActionId _versionedLegalActionId) {
            if (_versionedLegalActionId != null) {
                this.versionedLegalActionId.add(_versionedLegalActionId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionSummaryBuilder addVersionedLegalActionId(VersionedLegalActionId _versionedLegalActionId, int idx) {
            this.getIndex(this.versionedLegalActionId, idx, () -> _versionedLegalActionId.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionSummaryBuilder addVersionedLegalActionId(List<? extends VersionedLegalActionId> versionedLegalActionIds) {
            if (versionedLegalActionIds != null) {
                for (VersionedLegalActionId versionedLegalActionId : versionedLegalActionIds) {
                    this.versionedLegalActionId.add(versionedLegalActionId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedLegalActionId")
        public LoanLegalActionSummaryBuilder setVersionedLegalActionId(List<? extends VersionedLegalActionId> versionedLegalActionIds) {
            this.versionedLegalActionId = versionedLegalActionIds == null ? new ArrayList() : (List)versionedLegalActionIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanLegalActionSummaryBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionDetails", isRequired=true)
        @RuneAttribute(value="actionDetails", isRequired=true)
        public LoanLegalActionSummaryBuilder setActionDetails(LoanLegalActionDetails _actionDetails) {
            this.actionDetails = _actionDetails == null ? null : _actionDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public LoanLegalActionSummaryBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public LoanLegalActionSummaryBuilder addFacilityReference(FacilityReference _facilityReference) {
            if (_facilityReference != null) {
                this.facilityReference.add(_facilityReference.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionSummaryBuilder addFacilityReference(FacilityReference _facilityReference, int idx) {
            this.getIndex(this.facilityReference, idx, () -> _facilityReference.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionSummaryBuilder addFacilityReference(List<? extends FacilityReference> facilityReferences) {
            if (facilityReferences != null) {
                for (FacilityReference facilityReference : facilityReferences) {
                    this.facilityReference.add(facilityReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityReference")
        public LoanLegalActionSummaryBuilder setFacilityReference(List<? extends FacilityReference> facilityReferences) {
            this.facilityReference = facilityReferences == null ? new ArrayList<FacilityReference.FacilityReferenceBuilder>() : (List)facilityReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanLegalActionSummary build() {
            return new LoanLegalActionSummaryImpl(this);
        }

        @Override
        public LoanLegalActionSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanLegalActionSummaryBuilder prune() {
            super.prune();
            if (this.actionDetails != null && !this.actionDetails.prune().hasData()) {
                this.actionDetails = null;
            }
            if (this.dealReference != null && !this.dealReference.prune().hasData()) {
                this.dealReference = null;
            }
            this.facilityReference = this.facilityReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getActionDetails() != null && this.getActionDetails().hasData()) {
                return true;
            }
            if (this.getDealReference() != null && this.getDealReference().hasData()) {
                return true;
            }
            return this.getFacilityReference() != null && this.getFacilityReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LoanLegalActionSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanLegalActionSummaryBuilder o = (LoanLegalActionSummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getActionDetails(), (RosettaModelObjectBuilder)o.getActionDetails(), this::setActionDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealReference(), (RosettaModelObjectBuilder)o.getDealReference(), this::setDealReference);
            merger.mergeRosetta(this.getFacilityReference(), o.getFacilityReference(), this::getOrCreateFacilityReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanLegalActionSummary _that = (LoanLegalActionSummary)this.getType().cast(o);
            if (!Objects.equals(this.actionDetails, _that.getActionDetails())) {
                return false;
            }
            if (!Objects.equals(this.dealReference, _that.getDealReference())) {
                return false;
            }
            return ListEquals.listEquals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.actionDetails != null ? this.actionDetails.hashCode() : 0);
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanLegalActionSummaryBuilder {actionDetails=" + this.actionDetails + ", dealReference=" + this.dealReference + ", facilityReference=" + this.facilityReference + '}' + " " + super.toString();
        }
    }

    public static interface LoanLegalActionSummaryBuilder
    extends LoanLegalActionSummary,
    LegalActionIdentifier.LegalActionIdentifierBuilder {
        public LoanLegalActionDetails.LoanLegalActionDetailsBuilder getOrCreateActionDetails();

        @Override
        public LoanLegalActionDetails.LoanLegalActionDetailsBuilder getActionDetails();

        public DealReference.DealReferenceBuilder getOrCreateDealReference();

        @Override
        public DealReference.DealReferenceBuilder getDealReference();

        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference(int var1);

        public List<? extends FacilityReference.FacilityReferenceBuilder> getFacilityReference();

        @Override
        public LoanLegalActionSummaryBuilder setName(String var1);

        @Override
        public LoanLegalActionSummaryBuilder setPartyReference(PartyReference var1);

        @Override
        public LoanLegalActionSummaryBuilder addLegalActionId(LegalActionId var1);

        @Override
        public LoanLegalActionSummaryBuilder addLegalActionId(LegalActionId var1, int var2);

        @Override
        public LoanLegalActionSummaryBuilder addLegalActionId(List<? extends LegalActionId> var1);

        @Override
        public LoanLegalActionSummaryBuilder setLegalActionId(List<? extends LegalActionId> var1);

        @Override
        public LoanLegalActionSummaryBuilder addVersionedLegalActionId(VersionedLegalActionId var1);

        @Override
        public LoanLegalActionSummaryBuilder addVersionedLegalActionId(VersionedLegalActionId var1, int var2);

        @Override
        public LoanLegalActionSummaryBuilder addVersionedLegalActionId(List<? extends VersionedLegalActionId> var1);

        @Override
        public LoanLegalActionSummaryBuilder setVersionedLegalActionId(List<? extends VersionedLegalActionId> var1);

        @Override
        public LoanLegalActionSummaryBuilder setId(String var1);

        public LoanLegalActionSummaryBuilder setActionDetails(LoanLegalActionDetails var1);

        public LoanLegalActionSummaryBuilder setDealReference(DealReference var1);

        public LoanLegalActionSummaryBuilder addFacilityReference(FacilityReference var1);

        public LoanLegalActionSummaryBuilder addFacilityReference(FacilityReference var1, int var2);

        public LoanLegalActionSummaryBuilder addFacilityReference(List<? extends FacilityReference> var1);

        public LoanLegalActionSummaryBuilder setFacilityReference(List<? extends FacilityReference> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionId"), processor, LegalActionId.LegalActionIdBuilder.class, this.getLegalActionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedLegalActionId"), processor, VersionedLegalActionId.VersionedLegalActionIdBuilder.class, this.getVersionedLegalActionId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("actionDetails"), processor, LoanLegalActionDetails.LoanLegalActionDetailsBuilder.class, this.getActionDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, this.getDealReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
        }

        @Override
        public LoanLegalActionSummaryBuilder prune();
    }

    public static class LoanLegalActionSummaryImpl
    extends LegalActionIdentifier.LegalActionIdentifierImpl
    implements LoanLegalActionSummary {
        private final LoanLegalActionDetails actionDetails;
        private final DealReference dealReference;
        private final List<? extends FacilityReference> facilityReference;

        protected LoanLegalActionSummaryImpl(LoanLegalActionSummaryBuilder builder) {
            super(builder);
            this.actionDetails = Optional.ofNullable(builder.getActionDetails()).map(f -> f.build()).orElse(null);
            this.dealReference = Optional.ofNullable(builder.getDealReference()).map(f -> f.build()).orElse(null);
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="actionDetails", isRequired=true)
        @RuneAttribute(value="actionDetails", isRequired=true)
        public LoanLegalActionDetails getActionDetails() {
            return this.actionDetails;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference getDealReference() {
            return this.dealReference;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public List<? extends FacilityReference> getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public LoanLegalActionSummary build() {
            return this;
        }

        @Override
        public LoanLegalActionSummaryBuilder toBuilder() {
            LoanLegalActionSummaryBuilder builder = LoanLegalActionSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanLegalActionSummaryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getActionDetails()).ifPresent(builder::setActionDetails);
            Optional.ofNullable(this.getDealReference()).ifPresent(builder::setDealReference);
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanLegalActionSummary _that = (LoanLegalActionSummary)this.getType().cast(o);
            if (!Objects.equals(this.actionDetails, _that.getActionDetails())) {
                return false;
            }
            if (!Objects.equals(this.dealReference, _that.getDealReference())) {
                return false;
            }
            return ListEquals.listEquals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.actionDetails != null ? this.actionDetails.hashCode() : 0);
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanLegalActionSummary {actionDetails=" + this.actionDetails + ", dealReference=" + this.dealReference + ", facilityReference=" + this.facilityReference + '}' + " " + super.toString();
        }
    }
}

