/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AbstractLoanFloatingRateOptionBase;
import fpml.confirmation.AccrualTypeId;
import fpml.confirmation.Currency;
import fpml.confirmation.DayCountFraction;
import fpml.confirmation.LoanFloatingRate;
import fpml.confirmation.PartyReference;
import fpml.confirmation.Period;
import fpml.confirmation.PeriodModel;
import fpml.confirmation.meta.LoanFloatingRateOptionMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanFloatingRateOption", builder=LoanFloatingRateOptionBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LoanFloatingRateOption", model="fpml", builder=LoanFloatingRateOptionBuilderImpl.class, version="0.17.2")
public interface LoanFloatingRateOption
extends AbstractLoanFloatingRateOptionBase {
    public static final LoanFloatingRateOptionMeta metaData = new LoanFloatingRateOptionMeta();

    public Currency getCurrency();

    public PeriodModel getPeriodModel();

    public List<? extends PartyReference> getBorrowerPartyReference();

    public Integer getDrawdownNoticeDays();

    public Integer getFxRateSetNoticeDays();

    public Integer getRateSetNoticeDays();

    @Override
    public LoanFloatingRateOption build();

    @Override
    public LoanFloatingRateOptionBuilder toBuilder();

    public static LoanFloatingRateOptionBuilder builder() {
        return new LoanFloatingRateOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanFloatingRateOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanFloatingRateOption> getType() {
        return LoanFloatingRateOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rate"), processor, LoanFloatingRate.class, this.getRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("borrowerPartyReference"), processor, PartyReference.class, this.getBorrowerPartyReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("drawdownNoticeDays"), Integer.class, (Object)this.getDrawdownNoticeDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fxRateSetNoticeDays"), Integer.class, (Object)this.getFxRateSetNoticeDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rateSetNoticeDays"), Integer.class, (Object)this.getRateSetNoticeDays(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LoanFloatingRateOptionBuilderImpl
    extends AbstractLoanFloatingRateOptionBase.AbstractLoanFloatingRateOptionBaseBuilderImpl
    implements LoanFloatingRateOptionBuilder {
        protected Currency.CurrencyBuilder currency;
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected List<PartyReference.PartyReferenceBuilder> borrowerPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
        protected Integer drawdownNoticeDays;
        protected Integer fxRateSetNoticeDays;
        protected Integer rateSetNoticeDays;

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodModel")
        @RuneAttribute(value="periodModel")
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="borrowerPartyReference")
        @RuneAttribute(value="borrowerPartyReference")
        public List<? extends PartyReference.PartyReferenceBuilder> getBorrowerPartyReference() {
            return this.borrowerPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateBorrowerPartyReference(int index) {
            if (this.borrowerPartyReference == null) {
                this.borrowerPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.borrowerPartyReference, index, () -> {
                PartyReference.PartyReferenceBuilder newBorrowerPartyReference = PartyReference.builder();
                return newBorrowerPartyReference;
            });
        }

        @Override
        @RosettaAttribute(value="drawdownNoticeDays")
        @RuneAttribute(value="drawdownNoticeDays")
        public Integer getDrawdownNoticeDays() {
            return this.drawdownNoticeDays;
        }

        @Override
        @RosettaAttribute(value="fxRateSetNoticeDays")
        @RuneAttribute(value="fxRateSetNoticeDays")
        public Integer getFxRateSetNoticeDays() {
            return this.fxRateSetNoticeDays;
        }

        @Override
        @RosettaAttribute(value="rateSetNoticeDays")
        @RuneAttribute(value="rateSetNoticeDays")
        public Integer getRateSetNoticeDays() {
            return this.rateSetNoticeDays;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public LoanFloatingRateOptionBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public LoanFloatingRateOptionBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public LoanFloatingRateOptionBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public LoanFloatingRateOptionBuilder setRate(LoanFloatingRate _rate) {
            this.rate = _rate == null ? null : _rate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public LoanFloatingRateOptionBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel")
        @RuneAttribute(value="periodModel")
        public LoanFloatingRateOptionBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="borrowerPartyReference")
        @RuneAttribute(value="borrowerPartyReference")
        public LoanFloatingRateOptionBuilder addBorrowerPartyReference(PartyReference _borrowerPartyReference) {
            if (_borrowerPartyReference != null) {
                this.borrowerPartyReference.add(_borrowerPartyReference.toBuilder());
            }
            return this;
        }

        @Override
        public LoanFloatingRateOptionBuilder addBorrowerPartyReference(PartyReference _borrowerPartyReference, int idx) {
            this.getIndex(this.borrowerPartyReference, idx, () -> _borrowerPartyReference.toBuilder());
            return this;
        }

        @Override
        public LoanFloatingRateOptionBuilder addBorrowerPartyReference(List<? extends PartyReference> borrowerPartyReferences) {
            if (borrowerPartyReferences != null) {
                for (PartyReference partyReference : borrowerPartyReferences) {
                    this.borrowerPartyReference.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="borrowerPartyReference")
        public LoanFloatingRateOptionBuilder setBorrowerPartyReference(List<? extends PartyReference> borrowerPartyReferences) {
            this.borrowerPartyReference = borrowerPartyReferences == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)borrowerPartyReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="drawdownNoticeDays")
        @RuneAttribute(value="drawdownNoticeDays")
        public LoanFloatingRateOptionBuilder setDrawdownNoticeDays(Integer _drawdownNoticeDays) {
            this.drawdownNoticeDays = _drawdownNoticeDays == null ? null : _drawdownNoticeDays;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxRateSetNoticeDays")
        @RuneAttribute(value="fxRateSetNoticeDays")
        public LoanFloatingRateOptionBuilder setFxRateSetNoticeDays(Integer _fxRateSetNoticeDays) {
            this.fxRateSetNoticeDays = _fxRateSetNoticeDays == null ? null : _fxRateSetNoticeDays;
            return this;
        }

        @Override
        @RosettaAttribute(value="rateSetNoticeDays")
        @RuneAttribute(value="rateSetNoticeDays")
        public LoanFloatingRateOptionBuilder setRateSetNoticeDays(Integer _rateSetNoticeDays) {
            this.rateSetNoticeDays = _rateSetNoticeDays == null ? null : _rateSetNoticeDays;
            return this;
        }

        @Override
        public LoanFloatingRateOption build() {
            return new LoanFloatingRateOptionImpl(this);
        }

        @Override
        public LoanFloatingRateOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanFloatingRateOptionBuilder prune() {
            super.prune();
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            this.borrowerPartyReference = this.borrowerPartyReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this.getBorrowerPartyReference() != null && this.getBorrowerPartyReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDrawdownNoticeDays() != null) {
                return true;
            }
            if (this.getFxRateSetNoticeDays() != null) {
                return true;
            }
            return this.getRateSetNoticeDays() != null;
        }

        @Override
        public LoanFloatingRateOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanFloatingRateOptionBuilder o = (LoanFloatingRateOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta(this.getBorrowerPartyReference(), o.getBorrowerPartyReference(), this::getOrCreateBorrowerPartyReference);
            merger.mergeBasic((Object)this.getDrawdownNoticeDays(), (Object)o.getDrawdownNoticeDays(), this::setDrawdownNoticeDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFxRateSetNoticeDays(), (Object)o.getFxRateSetNoticeDays(), this::setFxRateSetNoticeDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRateSetNoticeDays(), (Object)o.getRateSetNoticeDays(), this::setRateSetNoticeDays, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanFloatingRateOption _that = (LoanFloatingRateOption)this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.borrowerPartyReference, _that.getBorrowerPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.drawdownNoticeDays, _that.getDrawdownNoticeDays())) {
                return false;
            }
            if (!Objects.equals(this.fxRateSetNoticeDays, _that.getFxRateSetNoticeDays())) {
                return false;
            }
            return Objects.equals(this.rateSetNoticeDays, _that.getRateSetNoticeDays());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.borrowerPartyReference != null ? this.borrowerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.drawdownNoticeDays != null ? this.drawdownNoticeDays.hashCode() : 0);
            _result = 31 * _result + (this.fxRateSetNoticeDays != null ? this.fxRateSetNoticeDays.hashCode() : 0);
            _result = 31 * _result + (this.rateSetNoticeDays != null ? this.rateSetNoticeDays.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanFloatingRateOptionBuilder {currency=" + this.currency + ", periodModel=" + this.periodModel + ", borrowerPartyReference=" + this.borrowerPartyReference + ", drawdownNoticeDays=" + this.drawdownNoticeDays + ", fxRateSetNoticeDays=" + this.fxRateSetNoticeDays + ", rateSetNoticeDays=" + this.rateSetNoticeDays + '}' + " " + super.toString();
        }
    }

    public static interface LoanFloatingRateOptionBuilder
    extends LoanFloatingRateOption,
    AbstractLoanFloatingRateOptionBase.AbstractLoanFloatingRateOptionBaseBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public PartyReference.PartyReferenceBuilder getOrCreateBorrowerPartyReference(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getBorrowerPartyReference();

        @Override
        public LoanFloatingRateOptionBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public LoanFloatingRateOptionBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public LoanFloatingRateOptionBuilder setPaymentFrequency(Period var1);

        @Override
        public LoanFloatingRateOptionBuilder setRate(LoanFloatingRate var1);

        public LoanFloatingRateOptionBuilder setCurrency(Currency var1);

        public LoanFloatingRateOptionBuilder setPeriodModel(PeriodModel var1);

        public LoanFloatingRateOptionBuilder addBorrowerPartyReference(PartyReference var1);

        public LoanFloatingRateOptionBuilder addBorrowerPartyReference(PartyReference var1, int var2);

        public LoanFloatingRateOptionBuilder addBorrowerPartyReference(List<? extends PartyReference> var1);

        public LoanFloatingRateOptionBuilder setBorrowerPartyReference(List<? extends PartyReference> var1);

        public LoanFloatingRateOptionBuilder setDrawdownNoticeDays(Integer var1);

        public LoanFloatingRateOptionBuilder setFxRateSetNoticeDays(Integer var1);

        public LoanFloatingRateOptionBuilder setRateSetNoticeDays(Integer var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rate"), processor, LoanFloatingRate.LoanFloatingRateBuilder.class, (RosettaModelObjectBuilder)this.getRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("borrowerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getBorrowerPartyReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("drawdownNoticeDays"), Integer.class, (Object)this.getDrawdownNoticeDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fxRateSetNoticeDays"), Integer.class, (Object)this.getFxRateSetNoticeDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rateSetNoticeDays"), Integer.class, (Object)this.getRateSetNoticeDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public LoanFloatingRateOptionBuilder prune();
    }

    public static class LoanFloatingRateOptionImpl
    extends AbstractLoanFloatingRateOptionBase.AbstractLoanFloatingRateOptionBaseImpl
    implements LoanFloatingRateOption {
        private final Currency currency;
        private final PeriodModel periodModel;
        private final List<? extends PartyReference> borrowerPartyReference;
        private final Integer drawdownNoticeDays;
        private final Integer fxRateSetNoticeDays;
        private final Integer rateSetNoticeDays;

        protected LoanFloatingRateOptionImpl(LoanFloatingRateOptionBuilder builder) {
            super(builder);
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.borrowerPartyReference = Optional.ofNullable(builder.getBorrowerPartyReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.drawdownNoticeDays = builder.getDrawdownNoticeDays();
            this.fxRateSetNoticeDays = builder.getFxRateSetNoticeDays();
            this.rateSetNoticeDays = builder.getRateSetNoticeDays();
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="periodModel")
        @RuneAttribute(value="periodModel")
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="borrowerPartyReference")
        @RuneAttribute(value="borrowerPartyReference")
        public List<? extends PartyReference> getBorrowerPartyReference() {
            return this.borrowerPartyReference;
        }

        @Override
        @RosettaAttribute(value="drawdownNoticeDays")
        @RuneAttribute(value="drawdownNoticeDays")
        public Integer getDrawdownNoticeDays() {
            return this.drawdownNoticeDays;
        }

        @Override
        @RosettaAttribute(value="fxRateSetNoticeDays")
        @RuneAttribute(value="fxRateSetNoticeDays")
        public Integer getFxRateSetNoticeDays() {
            return this.fxRateSetNoticeDays;
        }

        @Override
        @RosettaAttribute(value="rateSetNoticeDays")
        @RuneAttribute(value="rateSetNoticeDays")
        public Integer getRateSetNoticeDays() {
            return this.rateSetNoticeDays;
        }

        @Override
        public LoanFloatingRateOption build() {
            return this;
        }

        @Override
        public LoanFloatingRateOptionBuilder toBuilder() {
            LoanFloatingRateOptionBuilder builder = LoanFloatingRateOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanFloatingRateOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getBorrowerPartyReference()).ifPresent(builder::setBorrowerPartyReference);
            Optional.ofNullable(this.getDrawdownNoticeDays()).ifPresent(builder::setDrawdownNoticeDays);
            Optional.ofNullable(this.getFxRateSetNoticeDays()).ifPresent(builder::setFxRateSetNoticeDays);
            Optional.ofNullable(this.getRateSetNoticeDays()).ifPresent(builder::setRateSetNoticeDays);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanFloatingRateOption _that = (LoanFloatingRateOption)this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.borrowerPartyReference, _that.getBorrowerPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.drawdownNoticeDays, _that.getDrawdownNoticeDays())) {
                return false;
            }
            if (!Objects.equals(this.fxRateSetNoticeDays, _that.getFxRateSetNoticeDays())) {
                return false;
            }
            return Objects.equals(this.rateSetNoticeDays, _that.getRateSetNoticeDays());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.borrowerPartyReference != null ? this.borrowerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.drawdownNoticeDays != null ? this.drawdownNoticeDays.hashCode() : 0);
            _result = 31 * _result + (this.fxRateSetNoticeDays != null ? this.fxRateSetNoticeDays.hashCode() : 0);
            _result = 31 * _result + (this.rateSetNoticeDays != null ? this.rateSetNoticeDays.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanFloatingRateOption {currency=" + this.currency + ", periodModel=" + this.periodModel + ", borrowerPartyReference=" + this.borrowerPartyReference + ", drawdownNoticeDays=" + this.drawdownNoticeDays + ", fxRateSetNoticeDays=" + this.fxRateSetNoticeDays + ", rateSetNoticeDays=" + this.rateSetNoticeDays + '}' + " " + super.toString();
        }
    }
}

