/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CommodityFixedPrice;
import fpml.confirmation.CommodityQuantityFrequency;
import fpml.confirmation.GenericCommodityDeliveryPeriod;
import fpml.confirmation.GenericCommodityGrade;
import fpml.confirmation.InterconnectionPoint;
import fpml.confirmation.LoadTypeEnum;
import fpml.confirmation.meta.GenericCommodityAttributesModelMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="GenericCommodityAttributesModel", builder=GenericCommodityAttributesModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="GenericCommodityAttributesModel", model="fpml", builder=GenericCommodityAttributesModelBuilderImpl.class, version="0.17.2")
public interface GenericCommodityAttributesModel
extends RosettaModelObject {
    public static final GenericCommodityAttributesModelMeta metaData = new GenericCommodityAttributesModelMeta();

    public List<? extends GenericCommodityGrade> getGrade();

    public List<? extends GenericCommodityDeliveryPeriod> getSettlementPeriods();

    public LoadTypeEnum getLoadType();

    public BigDecimal getQuantity();

    public CommodityQuantityFrequency getQuantityFrequency();

    public CommodityFixedPrice getFixedPrice();

    public InterconnectionPoint getInterconnectionPoint();

    public GenericCommodityAttributesModel build();

    public GenericCommodityAttributesModelBuilder toBuilder();

    public static GenericCommodityAttributesModelBuilder builder() {
        return new GenericCommodityAttributesModelBuilderImpl();
    }

    default public RosettaMetaData<? extends GenericCommodityAttributesModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GenericCommodityAttributesModel> getType() {
        return GenericCommodityAttributesModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("grade"), processor, GenericCommodityGrade.class, this.getGrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriods"), processor, GenericCommodityDeliveryPeriod.class, this.getSettlementPeriods(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("loadType"), LoadTypeEnum.class, (Object)this.getLoadType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantity"), BigDecimal.class, (Object)this.getQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantityFrequency"), processor, CommodityQuantityFrequency.class, this.getQuantityFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedPrice"), processor, CommodityFixedPrice.class, this.getFixedPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interconnectionPoint"), processor, InterconnectionPoint.class, this.getInterconnectionPoint(), new AttributeMeta[0]);
    }

    public static class GenericCommodityAttributesModelBuilderImpl
    implements GenericCommodityAttributesModelBuilder {
        protected List<GenericCommodityGrade.GenericCommodityGradeBuilder> grade = new ArrayList<GenericCommodityGrade.GenericCommodityGradeBuilder>();
        protected List<GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder> settlementPeriods = new ArrayList<GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder>();
        protected LoadTypeEnum loadType;
        protected BigDecimal quantity;
        protected CommodityQuantityFrequency.CommodityQuantityFrequencyBuilder quantityFrequency;
        protected CommodityFixedPrice.CommodityFixedPriceBuilder fixedPrice;
        protected InterconnectionPoint.InterconnectionPointBuilder interconnectionPoint;

        @Override
        @RosettaAttribute(value="grade")
        @RuneAttribute(value="grade")
        public List<? extends GenericCommodityGrade.GenericCommodityGradeBuilder> getGrade() {
            return this.grade;
        }

        @Override
        public GenericCommodityGrade.GenericCommodityGradeBuilder getOrCreateGrade(int index) {
            if (this.grade == null) {
                this.grade = new ArrayList<GenericCommodityGrade.GenericCommodityGradeBuilder>();
            }
            return (GenericCommodityGrade.GenericCommodityGradeBuilder)this.getIndex(this.grade, index, () -> {
                GenericCommodityGrade.GenericCommodityGradeBuilder newGrade = GenericCommodityGrade.builder();
                return newGrade;
            });
        }

        @Override
        @RosettaAttribute(value="settlementPeriods")
        @RuneAttribute(value="settlementPeriods")
        public List<? extends GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder> getSettlementPeriods() {
            return this.settlementPeriods;
        }

        @Override
        public GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder getOrCreateSettlementPeriods(int index) {
            if (this.settlementPeriods == null) {
                this.settlementPeriods = new ArrayList<GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder>();
            }
            return (GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder)this.getIndex(this.settlementPeriods, index, () -> {
                GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder newSettlementPeriods = GenericCommodityDeliveryPeriod.builder();
                return newSettlementPeriods;
            });
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public LoadTypeEnum getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public BigDecimal getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="quantityFrequency")
        @RuneAttribute(value="quantityFrequency")
        public CommodityQuantityFrequency.CommodityQuantityFrequencyBuilder getQuantityFrequency() {
            return this.quantityFrequency;
        }

        @Override
        public CommodityQuantityFrequency.CommodityQuantityFrequencyBuilder getOrCreateQuantityFrequency() {
            CommodityQuantityFrequency.CommodityQuantityFrequencyBuilder result = this.quantityFrequency != null ? this.quantityFrequency : (this.quantityFrequency = CommodityQuantityFrequency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedPrice")
        @RuneAttribute(value="fixedPrice")
        public CommodityFixedPrice.CommodityFixedPriceBuilder getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public CommodityFixedPrice.CommodityFixedPriceBuilder getOrCreateFixedPrice() {
            CommodityFixedPrice.CommodityFixedPriceBuilder result = this.fixedPrice != null ? this.fixedPrice : (this.fixedPrice = CommodityFixedPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interconnectionPoint")
        @RuneAttribute(value="interconnectionPoint")
        public InterconnectionPoint.InterconnectionPointBuilder getInterconnectionPoint() {
            return this.interconnectionPoint;
        }

        @Override
        public InterconnectionPoint.InterconnectionPointBuilder getOrCreateInterconnectionPoint() {
            InterconnectionPoint.InterconnectionPointBuilder result = this.interconnectionPoint != null ? this.interconnectionPoint : (this.interconnectionPoint = InterconnectionPoint.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="grade")
        @RuneAttribute(value="grade")
        public GenericCommodityAttributesModelBuilder addGrade(GenericCommodityGrade _grade) {
            if (_grade != null) {
                this.grade.add(_grade.toBuilder());
            }
            return this;
        }

        @Override
        public GenericCommodityAttributesModelBuilder addGrade(GenericCommodityGrade _grade, int idx) {
            this.getIndex(this.grade, idx, () -> _grade.toBuilder());
            return this;
        }

        @Override
        public GenericCommodityAttributesModelBuilder addGrade(List<? extends GenericCommodityGrade> grades) {
            if (grades != null) {
                for (GenericCommodityGrade genericCommodityGrade : grades) {
                    this.grade.add(genericCommodityGrade.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="grade")
        public GenericCommodityAttributesModelBuilder setGrade(List<? extends GenericCommodityGrade> grades) {
            this.grade = grades == null ? new ArrayList<GenericCommodityGrade.GenericCommodityGradeBuilder>() : (List)grades.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriods")
        @RuneAttribute(value="settlementPeriods")
        public GenericCommodityAttributesModelBuilder addSettlementPeriods(GenericCommodityDeliveryPeriod _settlementPeriods) {
            if (_settlementPeriods != null) {
                this.settlementPeriods.add(_settlementPeriods.toBuilder());
            }
            return this;
        }

        @Override
        public GenericCommodityAttributesModelBuilder addSettlementPeriods(GenericCommodityDeliveryPeriod _settlementPeriods, int idx) {
            this.getIndex(this.settlementPeriods, idx, () -> _settlementPeriods.toBuilder());
            return this;
        }

        @Override
        public GenericCommodityAttributesModelBuilder addSettlementPeriods(List<? extends GenericCommodityDeliveryPeriod> settlementPeriodss) {
            if (settlementPeriodss != null) {
                for (GenericCommodityDeliveryPeriod genericCommodityDeliveryPeriod : settlementPeriodss) {
                    this.settlementPeriods.add(genericCommodityDeliveryPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="settlementPeriods")
        public GenericCommodityAttributesModelBuilder setSettlementPeriods(List<? extends GenericCommodityDeliveryPeriod> settlementPeriodss) {
            this.settlementPeriods = settlementPeriodss == null ? new ArrayList<GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder>() : (List)settlementPeriodss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public GenericCommodityAttributesModelBuilder setLoadType(LoadTypeEnum _loadType) {
            this.loadType = _loadType == null ? null : _loadType;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public GenericCommodityAttributesModelBuilder setQuantity(BigDecimal _quantity) {
            this.quantity = _quantity == null ? null : _quantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequency")
        @RuneAttribute(value="quantityFrequency")
        public GenericCommodityAttributesModelBuilder setQuantityFrequency(CommodityQuantityFrequency _quantityFrequency) {
            this.quantityFrequency = _quantityFrequency == null ? null : _quantityFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedPrice")
        @RuneAttribute(value="fixedPrice")
        public GenericCommodityAttributesModelBuilder setFixedPrice(CommodityFixedPrice _fixedPrice) {
            this.fixedPrice = _fixedPrice == null ? null : _fixedPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interconnectionPoint")
        @RuneAttribute(value="interconnectionPoint")
        public GenericCommodityAttributesModelBuilder setInterconnectionPoint(InterconnectionPoint _interconnectionPoint) {
            this.interconnectionPoint = _interconnectionPoint == null ? null : _interconnectionPoint.toBuilder();
            return this;
        }

        @Override
        public GenericCommodityAttributesModel build() {
            return new GenericCommodityAttributesModelImpl(this);
        }

        @Override
        public GenericCommodityAttributesModelBuilder toBuilder() {
            return this;
        }

        @Override
        public GenericCommodityAttributesModelBuilder prune() {
            this.grade = this.grade.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.settlementPeriods = this.settlementPeriods.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.quantityFrequency != null && !this.quantityFrequency.prune().hasData()) {
                this.quantityFrequency = null;
            }
            if (this.fixedPrice != null && !this.fixedPrice.prune().hasData()) {
                this.fixedPrice = null;
            }
            if (this.interconnectionPoint != null && !this.interconnectionPoint.prune().hasData()) {
                this.interconnectionPoint = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getGrade() != null && this.getGrade().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSettlementPeriods() != null && this.getSettlementPeriods().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLoadType() != null) {
                return true;
            }
            if (this.getQuantity() != null) {
                return true;
            }
            if (this.getQuantityFrequency() != null && this.getQuantityFrequency().hasData()) {
                return true;
            }
            if (this.getFixedPrice() != null && this.getFixedPrice().hasData()) {
                return true;
            }
            return this.getInterconnectionPoint() != null && this.getInterconnectionPoint().hasData();
        }

        public GenericCommodityAttributesModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            GenericCommodityAttributesModelBuilder o = (GenericCommodityAttributesModelBuilder)other;
            merger.mergeRosetta(this.getGrade(), o.getGrade(), this::getOrCreateGrade);
            merger.mergeRosetta(this.getSettlementPeriods(), o.getSettlementPeriods(), this::getOrCreateSettlementPeriods);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuantityFrequency(), (RosettaModelObjectBuilder)o.getQuantityFrequency(), this::setQuantityFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedPrice(), (RosettaModelObjectBuilder)o.getFixedPrice(), this::setFixedPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterconnectionPoint(), (RosettaModelObjectBuilder)o.getInterconnectionPoint(), this::setInterconnectionPoint);
            merger.mergeBasic((Object)this.getLoadType(), (Object)o.getLoadType(), this::setLoadType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantity(), (Object)o.getQuantity(), this::setQuantity, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GenericCommodityAttributesModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.grade, _that.getGrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.settlementPeriods, _that.getSettlementPeriods())) {
                return false;
            }
            if (!Objects.equals((Object)this.loadType, (Object)_that.getLoadType())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequency, _that.getQuantityFrequency())) {
                return false;
            }
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            return Objects.equals(this.interconnectionPoint, _that.getInterconnectionPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.grade != null ? this.grade.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriods != null ? this.settlementPeriods.hashCode() : 0);
            _result = 31 * _result + (this.loadType != null ? ((Object)((Object)this.loadType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequency != null ? this.quantityFrequency.hashCode() : 0);
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.interconnectionPoint != null ? this.interconnectionPoint.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GenericCommodityAttributesModelBuilder {grade=" + this.grade + ", settlementPeriods=" + this.settlementPeriods + ", loadType=" + (Object)((Object)this.loadType) + ", quantity=" + this.quantity + ", quantityFrequency=" + this.quantityFrequency + ", fixedPrice=" + this.fixedPrice + ", interconnectionPoint=" + this.interconnectionPoint + '}';
        }
    }

    public static interface GenericCommodityAttributesModelBuilder
    extends GenericCommodityAttributesModel,
    RosettaModelObjectBuilder {
        public GenericCommodityGrade.GenericCommodityGradeBuilder getOrCreateGrade(int var1);

        public List<? extends GenericCommodityGrade.GenericCommodityGradeBuilder> getGrade();

        public GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder getOrCreateSettlementPeriods(int var1);

        public List<? extends GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder> getSettlementPeriods();

        public CommodityQuantityFrequency.CommodityQuantityFrequencyBuilder getOrCreateQuantityFrequency();

        @Override
        public CommodityQuantityFrequency.CommodityQuantityFrequencyBuilder getQuantityFrequency();

        public CommodityFixedPrice.CommodityFixedPriceBuilder getOrCreateFixedPrice();

        @Override
        public CommodityFixedPrice.CommodityFixedPriceBuilder getFixedPrice();

        public InterconnectionPoint.InterconnectionPointBuilder getOrCreateInterconnectionPoint();

        @Override
        public InterconnectionPoint.InterconnectionPointBuilder getInterconnectionPoint();

        public GenericCommodityAttributesModelBuilder addGrade(GenericCommodityGrade var1);

        public GenericCommodityAttributesModelBuilder addGrade(GenericCommodityGrade var1, int var2);

        public GenericCommodityAttributesModelBuilder addGrade(List<? extends GenericCommodityGrade> var1);

        public GenericCommodityAttributesModelBuilder setGrade(List<? extends GenericCommodityGrade> var1);

        public GenericCommodityAttributesModelBuilder addSettlementPeriods(GenericCommodityDeliveryPeriod var1);

        public GenericCommodityAttributesModelBuilder addSettlementPeriods(GenericCommodityDeliveryPeriod var1, int var2);

        public GenericCommodityAttributesModelBuilder addSettlementPeriods(List<? extends GenericCommodityDeliveryPeriod> var1);

        public GenericCommodityAttributesModelBuilder setSettlementPeriods(List<? extends GenericCommodityDeliveryPeriod> var1);

        public GenericCommodityAttributesModelBuilder setLoadType(LoadTypeEnum var1);

        public GenericCommodityAttributesModelBuilder setQuantity(BigDecimal var1);

        public GenericCommodityAttributesModelBuilder setQuantityFrequency(CommodityQuantityFrequency var1);

        public GenericCommodityAttributesModelBuilder setFixedPrice(CommodityFixedPrice var1);

        public GenericCommodityAttributesModelBuilder setInterconnectionPoint(InterconnectionPoint var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("grade"), processor, GenericCommodityGrade.GenericCommodityGradeBuilder.class, this.getGrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriods"), processor, GenericCommodityDeliveryPeriod.GenericCommodityDeliveryPeriodBuilder.class, this.getSettlementPeriods(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("loadType"), LoadTypeEnum.class, (Object)this.getLoadType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantity"), BigDecimal.class, (Object)this.getQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantityFrequency"), processor, CommodityQuantityFrequency.CommodityQuantityFrequencyBuilder.class, this.getQuantityFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedPrice"), processor, CommodityFixedPrice.CommodityFixedPriceBuilder.class, this.getFixedPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interconnectionPoint"), processor, InterconnectionPoint.InterconnectionPointBuilder.class, this.getInterconnectionPoint(), new AttributeMeta[0]);
        }

        public GenericCommodityAttributesModelBuilder prune();
    }

    public static class GenericCommodityAttributesModelImpl
    implements GenericCommodityAttributesModel {
        private final List<? extends GenericCommodityGrade> grade;
        private final List<? extends GenericCommodityDeliveryPeriod> settlementPeriods;
        private final LoadTypeEnum loadType;
        private final BigDecimal quantity;
        private final CommodityQuantityFrequency quantityFrequency;
        private final CommodityFixedPrice fixedPrice;
        private final InterconnectionPoint interconnectionPoint;

        protected GenericCommodityAttributesModelImpl(GenericCommodityAttributesModelBuilder builder) {
            this.grade = Optional.ofNullable(builder.getGrade()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementPeriods = Optional.ofNullable(builder.getSettlementPeriods()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.loadType = builder.getLoadType();
            this.quantity = builder.getQuantity();
            this.quantityFrequency = Optional.ofNullable(builder.getQuantityFrequency()).map(f -> f.build()).orElse(null);
            this.fixedPrice = Optional.ofNullable(builder.getFixedPrice()).map(f -> f.build()).orElse(null);
            this.interconnectionPoint = Optional.ofNullable(builder.getInterconnectionPoint()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="grade")
        @RuneAttribute(value="grade")
        public List<? extends GenericCommodityGrade> getGrade() {
            return this.grade;
        }

        @Override
        @RosettaAttribute(value="settlementPeriods")
        @RuneAttribute(value="settlementPeriods")
        public List<? extends GenericCommodityDeliveryPeriod> getSettlementPeriods() {
            return this.settlementPeriods;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public LoadTypeEnum getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public BigDecimal getQuantity() {
            return this.quantity;
        }

        @Override
        @RosettaAttribute(value="quantityFrequency")
        @RuneAttribute(value="quantityFrequency")
        public CommodityQuantityFrequency getQuantityFrequency() {
            return this.quantityFrequency;
        }

        @Override
        @RosettaAttribute(value="fixedPrice")
        @RuneAttribute(value="fixedPrice")
        public CommodityFixedPrice getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        @RosettaAttribute(value="interconnectionPoint")
        @RuneAttribute(value="interconnectionPoint")
        public InterconnectionPoint getInterconnectionPoint() {
            return this.interconnectionPoint;
        }

        @Override
        public GenericCommodityAttributesModel build() {
            return this;
        }

        @Override
        public GenericCommodityAttributesModelBuilder toBuilder() {
            GenericCommodityAttributesModelBuilder builder = GenericCommodityAttributesModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GenericCommodityAttributesModelBuilder builder) {
            Optional.ofNullable(this.getGrade()).ifPresent(builder::setGrade);
            Optional.ofNullable(this.getSettlementPeriods()).ifPresent(builder::setSettlementPeriods);
            Optional.ofNullable(this.getLoadType()).ifPresent(builder::setLoadType);
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getQuantityFrequency()).ifPresent(builder::setQuantityFrequency);
            Optional.ofNullable(this.getFixedPrice()).ifPresent(builder::setFixedPrice);
            Optional.ofNullable(this.getInterconnectionPoint()).ifPresent(builder::setInterconnectionPoint);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GenericCommodityAttributesModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.grade, _that.getGrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.settlementPeriods, _that.getSettlementPeriods())) {
                return false;
            }
            if (!Objects.equals((Object)this.loadType, (Object)_that.getLoadType())) {
                return false;
            }
            if (!Objects.equals(this.quantity, _that.getQuantity())) {
                return false;
            }
            if (!Objects.equals(this.quantityFrequency, _that.getQuantityFrequency())) {
                return false;
            }
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            return Objects.equals(this.interconnectionPoint, _that.getInterconnectionPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.grade != null ? this.grade.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriods != null ? this.settlementPeriods.hashCode() : 0);
            _result = 31 * _result + (this.loadType != null ? ((Object)((Object)this.loadType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.quantityFrequency != null ? this.quantityFrequency.hashCode() : 0);
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.interconnectionPoint != null ? this.interconnectionPoint.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GenericCommodityAttributesModel {grade=" + this.grade + ", settlementPeriods=" + this.settlementPeriods + ", loadType=" + (Object)((Object)this.loadType) + ", quantity=" + this.quantity + ", quantityFrequency=" + this.quantityFrequency + ", fixedPrice=" + this.fixedPrice + ", interconnectionPoint=" + this.interconnectionPoint + '}';
        }
    }
}

