/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.FxCashSettlementSimple;
import fpml.confirmation.FxExpirySchedule;
import fpml.confirmation.FxInformationSource;
import fpml.confirmation.FxSettlementSchedule;
import fpml.confirmation.FxTarget;
import fpml.confirmation.FxTargetBarrier;
import fpml.confirmation.FxTargetConstantPayoffRegion;
import fpml.confirmation.FxTargetKnockoutForwardChoice;
import fpml.confirmation.FxTargetKnockoutForwardSequence;
import fpml.confirmation.FxTargetLinearPayoffRegion;
import fpml.confirmation.FxTargetSettlementPeriodSchedule;
import fpml.confirmation.NonNegativeAmountSchedule;
import fpml.confirmation.Product;
import fpml.confirmation.ProductModel;
import fpml.confirmation.QuotedCurrencyPair;
import fpml.confirmation.SimplePayment;
import fpml.confirmation.meta.FxTargetKnockoutForwardMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxTargetKnockoutForward", builder=FxTargetKnockoutForwardBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxTargetKnockoutForward", model="fpml", builder=FxTargetKnockoutForwardBuilderImpl.class, version="0.17.2")
public interface FxTargetKnockoutForward
extends Product {
    public static final FxTargetKnockoutForwardMeta metaData = new FxTargetKnockoutForwardMeta();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public NonNegativeAmountSchedule getNotionalAmount();

    public List<? extends FxTarget> getTarget();

    public FxExpirySchedule getExpirySchedule();

    public FxSettlementSchedule getSettlementSchedule();

    public FxInformationSource getFixingInformationSource();

    public BigDecimal getSpotRate();

    public FxTargetKnockoutForwardSequence getFxTargetKnockoutForwardSequence();

    public List<? extends FxTargetConstantPayoffRegion> getConstantPayoffRegion();

    public FxTargetLinearPayoffRegion getLinearPayoffRegion();

    public List<? extends FxTargetKnockoutForwardChoice> getFxTargetKnockoutForwardChoice();

    public List<? extends FxTargetBarrier> getBarrier();

    public List<? extends SimplePayment> getAdditionalPayment();

    public FxCashSettlementSimple getCashSettlement();

    public FxTargetSettlementPeriodSchedule getSettlementPeriodSchedule();

    @Override
    public FxTargetKnockoutForward build();

    @Override
    public FxTargetKnockoutForwardBuilder toBuilder();

    public static FxTargetKnockoutForwardBuilder builder() {
        return new FxTargetKnockoutForwardBuilderImpl();
    }

    default public RosettaMetaData<? extends FxTargetKnockoutForward> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxTargetKnockoutForward> getType() {
        return FxTargetKnockoutForward.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("target"), processor, FxTarget.class, this.getTarget(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirySchedule"), processor, FxExpirySchedule.class, this.getExpirySchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementSchedule"), processor, FxSettlementSchedule.class, this.getSettlementSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingInformationSource"), processor, FxInformationSource.class, this.getFixingInformationSource(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxTargetKnockoutForwardSequence"), processor, FxTargetKnockoutForwardSequence.class, this.getFxTargetKnockoutForwardSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("constantPayoffRegion"), processor, FxTargetConstantPayoffRegion.class, this.getConstantPayoffRegion(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("linearPayoffRegion"), processor, FxTargetLinearPayoffRegion.class, this.getLinearPayoffRegion(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxTargetKnockoutForwardChoice"), processor, FxTargetKnockoutForwardChoice.class, this.getFxTargetKnockoutForwardChoice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, FxTargetBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, SimplePayment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlementSimple.class, this.getCashSettlement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriodSchedule"), processor, FxTargetSettlementPeriodSchedule.class, this.getSettlementPeriodSchedule(), new AttributeMeta[0]);
    }

    public static class FxTargetKnockoutForwardBuilderImpl
    extends Product.ProductBuilderImpl
    implements FxTargetKnockoutForwardBuilder {
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder notionalAmount;
        protected List<FxTarget.FxTargetBuilder> target = new ArrayList<FxTarget.FxTargetBuilder>();
        protected FxExpirySchedule.FxExpiryScheduleBuilder expirySchedule;
        protected FxSettlementSchedule.FxSettlementScheduleBuilder settlementSchedule;
        protected FxInformationSource.FxInformationSourceBuilder fixingInformationSource;
        protected BigDecimal spotRate;
        protected FxTargetKnockoutForwardSequence.FxTargetKnockoutForwardSequenceBuilder fxTargetKnockoutForwardSequence;
        protected List<FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder> constantPayoffRegion = new ArrayList<FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder>();
        protected FxTargetLinearPayoffRegion.FxTargetLinearPayoffRegionBuilder linearPayoffRegion;
        protected List<FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder> fxTargetKnockoutForwardChoice = new ArrayList<FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder>();
        protected List<FxTargetBarrier.FxTargetBarrierBuilder> barrier = new ArrayList<FxTargetBarrier.FxTargetBarrierBuilder>();
        protected List<SimplePayment.SimplePaymentBuilder> additionalPayment = new ArrayList<SimplePayment.SimplePaymentBuilder>();
        protected FxCashSettlementSimple.FxCashSettlementSimpleBuilder cashSettlement;
        protected FxTargetSettlementPeriodSchedule.FxTargetSettlementPeriodScheduleBuilder settlementPeriodSchedule;

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount() {
            NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = NonNegativeAmountSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="target", isRequired=true)
        @RuneAttribute(value="target", isRequired=true)
        public List<? extends FxTarget.FxTargetBuilder> getTarget() {
            return this.target;
        }

        @Override
        public FxTarget.FxTargetBuilder getOrCreateTarget(int index) {
            if (this.target == null) {
                this.target = new ArrayList<FxTarget.FxTargetBuilder>();
            }
            return (FxTarget.FxTargetBuilder)this.getIndex(this.target, index, () -> {
                FxTarget.FxTargetBuilder newTarget = FxTarget.builder();
                return newTarget;
            });
        }

        @Override
        @RosettaAttribute(value="expirySchedule", isRequired=true)
        @RuneAttribute(value="expirySchedule", isRequired=true)
        public FxExpirySchedule.FxExpiryScheduleBuilder getExpirySchedule() {
            return this.expirySchedule;
        }

        @Override
        public FxExpirySchedule.FxExpiryScheduleBuilder getOrCreateExpirySchedule() {
            FxExpirySchedule.FxExpiryScheduleBuilder result = this.expirySchedule != null ? this.expirySchedule : (this.expirySchedule = FxExpirySchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementSchedule", isRequired=true)
        @RuneAttribute(value="settlementSchedule", isRequired=true)
        public FxSettlementSchedule.FxSettlementScheduleBuilder getSettlementSchedule() {
            return this.settlementSchedule;
        }

        @Override
        public FxSettlementSchedule.FxSettlementScheduleBuilder getOrCreateSettlementSchedule() {
            FxSettlementSchedule.FxSettlementScheduleBuilder result = this.settlementSchedule != null ? this.settlementSchedule : (this.settlementSchedule = FxSettlementSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingInformationSource", isRequired=true)
        @RuneAttribute(value="fixingInformationSource", isRequired=true)
        public FxInformationSource.FxInformationSourceBuilder getFixingInformationSource() {
            return this.fixingInformationSource;
        }

        @Override
        public FxInformationSource.FxInformationSourceBuilder getOrCreateFixingInformationSource() {
            FxInformationSource.FxInformationSourceBuilder result = this.fixingInformationSource != null ? this.fixingInformationSource : (this.fixingInformationSource = FxInformationSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="fxTargetKnockoutForwardSequence")
        @RuneAttribute(value="fxTargetKnockoutForwardSequence")
        public FxTargetKnockoutForwardSequence.FxTargetKnockoutForwardSequenceBuilder getFxTargetKnockoutForwardSequence() {
            return this.fxTargetKnockoutForwardSequence;
        }

        @Override
        public FxTargetKnockoutForwardSequence.FxTargetKnockoutForwardSequenceBuilder getOrCreateFxTargetKnockoutForwardSequence() {
            FxTargetKnockoutForwardSequence.FxTargetKnockoutForwardSequenceBuilder result = this.fxTargetKnockoutForwardSequence != null ? this.fxTargetKnockoutForwardSequence : (this.fxTargetKnockoutForwardSequence = FxTargetKnockoutForwardSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="constantPayoffRegion")
        @RuneAttribute(value="constantPayoffRegion")
        public List<? extends FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder> getConstantPayoffRegion() {
            return this.constantPayoffRegion;
        }

        @Override
        public FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder getOrCreateConstantPayoffRegion(int index) {
            if (this.constantPayoffRegion == null) {
                this.constantPayoffRegion = new ArrayList<FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder>();
            }
            return (FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder)this.getIndex(this.constantPayoffRegion, index, () -> {
                FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder newConstantPayoffRegion = FxTargetConstantPayoffRegion.builder();
                return newConstantPayoffRegion;
            });
        }

        @Override
        @RosettaAttribute(value="linearPayoffRegion", isRequired=true)
        @RuneAttribute(value="linearPayoffRegion", isRequired=true)
        public FxTargetLinearPayoffRegion.FxTargetLinearPayoffRegionBuilder getLinearPayoffRegion() {
            return this.linearPayoffRegion;
        }

        @Override
        public FxTargetLinearPayoffRegion.FxTargetLinearPayoffRegionBuilder getOrCreateLinearPayoffRegion() {
            FxTargetLinearPayoffRegion.FxTargetLinearPayoffRegionBuilder result = this.linearPayoffRegion != null ? this.linearPayoffRegion : (this.linearPayoffRegion = FxTargetLinearPayoffRegion.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxTargetKnockoutForwardChoice")
        @RuneAttribute(value="fxTargetKnockoutForwardChoice")
        public List<? extends FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder> getFxTargetKnockoutForwardChoice() {
            return this.fxTargetKnockoutForwardChoice;
        }

        @Override
        public FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder getOrCreateFxTargetKnockoutForwardChoice(int index) {
            if (this.fxTargetKnockoutForwardChoice == null) {
                this.fxTargetKnockoutForwardChoice = new ArrayList<FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder>();
            }
            return (FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder)this.getIndex(this.fxTargetKnockoutForwardChoice, index, () -> {
                FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder newFxTargetKnockoutForwardChoice = FxTargetKnockoutForwardChoice.builder();
                return newFxTargetKnockoutForwardChoice;
            });
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxTargetBarrier.FxTargetBarrierBuilder> getBarrier() {
            return this.barrier;
        }

        @Override
        public FxTargetBarrier.FxTargetBarrierBuilder getOrCreateBarrier(int index) {
            if (this.barrier == null) {
                this.barrier = new ArrayList<FxTargetBarrier.FxTargetBarrierBuilder>();
            }
            return (FxTargetBarrier.FxTargetBarrierBuilder)this.getIndex(this.barrier, index, () -> {
                FxTargetBarrier.FxTargetBarrierBuilder newBarrier = FxTargetBarrier.builder();
                return newBarrier;
            });
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends SimplePayment.SimplePaymentBuilder> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public SimplePayment.SimplePaymentBuilder getOrCreateAdditionalPayment(int index) {
            if (this.additionalPayment == null) {
                this.additionalPayment = new ArrayList<SimplePayment.SimplePaymentBuilder>();
            }
            return (SimplePayment.SimplePaymentBuilder)this.getIndex(this.additionalPayment, index, () -> {
                SimplePayment.SimplePaymentBuilder newAdditionalPayment = SimplePayment.builder();
                return newAdditionalPayment;
            });
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getOrCreateCashSettlement() {
            FxCashSettlementSimple.FxCashSettlementSimpleBuilder result = this.cashSettlement != null ? this.cashSettlement : (this.cashSettlement = FxCashSettlementSimple.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodSchedule")
        @RuneAttribute(value="settlementPeriodSchedule")
        public FxTargetSettlementPeriodSchedule.FxTargetSettlementPeriodScheduleBuilder getSettlementPeriodSchedule() {
            return this.settlementPeriodSchedule;
        }

        @Override
        public FxTargetSettlementPeriodSchedule.FxTargetSettlementPeriodScheduleBuilder getOrCreateSettlementPeriodSchedule() {
            FxTargetSettlementPeriodSchedule.FxTargetSettlementPeriodScheduleBuilder result = this.settlementPeriodSchedule != null ? this.settlementPeriodSchedule : (this.settlementPeriodSchedule = FxTargetSettlementPeriodSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FxTargetKnockoutForwardBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxTargetKnockoutForwardBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public FxTargetKnockoutForwardBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public FxTargetKnockoutForwardBuilder setNotionalAmount(NonNegativeAmountSchedule _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="target", isRequired=true)
        @RuneAttribute(value="target", isRequired=true)
        public FxTargetKnockoutForwardBuilder addTarget(FxTarget _target) {
            if (_target != null) {
                this.target.add(_target.toBuilder());
            }
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addTarget(FxTarget _target, int idx) {
            this.getIndex(this.target, idx, () -> _target.toBuilder());
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addTarget(List<? extends FxTarget> targets) {
            if (targets != null) {
                for (FxTarget fxTarget : targets) {
                    this.target.add(fxTarget.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="target")
        public FxTargetKnockoutForwardBuilder setTarget(List<? extends FxTarget> targets) {
            this.target = targets == null ? new ArrayList<FxTarget.FxTargetBuilder>() : (List)targets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="expirySchedule", isRequired=true)
        @RuneAttribute(value="expirySchedule", isRequired=true)
        public FxTargetKnockoutForwardBuilder setExpirySchedule(FxExpirySchedule _expirySchedule) {
            this.expirySchedule = _expirySchedule == null ? null : _expirySchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementSchedule", isRequired=true)
        @RuneAttribute(value="settlementSchedule", isRequired=true)
        public FxTargetKnockoutForwardBuilder setSettlementSchedule(FxSettlementSchedule _settlementSchedule) {
            this.settlementSchedule = _settlementSchedule == null ? null : _settlementSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingInformationSource", isRequired=true)
        @RuneAttribute(value="fixingInformationSource", isRequired=true)
        public FxTargetKnockoutForwardBuilder setFixingInformationSource(FxInformationSource _fixingInformationSource) {
            this.fixingInformationSource = _fixingInformationSource == null ? null : _fixingInformationSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxTargetKnockoutForwardBuilder setSpotRate(BigDecimal _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxTargetKnockoutForwardSequence")
        @RuneAttribute(value="fxTargetKnockoutForwardSequence")
        public FxTargetKnockoutForwardBuilder setFxTargetKnockoutForwardSequence(FxTargetKnockoutForwardSequence _fxTargetKnockoutForwardSequence) {
            this.fxTargetKnockoutForwardSequence = _fxTargetKnockoutForwardSequence == null ? null : _fxTargetKnockoutForwardSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="constantPayoffRegion")
        @RuneAttribute(value="constantPayoffRegion")
        public FxTargetKnockoutForwardBuilder addConstantPayoffRegion(FxTargetConstantPayoffRegion _constantPayoffRegion) {
            if (_constantPayoffRegion != null) {
                this.constantPayoffRegion.add(_constantPayoffRegion.toBuilder());
            }
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addConstantPayoffRegion(FxTargetConstantPayoffRegion _constantPayoffRegion, int idx) {
            this.getIndex(this.constantPayoffRegion, idx, () -> _constantPayoffRegion.toBuilder());
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addConstantPayoffRegion(List<? extends FxTargetConstantPayoffRegion> constantPayoffRegions) {
            if (constantPayoffRegions != null) {
                for (FxTargetConstantPayoffRegion fxTargetConstantPayoffRegion : constantPayoffRegions) {
                    this.constantPayoffRegion.add(fxTargetConstantPayoffRegion.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="constantPayoffRegion")
        public FxTargetKnockoutForwardBuilder setConstantPayoffRegion(List<? extends FxTargetConstantPayoffRegion> constantPayoffRegions) {
            this.constantPayoffRegion = constantPayoffRegions == null ? new ArrayList<FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder>() : (List)constantPayoffRegions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="linearPayoffRegion", isRequired=true)
        @RuneAttribute(value="linearPayoffRegion", isRequired=true)
        public FxTargetKnockoutForwardBuilder setLinearPayoffRegion(FxTargetLinearPayoffRegion _linearPayoffRegion) {
            this.linearPayoffRegion = _linearPayoffRegion == null ? null : _linearPayoffRegion.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxTargetKnockoutForwardChoice")
        @RuneAttribute(value="fxTargetKnockoutForwardChoice")
        public FxTargetKnockoutForwardBuilder addFxTargetKnockoutForwardChoice(FxTargetKnockoutForwardChoice _fxTargetKnockoutForwardChoice) {
            if (_fxTargetKnockoutForwardChoice != null) {
                this.fxTargetKnockoutForwardChoice.add(_fxTargetKnockoutForwardChoice.toBuilder());
            }
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addFxTargetKnockoutForwardChoice(FxTargetKnockoutForwardChoice _fxTargetKnockoutForwardChoice, int idx) {
            this.getIndex(this.fxTargetKnockoutForwardChoice, idx, () -> _fxTargetKnockoutForwardChoice.toBuilder());
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addFxTargetKnockoutForwardChoice(List<? extends FxTargetKnockoutForwardChoice> fxTargetKnockoutForwardChoices) {
            if (fxTargetKnockoutForwardChoices != null) {
                for (FxTargetKnockoutForwardChoice fxTargetKnockoutForwardChoice : fxTargetKnockoutForwardChoices) {
                    this.fxTargetKnockoutForwardChoice.add(fxTargetKnockoutForwardChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fxTargetKnockoutForwardChoice")
        public FxTargetKnockoutForwardBuilder setFxTargetKnockoutForwardChoice(List<? extends FxTargetKnockoutForwardChoice> fxTargetKnockoutForwardChoices) {
            this.fxTargetKnockoutForwardChoice = fxTargetKnockoutForwardChoices == null ? new ArrayList<FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder>() : (List)fxTargetKnockoutForwardChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxTargetKnockoutForwardBuilder addBarrier(FxTargetBarrier _barrier) {
            if (_barrier != null) {
                this.barrier.add(_barrier.toBuilder());
            }
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addBarrier(FxTargetBarrier _barrier, int idx) {
            this.getIndex(this.barrier, idx, () -> _barrier.toBuilder());
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addBarrier(List<? extends FxTargetBarrier> barriers) {
            if (barriers != null) {
                for (FxTargetBarrier fxTargetBarrier : barriers) {
                    this.barrier.add(fxTargetBarrier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="barrier")
        public FxTargetKnockoutForwardBuilder setBarrier(List<? extends FxTargetBarrier> barriers) {
            this.barrier = barriers == null ? new ArrayList<FxTargetBarrier.FxTargetBarrierBuilder>() : (List)barriers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public FxTargetKnockoutForwardBuilder addAdditionalPayment(SimplePayment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addAdditionalPayment(SimplePayment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder addAdditionalPayment(List<? extends SimplePayment> additionalPayments) {
            if (additionalPayments != null) {
                for (SimplePayment simplePayment : additionalPayments) {
                    this.additionalPayment.add(simplePayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public FxTargetKnockoutForwardBuilder setAdditionalPayment(List<? extends SimplePayment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList<SimplePayment.SimplePaymentBuilder>() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxTargetKnockoutForwardBuilder setCashSettlement(FxCashSettlementSimple _cashSettlement) {
            this.cashSettlement = _cashSettlement == null ? null : _cashSettlement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodSchedule")
        @RuneAttribute(value="settlementPeriodSchedule")
        public FxTargetKnockoutForwardBuilder setSettlementPeriodSchedule(FxTargetSettlementPeriodSchedule _settlementPeriodSchedule) {
            this.settlementPeriodSchedule = _settlementPeriodSchedule == null ? null : _settlementPeriodSchedule.toBuilder();
            return this;
        }

        @Override
        public FxTargetKnockoutForward build() {
            return new FxTargetKnockoutForwardImpl(this);
        }

        @Override
        public FxTargetKnockoutForwardBuilder toBuilder() {
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder prune() {
            super.prune();
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            this.target = this.target.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.expirySchedule != null && !this.expirySchedule.prune().hasData()) {
                this.expirySchedule = null;
            }
            if (this.settlementSchedule != null && !this.settlementSchedule.prune().hasData()) {
                this.settlementSchedule = null;
            }
            if (this.fixingInformationSource != null && !this.fixingInformationSource.prune().hasData()) {
                this.fixingInformationSource = null;
            }
            if (this.fxTargetKnockoutForwardSequence != null && !this.fxTargetKnockoutForwardSequence.prune().hasData()) {
                this.fxTargetKnockoutForwardSequence = null;
            }
            this.constantPayoffRegion = this.constantPayoffRegion.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.linearPayoffRegion != null && !this.linearPayoffRegion.prune().hasData()) {
                this.linearPayoffRegion = null;
            }
            this.fxTargetKnockoutForwardChoice = this.fxTargetKnockoutForwardChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.barrier = this.barrier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.additionalPayment = this.additionalPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.cashSettlement != null && !this.cashSettlement.prune().hasData()) {
                this.cashSettlement = null;
            }
            if (this.settlementPeriodSchedule != null && !this.settlementPeriodSchedule.prune().hasData()) {
                this.settlementPeriodSchedule = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            if (this.getTarget() != null && this.getTarget().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getExpirySchedule() != null && this.getExpirySchedule().hasData()) {
                return true;
            }
            if (this.getSettlementSchedule() != null && this.getSettlementSchedule().hasData()) {
                return true;
            }
            if (this.getFixingInformationSource() != null && this.getFixingInformationSource().hasData()) {
                return true;
            }
            if (this.getSpotRate() != null) {
                return true;
            }
            if (this.getFxTargetKnockoutForwardSequence() != null && this.getFxTargetKnockoutForwardSequence().hasData()) {
                return true;
            }
            if (this.getConstantPayoffRegion() != null && this.getConstantPayoffRegion().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLinearPayoffRegion() != null && this.getLinearPayoffRegion().hasData()) {
                return true;
            }
            if (this.getFxTargetKnockoutForwardChoice() != null && this.getFxTargetKnockoutForwardChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAdditionalPayment() != null && this.getAdditionalPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCashSettlement() != null && this.getCashSettlement().hasData()) {
                return true;
            }
            return this.getSettlementPeriodSchedule() != null && this.getSettlementPeriodSchedule().hasData();
        }

        @Override
        public FxTargetKnockoutForwardBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxTargetKnockoutForwardBuilder o = (FxTargetKnockoutForwardBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta(this.getTarget(), o.getTarget(), this::getOrCreateTarget);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirySchedule(), (RosettaModelObjectBuilder)o.getExpirySchedule(), this::setExpirySchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementSchedule(), (RosettaModelObjectBuilder)o.getSettlementSchedule(), this::setSettlementSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingInformationSource(), (RosettaModelObjectBuilder)o.getFixingInformationSource(), this::setFixingInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxTargetKnockoutForwardSequence(), (RosettaModelObjectBuilder)o.getFxTargetKnockoutForwardSequence(), this::setFxTargetKnockoutForwardSequence);
            merger.mergeRosetta(this.getConstantPayoffRegion(), o.getConstantPayoffRegion(), this::getOrCreateConstantPayoffRegion);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLinearPayoffRegion(), (RosettaModelObjectBuilder)o.getLinearPayoffRegion(), this::setLinearPayoffRegion);
            merger.mergeRosetta(this.getFxTargetKnockoutForwardChoice(), o.getFxTargetKnockoutForwardChoice(), this::getOrCreateFxTargetKnockoutForwardChoice);
            merger.mergeRosetta(this.getBarrier(), o.getBarrier(), this::getOrCreateBarrier);
            merger.mergeRosetta(this.getAdditionalPayment(), o.getAdditionalPayment(), this::getOrCreateAdditionalPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashSettlement(), (RosettaModelObjectBuilder)o.getCashSettlement(), this::setCashSettlement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementPeriodSchedule(), (RosettaModelObjectBuilder)o.getSettlementPeriodSchedule(), this::setSettlementPeriodSchedule);
            merger.mergeBasic((Object)this.getSpotRate(), (Object)o.getSpotRate(), this::setSpotRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxTargetKnockoutForward _that = (FxTargetKnockoutForward)this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.target, _that.getTarget())) {
                return false;
            }
            if (!Objects.equals(this.expirySchedule, _that.getExpirySchedule())) {
                return false;
            }
            if (!Objects.equals(this.settlementSchedule, _that.getSettlementSchedule())) {
                return false;
            }
            if (!Objects.equals(this.fixingInformationSource, _that.getFixingInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!Objects.equals(this.fxTargetKnockoutForwardSequence, _that.getFxTargetKnockoutForwardSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.constantPayoffRegion, _that.getConstantPayoffRegion())) {
                return false;
            }
            if (!Objects.equals(this.linearPayoffRegion, _that.getLinearPayoffRegion())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fxTargetKnockoutForwardChoice, _that.getFxTargetKnockoutForwardChoice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlement, _that.getCashSettlement())) {
                return false;
            }
            return Objects.equals(this.settlementPeriodSchedule, _that.getSettlementPeriodSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.target != null ? this.target.hashCode() : 0);
            _result = 31 * _result + (this.expirySchedule != null ? this.expirySchedule.hashCode() : 0);
            _result = 31 * _result + (this.settlementSchedule != null ? this.settlementSchedule.hashCode() : 0);
            _result = 31 * _result + (this.fixingInformationSource != null ? this.fixingInformationSource.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.fxTargetKnockoutForwardSequence != null ? this.fxTargetKnockoutForwardSequence.hashCode() : 0);
            _result = 31 * _result + (this.constantPayoffRegion != null ? this.constantPayoffRegion.hashCode() : 0);
            _result = 31 * _result + (this.linearPayoffRegion != null ? this.linearPayoffRegion.hashCode() : 0);
            _result = 31 * _result + (this.fxTargetKnockoutForwardChoice != null ? this.fxTargetKnockoutForwardChoice.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodSchedule != null ? this.settlementPeriodSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxTargetKnockoutForwardBuilder {quotedCurrencyPair=" + this.quotedCurrencyPair + ", notionalAmount=" + this.notionalAmount + ", target=" + this.target + ", expirySchedule=" + this.expirySchedule + ", settlementSchedule=" + this.settlementSchedule + ", fixingInformationSource=" + this.fixingInformationSource + ", spotRate=" + this.spotRate + ", fxTargetKnockoutForwardSequence=" + this.fxTargetKnockoutForwardSequence + ", constantPayoffRegion=" + this.constantPayoffRegion + ", linearPayoffRegion=" + this.linearPayoffRegion + ", fxTargetKnockoutForwardChoice=" + this.fxTargetKnockoutForwardChoice + ", barrier=" + this.barrier + ", additionalPayment=" + this.additionalPayment + ", cashSettlement=" + this.cashSettlement + ", settlementPeriodSchedule=" + this.settlementPeriodSchedule + '}' + " " + super.toString();
        }
    }

    public static interface FxTargetKnockoutForwardBuilder
    extends FxTargetKnockoutForward,
    Product.ProductBuilder {
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount();

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount();

        public FxTarget.FxTargetBuilder getOrCreateTarget(int var1);

        public List<? extends FxTarget.FxTargetBuilder> getTarget();

        public FxExpirySchedule.FxExpiryScheduleBuilder getOrCreateExpirySchedule();

        @Override
        public FxExpirySchedule.FxExpiryScheduleBuilder getExpirySchedule();

        public FxSettlementSchedule.FxSettlementScheduleBuilder getOrCreateSettlementSchedule();

        @Override
        public FxSettlementSchedule.FxSettlementScheduleBuilder getSettlementSchedule();

        public FxInformationSource.FxInformationSourceBuilder getOrCreateFixingInformationSource();

        @Override
        public FxInformationSource.FxInformationSourceBuilder getFixingInformationSource();

        public FxTargetKnockoutForwardSequence.FxTargetKnockoutForwardSequenceBuilder getOrCreateFxTargetKnockoutForwardSequence();

        @Override
        public FxTargetKnockoutForwardSequence.FxTargetKnockoutForwardSequenceBuilder getFxTargetKnockoutForwardSequence();

        public FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder getOrCreateConstantPayoffRegion(int var1);

        public List<? extends FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder> getConstantPayoffRegion();

        public FxTargetLinearPayoffRegion.FxTargetLinearPayoffRegionBuilder getOrCreateLinearPayoffRegion();

        @Override
        public FxTargetLinearPayoffRegion.FxTargetLinearPayoffRegionBuilder getLinearPayoffRegion();

        public FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder getOrCreateFxTargetKnockoutForwardChoice(int var1);

        public List<? extends FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder> getFxTargetKnockoutForwardChoice();

        public FxTargetBarrier.FxTargetBarrierBuilder getOrCreateBarrier(int var1);

        public List<? extends FxTargetBarrier.FxTargetBarrierBuilder> getBarrier();

        public SimplePayment.SimplePaymentBuilder getOrCreateAdditionalPayment(int var1);

        public List<? extends SimplePayment.SimplePaymentBuilder> getAdditionalPayment();

        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getOrCreateCashSettlement();

        @Override
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getCashSettlement();

        public FxTargetSettlementPeriodSchedule.FxTargetSettlementPeriodScheduleBuilder getOrCreateSettlementPeriodSchedule();

        @Override
        public FxTargetSettlementPeriodSchedule.FxTargetSettlementPeriodScheduleBuilder getSettlementPeriodSchedule();

        @Override
        public FxTargetKnockoutForwardBuilder setProductModel(ProductModel var1);

        @Override
        public FxTargetKnockoutForwardBuilder setId(String var1);

        public FxTargetKnockoutForwardBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public FxTargetKnockoutForwardBuilder setNotionalAmount(NonNegativeAmountSchedule var1);

        public FxTargetKnockoutForwardBuilder addTarget(FxTarget var1);

        public FxTargetKnockoutForwardBuilder addTarget(FxTarget var1, int var2);

        public FxTargetKnockoutForwardBuilder addTarget(List<? extends FxTarget> var1);

        public FxTargetKnockoutForwardBuilder setTarget(List<? extends FxTarget> var1);

        public FxTargetKnockoutForwardBuilder setExpirySchedule(FxExpirySchedule var1);

        public FxTargetKnockoutForwardBuilder setSettlementSchedule(FxSettlementSchedule var1);

        public FxTargetKnockoutForwardBuilder setFixingInformationSource(FxInformationSource var1);

        public FxTargetKnockoutForwardBuilder setSpotRate(BigDecimal var1);

        public FxTargetKnockoutForwardBuilder setFxTargetKnockoutForwardSequence(FxTargetKnockoutForwardSequence var1);

        public FxTargetKnockoutForwardBuilder addConstantPayoffRegion(FxTargetConstantPayoffRegion var1);

        public FxTargetKnockoutForwardBuilder addConstantPayoffRegion(FxTargetConstantPayoffRegion var1, int var2);

        public FxTargetKnockoutForwardBuilder addConstantPayoffRegion(List<? extends FxTargetConstantPayoffRegion> var1);

        public FxTargetKnockoutForwardBuilder setConstantPayoffRegion(List<? extends FxTargetConstantPayoffRegion> var1);

        public FxTargetKnockoutForwardBuilder setLinearPayoffRegion(FxTargetLinearPayoffRegion var1);

        public FxTargetKnockoutForwardBuilder addFxTargetKnockoutForwardChoice(FxTargetKnockoutForwardChoice var1);

        public FxTargetKnockoutForwardBuilder addFxTargetKnockoutForwardChoice(FxTargetKnockoutForwardChoice var1, int var2);

        public FxTargetKnockoutForwardBuilder addFxTargetKnockoutForwardChoice(List<? extends FxTargetKnockoutForwardChoice> var1);

        public FxTargetKnockoutForwardBuilder setFxTargetKnockoutForwardChoice(List<? extends FxTargetKnockoutForwardChoice> var1);

        public FxTargetKnockoutForwardBuilder addBarrier(FxTargetBarrier var1);

        public FxTargetKnockoutForwardBuilder addBarrier(FxTargetBarrier var1, int var2);

        public FxTargetKnockoutForwardBuilder addBarrier(List<? extends FxTargetBarrier> var1);

        public FxTargetKnockoutForwardBuilder setBarrier(List<? extends FxTargetBarrier> var1);

        public FxTargetKnockoutForwardBuilder addAdditionalPayment(SimplePayment var1);

        public FxTargetKnockoutForwardBuilder addAdditionalPayment(SimplePayment var1, int var2);

        public FxTargetKnockoutForwardBuilder addAdditionalPayment(List<? extends SimplePayment> var1);

        public FxTargetKnockoutForwardBuilder setAdditionalPayment(List<? extends SimplePayment> var1);

        public FxTargetKnockoutForwardBuilder setCashSettlement(FxCashSettlementSimple var1);

        public FxTargetKnockoutForwardBuilder setSettlementPeriodSchedule(FxTargetSettlementPeriodSchedule var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("target"), processor, FxTarget.FxTargetBuilder.class, this.getTarget(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirySchedule"), processor, FxExpirySchedule.FxExpiryScheduleBuilder.class, this.getExpirySchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementSchedule"), processor, FxSettlementSchedule.FxSettlementScheduleBuilder.class, this.getSettlementSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingInformationSource"), processor, FxInformationSource.FxInformationSourceBuilder.class, this.getFixingInformationSource(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxTargetKnockoutForwardSequence"), processor, FxTargetKnockoutForwardSequence.FxTargetKnockoutForwardSequenceBuilder.class, this.getFxTargetKnockoutForwardSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("constantPayoffRegion"), processor, FxTargetConstantPayoffRegion.FxTargetConstantPayoffRegionBuilder.class, this.getConstantPayoffRegion(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("linearPayoffRegion"), processor, FxTargetLinearPayoffRegion.FxTargetLinearPayoffRegionBuilder.class, this.getLinearPayoffRegion(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxTargetKnockoutForwardChoice"), processor, FxTargetKnockoutForwardChoice.FxTargetKnockoutForwardChoiceBuilder.class, this.getFxTargetKnockoutForwardChoice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, FxTargetBarrier.FxTargetBarrierBuilder.class, this.getBarrier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, SimplePayment.SimplePaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlementSimple.FxCashSettlementSimpleBuilder.class, this.getCashSettlement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriodSchedule"), processor, FxTargetSettlementPeriodSchedule.FxTargetSettlementPeriodScheduleBuilder.class, this.getSettlementPeriodSchedule(), new AttributeMeta[0]);
        }

        @Override
        public FxTargetKnockoutForwardBuilder prune();
    }

    public static class FxTargetKnockoutForwardImpl
    extends Product.ProductImpl
    implements FxTargetKnockoutForward {
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final NonNegativeAmountSchedule notionalAmount;
        private final List<? extends FxTarget> target;
        private final FxExpirySchedule expirySchedule;
        private final FxSettlementSchedule settlementSchedule;
        private final FxInformationSource fixingInformationSource;
        private final BigDecimal spotRate;
        private final FxTargetKnockoutForwardSequence fxTargetKnockoutForwardSequence;
        private final List<? extends FxTargetConstantPayoffRegion> constantPayoffRegion;
        private final FxTargetLinearPayoffRegion linearPayoffRegion;
        private final List<? extends FxTargetKnockoutForwardChoice> fxTargetKnockoutForwardChoice;
        private final List<? extends FxTargetBarrier> barrier;
        private final List<? extends SimplePayment> additionalPayment;
        private final FxCashSettlementSimple cashSettlement;
        private final FxTargetSettlementPeriodSchedule settlementPeriodSchedule;

        protected FxTargetKnockoutForwardImpl(FxTargetKnockoutForwardBuilder builder) {
            super(builder);
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.target = Optional.ofNullable(builder.getTarget()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.expirySchedule = Optional.ofNullable(builder.getExpirySchedule()).map(f -> f.build()).orElse(null);
            this.settlementSchedule = Optional.ofNullable(builder.getSettlementSchedule()).map(f -> f.build()).orElse(null);
            this.fixingInformationSource = Optional.ofNullable(builder.getFixingInformationSource()).map(f -> f.build()).orElse(null);
            this.spotRate = builder.getSpotRate();
            this.fxTargetKnockoutForwardSequence = Optional.ofNullable(builder.getFxTargetKnockoutForwardSequence()).map(f -> f.build()).orElse(null);
            this.constantPayoffRegion = Optional.ofNullable(builder.getConstantPayoffRegion()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.linearPayoffRegion = Optional.ofNullable(builder.getLinearPayoffRegion()).map(f -> f.build()).orElse(null);
            this.fxTargetKnockoutForwardChoice = Optional.ofNullable(builder.getFxTargetKnockoutForwardChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.barrier = Optional.ofNullable(builder.getBarrier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.additionalPayment = Optional.ofNullable(builder.getAdditionalPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.cashSettlement = Optional.ofNullable(builder.getCashSettlement()).map(f -> f.build()).orElse(null);
            this.settlementPeriodSchedule = Optional.ofNullable(builder.getSettlementPeriodSchedule()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="target", isRequired=true)
        @RuneAttribute(value="target", isRequired=true)
        public List<? extends FxTarget> getTarget() {
            return this.target;
        }

        @Override
        @RosettaAttribute(value="expirySchedule", isRequired=true)
        @RuneAttribute(value="expirySchedule", isRequired=true)
        public FxExpirySchedule getExpirySchedule() {
            return this.expirySchedule;
        }

        @Override
        @RosettaAttribute(value="settlementSchedule", isRequired=true)
        @RuneAttribute(value="settlementSchedule", isRequired=true)
        public FxSettlementSchedule getSettlementSchedule() {
            return this.settlementSchedule;
        }

        @Override
        @RosettaAttribute(value="fixingInformationSource", isRequired=true)
        @RuneAttribute(value="fixingInformationSource", isRequired=true)
        public FxInformationSource getFixingInformationSource() {
            return this.fixingInformationSource;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="fxTargetKnockoutForwardSequence")
        @RuneAttribute(value="fxTargetKnockoutForwardSequence")
        public FxTargetKnockoutForwardSequence getFxTargetKnockoutForwardSequence() {
            return this.fxTargetKnockoutForwardSequence;
        }

        @Override
        @RosettaAttribute(value="constantPayoffRegion")
        @RuneAttribute(value="constantPayoffRegion")
        public List<? extends FxTargetConstantPayoffRegion> getConstantPayoffRegion() {
            return this.constantPayoffRegion;
        }

        @Override
        @RosettaAttribute(value="linearPayoffRegion", isRequired=true)
        @RuneAttribute(value="linearPayoffRegion", isRequired=true)
        public FxTargetLinearPayoffRegion getLinearPayoffRegion() {
            return this.linearPayoffRegion;
        }

        @Override
        @RosettaAttribute(value="fxTargetKnockoutForwardChoice")
        @RuneAttribute(value="fxTargetKnockoutForwardChoice")
        public List<? extends FxTargetKnockoutForwardChoice> getFxTargetKnockoutForwardChoice() {
            return this.fxTargetKnockoutForwardChoice;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxTargetBarrier> getBarrier() {
            return this.barrier;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends SimplePayment> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlementSimple getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodSchedule")
        @RuneAttribute(value="settlementPeriodSchedule")
        public FxTargetSettlementPeriodSchedule getSettlementPeriodSchedule() {
            return this.settlementPeriodSchedule;
        }

        @Override
        public FxTargetKnockoutForward build() {
            return this;
        }

        @Override
        public FxTargetKnockoutForwardBuilder toBuilder() {
            FxTargetKnockoutForwardBuilder builder = FxTargetKnockoutForward.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxTargetKnockoutForwardBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getTarget()).ifPresent(builder::setTarget);
            Optional.ofNullable(this.getExpirySchedule()).ifPresent(builder::setExpirySchedule);
            Optional.ofNullable(this.getSettlementSchedule()).ifPresent(builder::setSettlementSchedule);
            Optional.ofNullable(this.getFixingInformationSource()).ifPresent(builder::setFixingInformationSource);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
            Optional.ofNullable(this.getFxTargetKnockoutForwardSequence()).ifPresent(builder::setFxTargetKnockoutForwardSequence);
            Optional.ofNullable(this.getConstantPayoffRegion()).ifPresent(builder::setConstantPayoffRegion);
            Optional.ofNullable(this.getLinearPayoffRegion()).ifPresent(builder::setLinearPayoffRegion);
            Optional.ofNullable(this.getFxTargetKnockoutForwardChoice()).ifPresent(builder::setFxTargetKnockoutForwardChoice);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
            Optional.ofNullable(this.getAdditionalPayment()).ifPresent(builder::setAdditionalPayment);
            Optional.ofNullable(this.getCashSettlement()).ifPresent(builder::setCashSettlement);
            Optional.ofNullable(this.getSettlementPeriodSchedule()).ifPresent(builder::setSettlementPeriodSchedule);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxTargetKnockoutForward _that = (FxTargetKnockoutForward)this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!ListEquals.listEquals(this.target, _that.getTarget())) {
                return false;
            }
            if (!Objects.equals(this.expirySchedule, _that.getExpirySchedule())) {
                return false;
            }
            if (!Objects.equals(this.settlementSchedule, _that.getSettlementSchedule())) {
                return false;
            }
            if (!Objects.equals(this.fixingInformationSource, _that.getFixingInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!Objects.equals(this.fxTargetKnockoutForwardSequence, _that.getFxTargetKnockoutForwardSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.constantPayoffRegion, _that.getConstantPayoffRegion())) {
                return false;
            }
            if (!Objects.equals(this.linearPayoffRegion, _that.getLinearPayoffRegion())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fxTargetKnockoutForwardChoice, _that.getFxTargetKnockoutForwardChoice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlement, _that.getCashSettlement())) {
                return false;
            }
            return Objects.equals(this.settlementPeriodSchedule, _that.getSettlementPeriodSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.target != null ? this.target.hashCode() : 0);
            _result = 31 * _result + (this.expirySchedule != null ? this.expirySchedule.hashCode() : 0);
            _result = 31 * _result + (this.settlementSchedule != null ? this.settlementSchedule.hashCode() : 0);
            _result = 31 * _result + (this.fixingInformationSource != null ? this.fixingInformationSource.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.fxTargetKnockoutForwardSequence != null ? this.fxTargetKnockoutForwardSequence.hashCode() : 0);
            _result = 31 * _result + (this.constantPayoffRegion != null ? this.constantPayoffRegion.hashCode() : 0);
            _result = 31 * _result + (this.linearPayoffRegion != null ? this.linearPayoffRegion.hashCode() : 0);
            _result = 31 * _result + (this.fxTargetKnockoutForwardChoice != null ? this.fxTargetKnockoutForwardChoice.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodSchedule != null ? this.settlementPeriodSchedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxTargetKnockoutForward {quotedCurrencyPair=" + this.quotedCurrencyPair + ", notionalAmount=" + this.notionalAmount + ", target=" + this.target + ", expirySchedule=" + this.expirySchedule + ", settlementSchedule=" + this.settlementSchedule + ", fixingInformationSource=" + this.fixingInformationSource + ", spotRate=" + this.spotRate + ", fxTargetKnockoutForwardSequence=" + this.fxTargetKnockoutForwardSequence + ", constantPayoffRegion=" + this.constantPayoffRegion + ", linearPayoffRegion=" + this.linearPayoffRegion + ", fxTargetKnockoutForwardChoice=" + this.fxTargetKnockoutForwardChoice + ", barrier=" + this.barrier + ", additionalPayment=" + this.additionalPayment + ", cashSettlement=" + this.cashSettlement + ", settlementPeriodSchedule=" + this.settlementPeriodSchedule + '}' + " " + super.toString();
        }
    }
}

