/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.FxAccrualRegion;
import fpml.confirmation.FxFixingSchedule;
import fpml.confirmation.FxRateObservable;
import fpml.confirmation.meta.FxAccrualMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxAccrual", builder=FxAccrualBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxAccrual", model="fpml", builder=FxAccrualBuilderImpl.class, version="0.17.2")
public interface FxAccrual
extends RosettaModelObject {
    public static final FxAccrualMeta metaData = new FxAccrualMeta();

    public List<? extends FxRateObservable> getObservable();

    public List<? extends FxAccrualRegion> getAccrualRegion();

    public FxFixingSchedule getFixingSchedule();

    public String getId();

    public FxAccrual build();

    public FxAccrualBuilder toBuilder();

    public static FxAccrualBuilder builder() {
        return new FxAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAccrual> getType() {
        return FxAccrual.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("observable"), processor, FxRateObservable.class, this.getObservable(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualRegion"), processor, FxAccrualRegion.class, this.getAccrualRegion(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingSchedule"), processor, FxFixingSchedule.class, this.getFixingSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxAccrualBuilderImpl
    implements FxAccrualBuilder {
        protected List<FxRateObservable.FxRateObservableBuilder> observable = new ArrayList<FxRateObservable.FxRateObservableBuilder>();
        protected List<FxAccrualRegion.FxAccrualRegionBuilder> accrualRegion = new ArrayList<FxAccrualRegion.FxAccrualRegionBuilder>();
        protected FxFixingSchedule.FxFixingScheduleBuilder fixingSchedule;
        protected String id;

        @Override
        @RosettaAttribute(value="observable", isRequired=true)
        @RuneAttribute(value="observable", isRequired=true)
        public List<? extends FxRateObservable.FxRateObservableBuilder> getObservable() {
            return this.observable;
        }

        @Override
        public FxRateObservable.FxRateObservableBuilder getOrCreateObservable(int index) {
            if (this.observable == null) {
                this.observable = new ArrayList<FxRateObservable.FxRateObservableBuilder>();
            }
            return (FxRateObservable.FxRateObservableBuilder)this.getIndex(this.observable, index, () -> {
                FxRateObservable.FxRateObservableBuilder newObservable = FxRateObservable.builder();
                return newObservable;
            });
        }

        @Override
        @RosettaAttribute(value="accrualRegion", isRequired=true)
        @RuneAttribute(value="accrualRegion", isRequired=true)
        public List<? extends FxAccrualRegion.FxAccrualRegionBuilder> getAccrualRegion() {
            return this.accrualRegion;
        }

        @Override
        public FxAccrualRegion.FxAccrualRegionBuilder getOrCreateAccrualRegion(int index) {
            if (this.accrualRegion == null) {
                this.accrualRegion = new ArrayList<FxAccrualRegion.FxAccrualRegionBuilder>();
            }
            return (FxAccrualRegion.FxAccrualRegionBuilder)this.getIndex(this.accrualRegion, index, () -> {
                FxAccrualRegion.FxAccrualRegionBuilder newAccrualRegion = FxAccrualRegion.builder();
                return newAccrualRegion;
            });
        }

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxFixingSchedule.FxFixingScheduleBuilder getFixingSchedule() {
            return this.fixingSchedule;
        }

        @Override
        public FxFixingSchedule.FxFixingScheduleBuilder getOrCreateFixingSchedule() {
            FxFixingSchedule.FxFixingScheduleBuilder result = this.fixingSchedule != null ? this.fixingSchedule : (this.fixingSchedule = FxFixingSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="observable", isRequired=true)
        @RuneAttribute(value="observable", isRequired=true)
        public FxAccrualBuilder addObservable(FxRateObservable _observable) {
            if (_observable != null) {
                this.observable.add(_observable.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualBuilder addObservable(FxRateObservable _observable, int idx) {
            this.getIndex(this.observable, idx, () -> _observable.toBuilder());
            return this;
        }

        @Override
        public FxAccrualBuilder addObservable(List<? extends FxRateObservable> observables) {
            if (observables != null) {
                for (FxRateObservable fxRateObservable : observables) {
                    this.observable.add(fxRateObservable.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observable")
        public FxAccrualBuilder setObservable(List<? extends FxRateObservable> observables) {
            this.observable = observables == null ? new ArrayList<FxRateObservable.FxRateObservableBuilder>() : (List)observables.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualRegion", isRequired=true)
        @RuneAttribute(value="accrualRegion", isRequired=true)
        public FxAccrualBuilder addAccrualRegion(FxAccrualRegion _accrualRegion) {
            if (_accrualRegion != null) {
                this.accrualRegion.add(_accrualRegion.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualBuilder addAccrualRegion(FxAccrualRegion _accrualRegion, int idx) {
            this.getIndex(this.accrualRegion, idx, () -> _accrualRegion.toBuilder());
            return this;
        }

        @Override
        public FxAccrualBuilder addAccrualRegion(List<? extends FxAccrualRegion> accrualRegions) {
            if (accrualRegions != null) {
                for (FxAccrualRegion fxAccrualRegion : accrualRegions) {
                    this.accrualRegion.add(fxAccrualRegion.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accrualRegion")
        public FxAccrualBuilder setAccrualRegion(List<? extends FxAccrualRegion> accrualRegions) {
            this.accrualRegion = accrualRegions == null ? new ArrayList<FxAccrualRegion.FxAccrualRegionBuilder>() : (List)accrualRegions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxAccrualBuilder setFixingSchedule(FxFixingSchedule _fixingSchedule) {
            this.fixingSchedule = _fixingSchedule == null ? null : _fixingSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxAccrualBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public FxAccrual build() {
            return new FxAccrualImpl(this);
        }

        @Override
        public FxAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAccrualBuilder prune() {
            this.observable = this.observable.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.accrualRegion = this.accrualRegion.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fixingSchedule != null && !this.fixingSchedule.prune().hasData()) {
                this.fixingSchedule = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservable() != null && this.getObservable().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAccrualRegion() != null && this.getAccrualRegion().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFixingSchedule() != null && this.getFixingSchedule().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public FxAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxAccrualBuilder o = (FxAccrualBuilder)other;
            merger.mergeRosetta(this.getObservable(), o.getObservable(), this::getOrCreateObservable);
            merger.mergeRosetta(this.getAccrualRegion(), o.getAccrualRegion(), this::getOrCreateAccrualRegion);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingSchedule(), (RosettaModelObjectBuilder)o.getFixingSchedule(), this::setFixingSchedule);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxAccrual _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!ListEquals.listEquals(this.accrualRegion, _that.getAccrualRegion())) {
                return false;
            }
            if (!Objects.equals(this.fixingSchedule, _that.getFixingSchedule())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.accrualRegion != null ? this.accrualRegion.hashCode() : 0);
            _result = 31 * _result + (this.fixingSchedule != null ? this.fixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxAccrualBuilder {observable=" + this.observable + ", accrualRegion=" + this.accrualRegion + ", fixingSchedule=" + this.fixingSchedule + ", id=" + this.id + '}';
        }
    }

    public static interface FxAccrualBuilder
    extends FxAccrual,
    RosettaModelObjectBuilder {
        public FxRateObservable.FxRateObservableBuilder getOrCreateObservable(int var1);

        public List<? extends FxRateObservable.FxRateObservableBuilder> getObservable();

        public FxAccrualRegion.FxAccrualRegionBuilder getOrCreateAccrualRegion(int var1);

        public List<? extends FxAccrualRegion.FxAccrualRegionBuilder> getAccrualRegion();

        public FxFixingSchedule.FxFixingScheduleBuilder getOrCreateFixingSchedule();

        @Override
        public FxFixingSchedule.FxFixingScheduleBuilder getFixingSchedule();

        public FxAccrualBuilder addObservable(FxRateObservable var1);

        public FxAccrualBuilder addObservable(FxRateObservable var1, int var2);

        public FxAccrualBuilder addObservable(List<? extends FxRateObservable> var1);

        public FxAccrualBuilder setObservable(List<? extends FxRateObservable> var1);

        public FxAccrualBuilder addAccrualRegion(FxAccrualRegion var1);

        public FxAccrualBuilder addAccrualRegion(FxAccrualRegion var1, int var2);

        public FxAccrualBuilder addAccrualRegion(List<? extends FxAccrualRegion> var1);

        public FxAccrualBuilder setAccrualRegion(List<? extends FxAccrualRegion> var1);

        public FxAccrualBuilder setFixingSchedule(FxFixingSchedule var1);

        public FxAccrualBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("observable"), processor, FxRateObservable.FxRateObservableBuilder.class, this.getObservable(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualRegion"), processor, FxAccrualRegion.FxAccrualRegionBuilder.class, this.getAccrualRegion(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingSchedule"), processor, FxFixingSchedule.FxFixingScheduleBuilder.class, this.getFixingSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FxAccrualBuilder prune();
    }

    public static class FxAccrualImpl
    implements FxAccrual {
        private final List<? extends FxRateObservable> observable;
        private final List<? extends FxAccrualRegion> accrualRegion;
        private final FxFixingSchedule fixingSchedule;
        private final String id;

        protected FxAccrualImpl(FxAccrualBuilder builder) {
            this.observable = Optional.ofNullable(builder.getObservable()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.accrualRegion = Optional.ofNullable(builder.getAccrualRegion()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fixingSchedule = Optional.ofNullable(builder.getFixingSchedule()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="observable", isRequired=true)
        @RuneAttribute(value="observable", isRequired=true)
        public List<? extends FxRateObservable> getObservable() {
            return this.observable;
        }

        @Override
        @RosettaAttribute(value="accrualRegion", isRequired=true)
        @RuneAttribute(value="accrualRegion", isRequired=true)
        public List<? extends FxAccrualRegion> getAccrualRegion() {
            return this.accrualRegion;
        }

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxFixingSchedule getFixingSchedule() {
            return this.fixingSchedule;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public FxAccrual build() {
            return this;
        }

        @Override
        public FxAccrualBuilder toBuilder() {
            FxAccrualBuilder builder = FxAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAccrualBuilder builder) {
            Optional.ofNullable(this.getObservable()).ifPresent(builder::setObservable);
            Optional.ofNullable(this.getAccrualRegion()).ifPresent(builder::setAccrualRegion);
            Optional.ofNullable(this.getFixingSchedule()).ifPresent(builder::setFixingSchedule);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxAccrual _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!ListEquals.listEquals(this.accrualRegion, _that.getAccrualRegion())) {
                return false;
            }
            if (!Objects.equals(this.fixingSchedule, _that.getFixingSchedule())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.accrualRegion != null ? this.accrualRegion.hashCode() : 0);
            _result = 31 * _result + (this.fixingSchedule != null ? this.fixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxAccrual {observable=" + this.observable + ", accrualRegion=" + this.accrualRegion + ", fixingSchedule=" + this.fixingSchedule + ", id=" + this.id + '}';
        }
    }
}

