/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.PaymentBase;
import fpml.confirmation.RelativeDateOffset;
import fpml.confirmation.meta.FixedPaymentAmountMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FixedPaymentAmount", builder=FixedPaymentAmountBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FixedPaymentAmount", model="fpml", builder=FixedPaymentAmountBuilderImpl.class, version="0.17.2")
public interface FixedPaymentAmount
extends PaymentBase {
    public static final FixedPaymentAmountMeta metaData = new FixedPaymentAmountMeta();

    public NonNegativeMoney getPaymentAmount();

    public RelativeDateOffset getPaymentDate();

    @Override
    public FixedPaymentAmount build();

    @Override
    public FixedPaymentAmountBuilder toBuilder();

    public static FixedPaymentAmountBuilder builder() {
        return new FixedPaymentAmountBuilderImpl();
    }

    default public RosettaMetaData<? extends FixedPaymentAmount> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FixedPaymentAmount> getType() {
        return FixedPaymentAmount.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, RelativeDateOffset.class, this.getPaymentDate(), new AttributeMeta[0]);
    }

    public static class FixedPaymentAmountBuilderImpl
    extends PaymentBase.PaymentBaseBuilderImpl
    implements FixedPaymentAmountBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder paymentAmount;
        protected RelativeDateOffset.RelativeDateOffsetBuilder paymentDate;

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public NonNegativeMoney.NonNegativeMoneyBuilder getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePaymentAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.paymentAmount != null ? this.paymentAmount : (this.paymentAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public RelativeDateOffset.RelativeDateOffsetBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreatePaymentDate() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = RelativeDateOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FixedPaymentAmountBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public FixedPaymentAmountBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public FixedPaymentAmountBuilder setPaymentDate(RelativeDateOffset _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        public FixedPaymentAmount build() {
            return new FixedPaymentAmountImpl(this);
        }

        @Override
        public FixedPaymentAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public FixedPaymentAmountBuilder prune() {
            super.prune();
            if (this.paymentAmount != null && !this.paymentAmount.prune().hasData()) {
                this.paymentAmount = null;
            }
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPaymentAmount() != null && this.getPaymentAmount().hasData()) {
                return true;
            }
            return this.getPaymentDate() != null && this.getPaymentDate().hasData();
        }

        @Override
        public FixedPaymentAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FixedPaymentAmountBuilder o = (FixedPaymentAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentAmount(), (RosettaModelObjectBuilder)o.getPaymentAmount(), this::setPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPaymentAmount _that = (FixedPaymentAmount)this.getType().cast(o);
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.paymentDate, _that.getPaymentDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPaymentAmountBuilder {paymentAmount=" + this.paymentAmount + ", paymentDate=" + this.paymentDate + '}' + " " + super.toString();
        }
    }

    public static interface FixedPaymentAmountBuilder
    extends FixedPaymentAmount,
    PaymentBase.PaymentBaseBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePaymentAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getPaymentAmount();

        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreatePaymentDate();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getPaymentDate();

        @Override
        public FixedPaymentAmountBuilder setId(String var1);

        public FixedPaymentAmountBuilder setPaymentAmount(NonNegativeMoney var1);

        public FixedPaymentAmountBuilder setPaymentDate(RelativeDateOffset var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
        }

        @Override
        public FixedPaymentAmountBuilder prune();
    }

    public static class FixedPaymentAmountImpl
    extends PaymentBase.PaymentBaseImpl
    implements FixedPaymentAmount {
        private final NonNegativeMoney paymentAmount;
        private final RelativeDateOffset paymentDate;

        protected FixedPaymentAmountImpl(FixedPaymentAmountBuilder builder) {
            super(builder);
            this.paymentAmount = Optional.ofNullable(builder.getPaymentAmount()).map(f -> f.build()).orElse(null);
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public NonNegativeMoney getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public RelativeDateOffset getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public FixedPaymentAmount build() {
            return this;
        }

        @Override
        public FixedPaymentAmountBuilder toBuilder() {
            FixedPaymentAmountBuilder builder = FixedPaymentAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FixedPaymentAmountBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentAmount()).ifPresent(builder::setPaymentAmount);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPaymentAmount _that = (FixedPaymentAmount)this.getType().cast(o);
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.paymentDate, _that.getPaymentDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPaymentAmount {paymentAmount=" + this.paymentAmount + ", paymentDate=" + this.paymentDate + '}' + " " + super.toString();
        }
    }
}

