/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.BusinessCenterTime;
import fpml.confirmation.Currency;
import fpml.confirmation.DualCurrencyStrikePrice;
import fpml.confirmation.meta.DualCurrencyFeatureMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="DualCurrencyFeature", builder=DualCurrencyFeatureBuilderImpl.class, version="0.17.2")
@RuneDataType(value="DualCurrencyFeature", model="fpml", builder=DualCurrencyFeatureBuilderImpl.class, version="0.17.2")
public interface DualCurrencyFeature
extends RosettaModelObject {
    public static final DualCurrencyFeatureMeta metaData = new DualCurrencyFeatureMeta();

    public Currency getCurrency();

    public ZonedDateTime getFixingDate();

    public BusinessCenterTime getFixingTime();

    public DualCurrencyStrikePrice getStrike();

    public BigDecimal getSpotRate();

    public Boolean getInterestAtRisk();

    public DualCurrencyFeature build();

    public DualCurrencyFeatureBuilder toBuilder();

    public static DualCurrencyFeatureBuilder builder() {
        return new DualCurrencyFeatureBuilderImpl();
    }

    default public RosettaMetaData<? extends DualCurrencyFeature> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DualCurrencyFeature> getType() {
        return DualCurrencyFeature.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.class, this.getFixingTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, DualCurrencyStrikePrice.class, this.getStrike(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("interestAtRisk"), Boolean.class, (Object)this.getInterestAtRisk(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DualCurrencyFeatureBuilderImpl
    implements DualCurrencyFeatureBuilder {
        protected Currency.CurrencyBuilder currency;
        protected ZonedDateTime fixingDate;
        protected BusinessCenterTime.BusinessCenterTimeBuilder fixingTime;
        protected DualCurrencyStrikePrice.DualCurrencyStrikePriceBuilder strike;
        protected BigDecimal spotRate;
        protected Boolean interestAtRisk;

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public ZonedDateTime getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime() {
            return this.fixingTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.fixingTime != null ? this.fixingTime : (this.fixingTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public DualCurrencyStrikePrice.DualCurrencyStrikePriceBuilder getStrike() {
            return this.strike;
        }

        @Override
        public DualCurrencyStrikePrice.DualCurrencyStrikePriceBuilder getOrCreateStrike() {
            DualCurrencyStrikePrice.DualCurrencyStrikePriceBuilder result = this.strike != null ? this.strike : (this.strike = DualCurrencyStrikePrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="interestAtRisk", isRequired=true)
        @RuneAttribute(value="interestAtRisk", isRequired=true)
        public Boolean getInterestAtRisk() {
            return this.interestAtRisk;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public DualCurrencyFeatureBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public DualCurrencyFeatureBuilder setFixingDate(ZonedDateTime _fixingDate) {
            this.fixingDate = _fixingDate == null ? null : _fixingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public DualCurrencyFeatureBuilder setFixingTime(BusinessCenterTime _fixingTime) {
            this.fixingTime = _fixingTime == null ? null : _fixingTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public DualCurrencyFeatureBuilder setStrike(DualCurrencyStrikePrice _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public DualCurrencyFeatureBuilder setSpotRate(BigDecimal _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="interestAtRisk", isRequired=true)
        @RuneAttribute(value="interestAtRisk", isRequired=true)
        public DualCurrencyFeatureBuilder setInterestAtRisk(Boolean _interestAtRisk) {
            this.interestAtRisk = _interestAtRisk == null ? null : _interestAtRisk;
            return this;
        }

        @Override
        public DualCurrencyFeature build() {
            return new DualCurrencyFeatureImpl(this);
        }

        @Override
        public DualCurrencyFeatureBuilder toBuilder() {
            return this;
        }

        @Override
        public DualCurrencyFeatureBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.fixingTime != null && !this.fixingTime.prune().hasData()) {
                this.fixingTime = null;
            }
            if (this.strike != null && !this.strike.prune().hasData()) {
                this.strike = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            if (this.getFixingDate() != null) {
                return true;
            }
            if (this.getFixingTime() != null && this.getFixingTime().hasData()) {
                return true;
            }
            if (this.getStrike() != null && this.getStrike().hasData()) {
                return true;
            }
            if (this.getSpotRate() != null) {
                return true;
            }
            return this.getInterestAtRisk() != null;
        }

        public DualCurrencyFeatureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DualCurrencyFeatureBuilder o = (DualCurrencyFeatureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingTime(), (RosettaModelObjectBuilder)o.getFixingTime(), this::setFixingTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrike(), (RosettaModelObjectBuilder)o.getStrike(), this::setStrike);
            merger.mergeBasic((Object)this.getFixingDate(), (Object)o.getFixingDate(), this::setFixingDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpotRate(), (Object)o.getSpotRate(), this::setSpotRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInterestAtRisk(), (Object)o.getInterestAtRisk(), this::setInterestAtRisk, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DualCurrencyFeature _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.fixingTime, _that.getFixingTime())) {
                return false;
            }
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            return Objects.equals(this.interestAtRisk, _that.getInterestAtRisk());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.interestAtRisk != null ? this.interestAtRisk.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DualCurrencyFeatureBuilder {currency=" + this.currency + ", fixingDate=" + this.fixingDate + ", fixingTime=" + this.fixingTime + ", strike=" + this.strike + ", spotRate=" + this.spotRate + ", interestAtRisk=" + this.interestAtRisk + '}';
        }
    }

    public static interface DualCurrencyFeatureBuilder
    extends DualCurrencyFeature,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime();

        public DualCurrencyStrikePrice.DualCurrencyStrikePriceBuilder getOrCreateStrike();

        @Override
        public DualCurrencyStrikePrice.DualCurrencyStrikePriceBuilder getStrike();

        public DualCurrencyFeatureBuilder setCurrency(Currency var1);

        public DualCurrencyFeatureBuilder setFixingDate(ZonedDateTime var1);

        public DualCurrencyFeatureBuilder setFixingTime(BusinessCenterTime var1);

        public DualCurrencyFeatureBuilder setStrike(DualCurrencyStrikePrice var1);

        public DualCurrencyFeatureBuilder setSpotRate(BigDecimal var1);

        public DualCurrencyFeatureBuilder setInterestAtRisk(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getFixingTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, DualCurrencyStrikePrice.DualCurrencyStrikePriceBuilder.class, this.getStrike(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("interestAtRisk"), Boolean.class, (Object)this.getInterestAtRisk(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public DualCurrencyFeatureBuilder prune();
    }

    public static class DualCurrencyFeatureImpl
    implements DualCurrencyFeature {
        private final Currency currency;
        private final ZonedDateTime fixingDate;
        private final BusinessCenterTime fixingTime;
        private final DualCurrencyStrikePrice strike;
        private final BigDecimal spotRate;
        private final Boolean interestAtRisk;

        protected DualCurrencyFeatureImpl(DualCurrencyFeatureBuilder builder) {
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.fixingDate = builder.getFixingDate();
            this.fixingTime = Optional.ofNullable(builder.getFixingTime()).map(f -> f.build()).orElse(null);
            this.strike = Optional.ofNullable(builder.getStrike()).map(f -> f.build()).orElse(null);
            this.spotRate = builder.getSpotRate();
            this.interestAtRisk = builder.getInterestAtRisk();
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public ZonedDateTime getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public BusinessCenterTime getFixingTime() {
            return this.fixingTime;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public DualCurrencyStrikePrice getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="interestAtRisk", isRequired=true)
        @RuneAttribute(value="interestAtRisk", isRequired=true)
        public Boolean getInterestAtRisk() {
            return this.interestAtRisk;
        }

        @Override
        public DualCurrencyFeature build() {
            return this;
        }

        @Override
        public DualCurrencyFeatureBuilder toBuilder() {
            DualCurrencyFeatureBuilder builder = DualCurrencyFeature.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DualCurrencyFeatureBuilder builder) {
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getFixingDate()).ifPresent(builder::setFixingDate);
            Optional.ofNullable(this.getFixingTime()).ifPresent(builder::setFixingTime);
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
            Optional.ofNullable(this.getInterestAtRisk()).ifPresent(builder::setInterestAtRisk);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DualCurrencyFeature _that = this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.fixingTime, _that.getFixingTime())) {
                return false;
            }
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            return Objects.equals(this.interestAtRisk, _that.getInterestAtRisk());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.interestAtRisk != null ? this.interestAtRisk.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DualCurrencyFeature {currency=" + this.currency + ", fixingDate=" + this.fixingDate + ", fixingTime=" + this.fixingTime + ", strike=" + this.strike + ", spotRate=" + this.spotRate + ", interestAtRisk=" + this.interestAtRisk + '}';
        }
    }
}

