/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AbstractLoanStatement;
import fpml.confirmation.CorrelationAndSequenceModel;
import fpml.confirmation.CovenantObligationDetailsModel;
import fpml.confirmation.Deal;
import fpml.confirmation.DealDetailsModel;
import fpml.confirmation.FacilityDetailsModel;
import fpml.confirmation.OnBehalfOfModel;
import fpml.confirmation.Party;
import fpml.confirmation.RequestMessageHeader;
import fpml.confirmation.ValidationModel;
import fpml.confirmation.meta.DealStatementMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DealStatement", builder=DealStatementBuilderImpl.class, version="0.17.2")
@RuneDataType(value="DealStatement", model="fpml", builder=DealStatementBuilderImpl.class, version="0.17.2")
public interface DealStatement
extends AbstractLoanStatement {
    public static final DealStatementMeta metaData = new DealStatementMeta();

    public Deal getDeal();

    public List<? extends DealDetailsModel> getDealDetailsModel();

    public List<? extends CovenantObligationDetailsModel> getCovenantObligationDetailsModel();

    public List<? extends FacilityDetailsModel> getFacilityDetailsModel();

    public List<? extends Party> getParty();

    @Override
    public DealStatement build();

    @Override
    public DealStatementBuilder toBuilder();

    public static DealStatementBuilder builder() {
        return new DealStatementBuilderImpl();
    }

    default public RosettaMetaData<? extends DealStatement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DealStatement> getType() {
        return DealStatement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deal"), processor, Deal.class, this.getDeal(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.class, this.getDealDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("covenantObligationDetailsModel"), processor, CovenantObligationDetailsModel.class, this.getCovenantObligationDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class DealStatementBuilderImpl
    extends AbstractLoanStatement.AbstractLoanStatementBuilderImpl
    implements DealStatementBuilder {
        protected Deal.DealBuilder deal;
        protected List<DealDetailsModel.DealDetailsModelBuilder> dealDetailsModel = new ArrayList<DealDetailsModel.DealDetailsModelBuilder>();
        protected List<CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder> covenantObligationDetailsModel = new ArrayList<CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder>();
        protected List<FacilityDetailsModel.FacilityDetailsModelBuilder> facilityDetailsModel = new ArrayList<FacilityDetailsModel.FacilityDetailsModelBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="deal", isRequired=true)
        @RuneAttribute(value="deal", isRequired=true)
        public Deal.DealBuilder getDeal() {
            return this.deal;
        }

        @Override
        public Deal.DealBuilder getOrCreateDeal() {
            Deal.DealBuilder result = this.deal != null ? this.deal : (this.deal = Deal.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public List<? extends DealDetailsModel.DealDetailsModelBuilder> getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel(int index) {
            if (this.dealDetailsModel == null) {
                this.dealDetailsModel = new ArrayList<DealDetailsModel.DealDetailsModelBuilder>();
            }
            return (DealDetailsModel.DealDetailsModelBuilder)this.getIndex(this.dealDetailsModel, index, () -> {
                DealDetailsModel.DealDetailsModelBuilder newDealDetailsModel = DealDetailsModel.builder();
                return newDealDetailsModel;
            });
        }

        @Override
        @RosettaAttribute(value="covenantObligationDetailsModel")
        @RuneAttribute(value="covenantObligationDetailsModel")
        public List<? extends CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder> getCovenantObligationDetailsModel() {
            return this.covenantObligationDetailsModel;
        }

        @Override
        public CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder getOrCreateCovenantObligationDetailsModel(int index) {
            if (this.covenantObligationDetailsModel == null) {
                this.covenantObligationDetailsModel = new ArrayList<CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder>();
            }
            return (CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder)this.getIndex(this.covenantObligationDetailsModel, index, () -> {
                CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder newCovenantObligationDetailsModel = CovenantObligationDetailsModel.builder();
                return newCovenantObligationDetailsModel;
            });
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel")
        @RuneAttribute(value="facilityDetailsModel")
        public List<? extends FacilityDetailsModel.FacilityDetailsModelBuilder> getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel(int index) {
            if (this.facilityDetailsModel == null) {
                this.facilityDetailsModel = new ArrayList<FacilityDetailsModel.FacilityDetailsModelBuilder>();
            }
            return (FacilityDetailsModel.FacilityDetailsModelBuilder)this.getIndex(this.facilityDetailsModel, index, () -> {
                FacilityDetailsModel.FacilityDetailsModelBuilder newFacilityDetailsModel = FacilityDetailsModel.builder();
                return newFacilityDetailsModel;
            });
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public DealStatementBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public DealStatementBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public DealStatementBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public DealStatementBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public DealStatementBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection", isRequired=true)
        @RuneAttribute(value="isCorrection", isRequired=true)
        public DealStatementBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public DealStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public DealStatementBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="statementDate", isRequired=true)
        @RuneAttribute(value="statementDate", isRequired=true)
        public DealStatementBuilder setStatementDate(ZonedDateTime _statementDate) {
            this.statementDate = _statementDate == null ? null : _statementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="comments")
        @RuneAttribute(value="comments")
        public DealStatementBuilder setComments(String _comments) {
            this.comments = _comments == null ? null : _comments;
            return this;
        }

        @Override
        @RosettaAttribute(value="deal", isRequired=true)
        @RuneAttribute(value="deal", isRequired=true)
        public DealStatementBuilder setDeal(Deal _deal) {
            this.deal = _deal == null ? null : _deal.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealStatementBuilder addDealDetailsModel(DealDetailsModel _dealDetailsModel) {
            if (_dealDetailsModel != null) {
                this.dealDetailsModel.add(_dealDetailsModel.toBuilder());
            }
            return this;
        }

        @Override
        public DealStatementBuilder addDealDetailsModel(DealDetailsModel _dealDetailsModel, int idx) {
            this.getIndex(this.dealDetailsModel, idx, () -> _dealDetailsModel.toBuilder());
            return this;
        }

        @Override
        public DealStatementBuilder addDealDetailsModel(List<? extends DealDetailsModel> dealDetailsModels) {
            if (dealDetailsModels != null) {
                for (DealDetailsModel dealDetailsModel : dealDetailsModels) {
                    this.dealDetailsModel.add(dealDetailsModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dealDetailsModel")
        public DealStatementBuilder setDealDetailsModel(List<? extends DealDetailsModel> dealDetailsModels) {
            this.dealDetailsModel = dealDetailsModels == null ? new ArrayList<DealDetailsModel.DealDetailsModelBuilder>() : (List)dealDetailsModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="covenantObligationDetailsModel")
        @RuneAttribute(value="covenantObligationDetailsModel")
        public DealStatementBuilder addCovenantObligationDetailsModel(CovenantObligationDetailsModel _covenantObligationDetailsModel) {
            if (_covenantObligationDetailsModel != null) {
                this.covenantObligationDetailsModel.add(_covenantObligationDetailsModel.toBuilder());
            }
            return this;
        }

        @Override
        public DealStatementBuilder addCovenantObligationDetailsModel(CovenantObligationDetailsModel _covenantObligationDetailsModel, int idx) {
            this.getIndex(this.covenantObligationDetailsModel, idx, () -> _covenantObligationDetailsModel.toBuilder());
            return this;
        }

        @Override
        public DealStatementBuilder addCovenantObligationDetailsModel(List<? extends CovenantObligationDetailsModel> covenantObligationDetailsModels) {
            if (covenantObligationDetailsModels != null) {
                for (CovenantObligationDetailsModel covenantObligationDetailsModel : covenantObligationDetailsModels) {
                    this.covenantObligationDetailsModel.add(covenantObligationDetailsModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="covenantObligationDetailsModel")
        public DealStatementBuilder setCovenantObligationDetailsModel(List<? extends CovenantObligationDetailsModel> covenantObligationDetailsModels) {
            this.covenantObligationDetailsModel = covenantObligationDetailsModels == null ? new ArrayList<CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder>() : (List)covenantObligationDetailsModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel")
        @RuneAttribute(value="facilityDetailsModel")
        public DealStatementBuilder addFacilityDetailsModel(FacilityDetailsModel _facilityDetailsModel) {
            if (_facilityDetailsModel != null) {
                this.facilityDetailsModel.add(_facilityDetailsModel.toBuilder());
            }
            return this;
        }

        @Override
        public DealStatementBuilder addFacilityDetailsModel(FacilityDetailsModel _facilityDetailsModel, int idx) {
            this.getIndex(this.facilityDetailsModel, idx, () -> _facilityDetailsModel.toBuilder());
            return this;
        }

        @Override
        public DealStatementBuilder addFacilityDetailsModel(List<? extends FacilityDetailsModel> facilityDetailsModels) {
            if (facilityDetailsModels != null) {
                for (FacilityDetailsModel facilityDetailsModel : facilityDetailsModels) {
                    this.facilityDetailsModel.add(facilityDetailsModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityDetailsModel")
        public DealStatementBuilder setFacilityDetailsModel(List<? extends FacilityDetailsModel> facilityDetailsModels) {
            this.facilityDetailsModel = facilityDetailsModels == null ? new ArrayList<FacilityDetailsModel.FacilityDetailsModelBuilder>() : (List)facilityDetailsModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public DealStatementBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public DealStatementBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public DealStatementBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public DealStatementBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public DealStatement build() {
            return new DealStatementImpl(this);
        }

        @Override
        public DealStatementBuilder toBuilder() {
            return this;
        }

        @Override
        public DealStatementBuilder prune() {
            super.prune();
            if (this.deal != null && !this.deal.prune().hasData()) {
                this.deal = null;
            }
            this.dealDetailsModel = this.dealDetailsModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.covenantObligationDetailsModel = this.covenantObligationDetailsModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.facilityDetailsModel = this.facilityDetailsModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeal() != null && this.getDeal().hasData()) {
                return true;
            }
            if (this.getDealDetailsModel() != null && this.getDealDetailsModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCovenantObligationDetailsModel() != null && this.getCovenantObligationDetailsModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFacilityDetailsModel() != null && this.getFacilityDetailsModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public DealStatementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DealStatementBuilder o = (DealStatementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeal(), (RosettaModelObjectBuilder)o.getDeal(), this::setDeal);
            merger.mergeRosetta(this.getDealDetailsModel(), o.getDealDetailsModel(), this::getOrCreateDealDetailsModel);
            merger.mergeRosetta(this.getCovenantObligationDetailsModel(), o.getCovenantObligationDetailsModel(), this::getOrCreateCovenantObligationDetailsModel);
            merger.mergeRosetta(this.getFacilityDetailsModel(), o.getFacilityDetailsModel(), this::getOrCreateFacilityDetailsModel);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DealStatement _that = (DealStatement)this.getType().cast(o);
            if (!Objects.equals(this.deal, _that.getDeal())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.covenantObligationDetailsModel, _that.getCovenantObligationDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deal != null ? this.deal.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.covenantObligationDetailsModel != null ? this.covenantObligationDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DealStatementBuilder {deal=" + this.deal + ", dealDetailsModel=" + this.dealDetailsModel + ", covenantObligationDetailsModel=" + this.covenantObligationDetailsModel + ", facilityDetailsModel=" + this.facilityDetailsModel + ", party=" + this.party + '}' + " " + super.toString();
        }
    }

    public static interface DealStatementBuilder
    extends DealStatement,
    AbstractLoanStatement.AbstractLoanStatementBuilder {
        public Deal.DealBuilder getOrCreateDeal();

        @Override
        public Deal.DealBuilder getDeal();

        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel(int var1);

        public List<? extends DealDetailsModel.DealDetailsModelBuilder> getDealDetailsModel();

        public CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder getOrCreateCovenantObligationDetailsModel(int var1);

        public List<? extends CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder> getCovenantObligationDetailsModel();

        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel(int var1);

        public List<? extends FacilityDetailsModel.FacilityDetailsModelBuilder> getFacilityDetailsModel();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public DealStatementBuilder setFpmlVersion(String var1);

        @Override
        public DealStatementBuilder setExpectedBuild(Integer var1);

        @Override
        public DealStatementBuilder setActualBuild(Integer var1);

        @Override
        public DealStatementBuilder setHeader(RequestMessageHeader var1);

        @Override
        public DealStatementBuilder setValidationModel(ValidationModel var1);

        @Override
        public DealStatementBuilder setIsCorrection(Boolean var1);

        @Override
        public DealStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public DealStatementBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public DealStatementBuilder setStatementDate(ZonedDateTime var1);

        @Override
        public DealStatementBuilder setComments(String var1);

        public DealStatementBuilder setDeal(Deal var1);

        public DealStatementBuilder addDealDetailsModel(DealDetailsModel var1);

        public DealStatementBuilder addDealDetailsModel(DealDetailsModel var1, int var2);

        public DealStatementBuilder addDealDetailsModel(List<? extends DealDetailsModel> var1);

        public DealStatementBuilder setDealDetailsModel(List<? extends DealDetailsModel> var1);

        public DealStatementBuilder addCovenantObligationDetailsModel(CovenantObligationDetailsModel var1);

        public DealStatementBuilder addCovenantObligationDetailsModel(CovenantObligationDetailsModel var1, int var2);

        public DealStatementBuilder addCovenantObligationDetailsModel(List<? extends CovenantObligationDetailsModel> var1);

        public DealStatementBuilder setCovenantObligationDetailsModel(List<? extends CovenantObligationDetailsModel> var1);

        public DealStatementBuilder addFacilityDetailsModel(FacilityDetailsModel var1);

        public DealStatementBuilder addFacilityDetailsModel(FacilityDetailsModel var1, int var2);

        public DealStatementBuilder addFacilityDetailsModel(List<? extends FacilityDetailsModel> var1);

        public DealStatementBuilder setFacilityDetailsModel(List<? extends FacilityDetailsModel> var1);

        public DealStatementBuilder addParty(Party var1);

        public DealStatementBuilder addParty(Party var1, int var2);

        public DealStatementBuilder addParty(List<? extends Party> var1);

        public DealStatementBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("statementDate"), ZonedDateTime.class, (Object)this.getStatementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deal"), processor, Deal.DealBuilder.class, this.getDeal(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.DealDetailsModelBuilder.class, this.getDealDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("covenantObligationDetailsModel"), processor, CovenantObligationDetailsModel.CovenantObligationDetailsModelBuilder.class, this.getCovenantObligationDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.FacilityDetailsModelBuilder.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public DealStatementBuilder prune();
    }

    public static class DealStatementImpl
    extends AbstractLoanStatement.AbstractLoanStatementImpl
    implements DealStatement {
        private final Deal deal;
        private final List<? extends DealDetailsModel> dealDetailsModel;
        private final List<? extends CovenantObligationDetailsModel> covenantObligationDetailsModel;
        private final List<? extends FacilityDetailsModel> facilityDetailsModel;
        private final List<? extends Party> party;

        protected DealStatementImpl(DealStatementBuilder builder) {
            super(builder);
            this.deal = Optional.ofNullable(builder.getDeal()).map(f -> f.build()).orElse(null);
            this.dealDetailsModel = Optional.ofNullable(builder.getDealDetailsModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.covenantObligationDetailsModel = Optional.ofNullable(builder.getCovenantObligationDetailsModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.facilityDetailsModel = Optional.ofNullable(builder.getFacilityDetailsModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="deal", isRequired=true)
        @RuneAttribute(value="deal", isRequired=true)
        public Deal getDeal() {
            return this.deal;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public List<? extends DealDetailsModel> getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        @RosettaAttribute(value="covenantObligationDetailsModel")
        @RuneAttribute(value="covenantObligationDetailsModel")
        public List<? extends CovenantObligationDetailsModel> getCovenantObligationDetailsModel() {
            return this.covenantObligationDetailsModel;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel")
        @RuneAttribute(value="facilityDetailsModel")
        public List<? extends FacilityDetailsModel> getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public DealStatement build() {
            return this;
        }

        @Override
        public DealStatementBuilder toBuilder() {
            DealStatementBuilder builder = DealStatement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DealStatementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeal()).ifPresent(builder::setDeal);
            Optional.ofNullable(this.getDealDetailsModel()).ifPresent(builder::setDealDetailsModel);
            Optional.ofNullable(this.getCovenantObligationDetailsModel()).ifPresent(builder::setCovenantObligationDetailsModel);
            Optional.ofNullable(this.getFacilityDetailsModel()).ifPresent(builder::setFacilityDetailsModel);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DealStatement _that = (DealStatement)this.getType().cast(o);
            if (!Objects.equals(this.deal, _that.getDeal())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.covenantObligationDetailsModel, _that.getCovenantObligationDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deal != null ? this.deal.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.covenantObligationDetailsModel != null ? this.covenantObligationDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DealStatement {deal=" + this.deal + ", dealDetailsModel=" + this.dealDetailsModel + ", covenantObligationDetailsModel=" + this.covenantObligationDetailsModel + ", facilityDetailsModel=" + this.facilityDetailsModel + ", party=" + this.party + '}' + " " + super.toString();
        }
    }
}

