/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.FixedRateReference;
import fpml.confirmation.meta.CreditOptionStrikeMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CreditOptionStrike", builder=CreditOptionStrikeBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CreditOptionStrike", model="fpml", builder=CreditOptionStrikeBuilderImpl.class, version="0.17.2")
public interface CreditOptionStrike
extends RosettaModelObject {
    public static final CreditOptionStrikeMeta metaData = new CreditOptionStrikeMeta();

    public BigDecimal getSpread();

    public BigDecimal getPrice();

    public FixedRateReference getStrikeReference();

    public CreditOptionStrike build();

    public CreditOptionStrikeBuilder toBuilder();

    public static CreditOptionStrikeBuilder builder() {
        return new CreditOptionStrikeBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditOptionStrike> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditOptionStrike> getType() {
        return CreditOptionStrike.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("price"), BigDecimal.class, (Object)this.getPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikeReference"), processor, FixedRateReference.class, this.getStrikeReference(), new AttributeMeta[0]);
    }

    public static class CreditOptionStrikeBuilderImpl
    implements CreditOptionStrikeBuilder {
        protected BigDecimal spread;
        protected BigDecimal price;
        protected FixedRateReference.FixedRateReferenceBuilder strikeReference;

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public BigDecimal getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="strikeReference")
        @RuneAttribute(value="strikeReference")
        public FixedRateReference.FixedRateReferenceBuilder getStrikeReference() {
            return this.strikeReference;
        }

        @Override
        public FixedRateReference.FixedRateReferenceBuilder getOrCreateStrikeReference() {
            FixedRateReference.FixedRateReferenceBuilder result = this.strikeReference != null ? this.strikeReference : (this.strikeReference = FixedRateReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public CreditOptionStrikeBuilder setSpread(BigDecimal _spread) {
            this.spread = _spread == null ? null : _spread;
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public CreditOptionStrikeBuilder setPrice(BigDecimal _price) {
            this.price = _price == null ? null : _price;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikeReference")
        @RuneAttribute(value="strikeReference")
        public CreditOptionStrikeBuilder setStrikeReference(FixedRateReference _strikeReference) {
            this.strikeReference = _strikeReference == null ? null : _strikeReference.toBuilder();
            return this;
        }

        @Override
        public CreditOptionStrike build() {
            return new CreditOptionStrikeImpl(this);
        }

        @Override
        public CreditOptionStrikeBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditOptionStrikeBuilder prune() {
            if (this.strikeReference != null && !this.strikeReference.prune().hasData()) {
                this.strikeReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSpread() != null) {
                return true;
            }
            if (this.getPrice() != null) {
                return true;
            }
            return this.getStrikeReference() != null && this.getStrikeReference().hasData();
        }

        public CreditOptionStrikeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditOptionStrikeBuilder o = (CreditOptionStrikeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikeReference(), (RosettaModelObjectBuilder)o.getStrikeReference(), this::setStrikeReference);
            merger.mergeBasic((Object)this.getSpread(), (Object)o.getSpread(), this::setSpread, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPrice(), (Object)o.getPrice(), this::setPrice, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditOptionStrike _that = this.getType().cast(o);
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            return Objects.equals(this.strikeReference, _that.getStrikeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.strikeReference != null ? this.strikeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditOptionStrikeBuilder {spread=" + this.spread + ", price=" + this.price + ", strikeReference=" + this.strikeReference + '}';
        }
    }

    public static interface CreditOptionStrikeBuilder
    extends CreditOptionStrike,
    RosettaModelObjectBuilder {
        public FixedRateReference.FixedRateReferenceBuilder getOrCreateStrikeReference();

        @Override
        public FixedRateReference.FixedRateReferenceBuilder getStrikeReference();

        public CreditOptionStrikeBuilder setSpread(BigDecimal var1);

        public CreditOptionStrikeBuilder setPrice(BigDecimal var1);

        public CreditOptionStrikeBuilder setStrikeReference(FixedRateReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("price"), BigDecimal.class, (Object)this.getPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikeReference"), processor, FixedRateReference.FixedRateReferenceBuilder.class, this.getStrikeReference(), new AttributeMeta[0]);
        }

        public CreditOptionStrikeBuilder prune();
    }

    public static class CreditOptionStrikeImpl
    implements CreditOptionStrike {
        private final BigDecimal spread;
        private final BigDecimal price;
        private final FixedRateReference strikeReference;

        protected CreditOptionStrikeImpl(CreditOptionStrikeBuilder builder) {
            this.spread = builder.getSpread();
            this.price = builder.getPrice();
            this.strikeReference = Optional.ofNullable(builder.getStrikeReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public BigDecimal getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="strikeReference")
        @RuneAttribute(value="strikeReference")
        public FixedRateReference getStrikeReference() {
            return this.strikeReference;
        }

        @Override
        public CreditOptionStrike build() {
            return this;
        }

        @Override
        public CreditOptionStrikeBuilder toBuilder() {
            CreditOptionStrikeBuilder builder = CreditOptionStrike.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditOptionStrikeBuilder builder) {
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getStrikeReference()).ifPresent(builder::setStrikeReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditOptionStrike _that = this.getType().cast(o);
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            return Objects.equals(this.strikeReference, _that.getStrikeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.strikeReference != null ? this.strikeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditOptionStrike {spread=" + this.spread + ", price=" + this.price + ", strikeReference=" + this.strikeReference + '}';
        }
    }
}

