/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.CommodityAmericanExercise;
import fpml.confirmation.CommodityEuropeanExercise;
import fpml.confirmation.CommodityFx;
import fpml.confirmation.CommodityPaymentDatesModel;
import fpml.confirmation.IdentifiedCurrency;
import fpml.confirmation.meta.CommodityExerciseMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityExercise", builder=CommodityExerciseBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CommodityExercise", model="fpml", builder=CommodityExerciseBuilderImpl.class, version="0.17.2")
public interface CommodityExercise
extends RosettaModelObject {
    public static final CommodityExerciseMeta metaData = new CommodityExerciseMeta();

    public CommodityAmericanExercise getAmericanExercise();

    public CommodityEuropeanExercise getEuropeanExercise();

    public Boolean getAutomaticExercise();

    public Boolean getWrittenConfirmation();

    public IdentifiedCurrency getSettlementCurrency();

    public CommodityFx getFx();

    public BigDecimal getConversionFactor();

    public CommodityPaymentDatesModel getCommodityPaymentDatesModel();

    public CommodityExercise build();

    public CommodityExerciseBuilder toBuilder();

    public static CommodityExerciseBuilder builder() {
        return new CommodityExerciseBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityExercise> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityExercise> getType() {
        return CommodityExercise.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("americanExercise"), processor, CommodityAmericanExercise.class, this.getAmericanExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("europeanExercise"), processor, CommodityEuropeanExercise.class, this.getEuropeanExercise(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("automaticExercise"), Boolean.class, (Object)this.getAutomaticExercise(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("writtenConfirmation"), Boolean.class, (Object)this.getWrittenConfirmation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, IdentifiedCurrency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fx"), processor, CommodityFx.class, this.getFx(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityPaymentDatesModel"), processor, CommodityPaymentDatesModel.class, this.getCommodityPaymentDatesModel(), new AttributeMeta[0]);
    }

    public static class CommodityExerciseBuilderImpl
    implements CommodityExerciseBuilder {
        protected CommodityAmericanExercise.CommodityAmericanExerciseBuilder americanExercise;
        protected CommodityEuropeanExercise.CommodityEuropeanExerciseBuilder europeanExercise;
        protected Boolean automaticExercise;
        protected Boolean writtenConfirmation;
        protected IdentifiedCurrency.IdentifiedCurrencyBuilder settlementCurrency;
        protected CommodityFx.CommodityFxBuilder fx;
        protected BigDecimal conversionFactor;
        protected CommodityPaymentDatesModel.CommodityPaymentDatesModelBuilder commodityPaymentDatesModel;

        @Override
        @RosettaAttribute(value="americanExercise")
        @RuneAttribute(value="americanExercise")
        public CommodityAmericanExercise.CommodityAmericanExerciseBuilder getAmericanExercise() {
            return this.americanExercise;
        }

        @Override
        public CommodityAmericanExercise.CommodityAmericanExerciseBuilder getOrCreateAmericanExercise() {
            CommodityAmericanExercise.CommodityAmericanExerciseBuilder result = this.americanExercise != null ? this.americanExercise : (this.americanExercise = CommodityAmericanExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="europeanExercise")
        @RuneAttribute(value="europeanExercise")
        public CommodityEuropeanExercise.CommodityEuropeanExerciseBuilder getEuropeanExercise() {
            return this.europeanExercise;
        }

        @Override
        public CommodityEuropeanExercise.CommodityEuropeanExerciseBuilder getOrCreateEuropeanExercise() {
            CommodityEuropeanExercise.CommodityEuropeanExerciseBuilder result = this.europeanExercise != null ? this.europeanExercise : (this.europeanExercise = CommodityEuropeanExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="automaticExercise")
        @RuneAttribute(value="automaticExercise")
        public Boolean getAutomaticExercise() {
            return this.automaticExercise;
        }

        @Override
        @RosettaAttribute(value="writtenConfirmation")
        @RuneAttribute(value="writtenConfirmation")
        public Boolean getWrittenConfirmation() {
            return this.writtenConfirmation;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateSettlementCurrency() {
            IdentifiedCurrency.IdentifiedCurrencyBuilder result = this.settlementCurrency != null ? this.settlementCurrency : (this.settlementCurrency = IdentifiedCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fx")
        @RuneAttribute(value="fx")
        public CommodityFx.CommodityFxBuilder getFx() {
            return this.fx;
        }

        @Override
        public CommodityFx.CommodityFxBuilder getOrCreateFx() {
            CommodityFx.CommodityFxBuilder result = this.fx != null ? this.fx : (this.fx = CommodityFx.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        @RosettaAttribute(value="commodityPaymentDatesModel", isRequired=true)
        @RuneAttribute(value="commodityPaymentDatesModel", isRequired=true)
        public CommodityPaymentDatesModel.CommodityPaymentDatesModelBuilder getCommodityPaymentDatesModel() {
            return this.commodityPaymentDatesModel;
        }

        @Override
        public CommodityPaymentDatesModel.CommodityPaymentDatesModelBuilder getOrCreateCommodityPaymentDatesModel() {
            CommodityPaymentDatesModel.CommodityPaymentDatesModelBuilder result = this.commodityPaymentDatesModel != null ? this.commodityPaymentDatesModel : (this.commodityPaymentDatesModel = CommodityPaymentDatesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="americanExercise")
        @RuneAttribute(value="americanExercise")
        public CommodityExerciseBuilder setAmericanExercise(CommodityAmericanExercise _americanExercise) {
            this.americanExercise = _americanExercise == null ? null : _americanExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="europeanExercise")
        @RuneAttribute(value="europeanExercise")
        public CommodityExerciseBuilder setEuropeanExercise(CommodityEuropeanExercise _europeanExercise) {
            this.europeanExercise = _europeanExercise == null ? null : _europeanExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="automaticExercise")
        @RuneAttribute(value="automaticExercise")
        public CommodityExerciseBuilder setAutomaticExercise(Boolean _automaticExercise) {
            this.automaticExercise = _automaticExercise == null ? null : _automaticExercise;
            return this;
        }

        @Override
        @RosettaAttribute(value="writtenConfirmation")
        @RuneAttribute(value="writtenConfirmation")
        public CommodityExerciseBuilder setWrittenConfirmation(Boolean _writtenConfirmation) {
            this.writtenConfirmation = _writtenConfirmation == null ? null : _writtenConfirmation;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public CommodityExerciseBuilder setSettlementCurrency(IdentifiedCurrency _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fx")
        @RuneAttribute(value="fx")
        public CommodityExerciseBuilder setFx(CommodityFx _fx) {
            this.fx = _fx == null ? null : _fx.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public CommodityExerciseBuilder setConversionFactor(BigDecimal _conversionFactor) {
            this.conversionFactor = _conversionFactor == null ? null : _conversionFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityPaymentDatesModel", isRequired=true)
        @RuneAttribute(value="commodityPaymentDatesModel", isRequired=true)
        public CommodityExerciseBuilder setCommodityPaymentDatesModel(CommodityPaymentDatesModel _commodityPaymentDatesModel) {
            this.commodityPaymentDatesModel = _commodityPaymentDatesModel == null ? null : _commodityPaymentDatesModel.toBuilder();
            return this;
        }

        @Override
        public CommodityExercise build() {
            return new CommodityExerciseImpl(this);
        }

        @Override
        public CommodityExerciseBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityExerciseBuilder prune() {
            if (this.americanExercise != null && !this.americanExercise.prune().hasData()) {
                this.americanExercise = null;
            }
            if (this.europeanExercise != null && !this.europeanExercise.prune().hasData()) {
                this.europeanExercise = null;
            }
            if (this.settlementCurrency != null && !this.settlementCurrency.prune().hasData()) {
                this.settlementCurrency = null;
            }
            if (this.fx != null && !this.fx.prune().hasData()) {
                this.fx = null;
            }
            if (this.commodityPaymentDatesModel != null && !this.commodityPaymentDatesModel.prune().hasData()) {
                this.commodityPaymentDatesModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmericanExercise() != null && this.getAmericanExercise().hasData()) {
                return true;
            }
            if (this.getEuropeanExercise() != null && this.getEuropeanExercise().hasData()) {
                return true;
            }
            if (this.getAutomaticExercise() != null) {
                return true;
            }
            if (this.getWrittenConfirmation() != null) {
                return true;
            }
            if (this.getSettlementCurrency() != null && this.getSettlementCurrency().hasData()) {
                return true;
            }
            if (this.getFx() != null && this.getFx().hasData()) {
                return true;
            }
            if (this.getConversionFactor() != null) {
                return true;
            }
            return this.getCommodityPaymentDatesModel() != null && this.getCommodityPaymentDatesModel().hasData();
        }

        public CommodityExerciseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityExerciseBuilder o = (CommodityExerciseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmericanExercise(), (RosettaModelObjectBuilder)o.getAmericanExercise(), this::setAmericanExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEuropeanExercise(), (RosettaModelObjectBuilder)o.getEuropeanExercise(), this::setEuropeanExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrency(), (RosettaModelObjectBuilder)o.getSettlementCurrency(), this::setSettlementCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFx(), (RosettaModelObjectBuilder)o.getFx(), this::setFx);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodityPaymentDatesModel(), (RosettaModelObjectBuilder)o.getCommodityPaymentDatesModel(), this::setCommodityPaymentDatesModel);
            merger.mergeBasic((Object)this.getAutomaticExercise(), (Object)o.getAutomaticExercise(), this::setAutomaticExercise, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWrittenConfirmation(), (Object)o.getWrittenConfirmation(), this::setWrittenConfirmation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConversionFactor(), (Object)o.getConversionFactor(), this::setConversionFactor, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityExercise _that = this.getType().cast(o);
            if (!Objects.equals(this.americanExercise, _that.getAmericanExercise())) {
                return false;
            }
            if (!Objects.equals(this.europeanExercise, _that.getEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.automaticExercise, _that.getAutomaticExercise())) {
                return false;
            }
            if (!Objects.equals(this.writtenConfirmation, _that.getWrittenConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fx, _that.getFx())) {
                return false;
            }
            if (!Objects.equals(this.conversionFactor, _that.getConversionFactor())) {
                return false;
            }
            return Objects.equals(this.commodityPaymentDatesModel, _that.getCommodityPaymentDatesModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.americanExercise != null ? this.americanExercise.hashCode() : 0);
            _result = 31 * _result + (this.europeanExercise != null ? this.europeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.automaticExercise != null ? this.automaticExercise.hashCode() : 0);
            _result = 31 * _result + (this.writtenConfirmation != null ? this.writtenConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.fx != null ? this.fx.hashCode() : 0);
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.commodityPaymentDatesModel != null ? this.commodityPaymentDatesModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityExerciseBuilder {americanExercise=" + this.americanExercise + ", europeanExercise=" + this.europeanExercise + ", automaticExercise=" + this.automaticExercise + ", writtenConfirmation=" + this.writtenConfirmation + ", settlementCurrency=" + this.settlementCurrency + ", fx=" + this.fx + ", conversionFactor=" + this.conversionFactor + ", commodityPaymentDatesModel=" + this.commodityPaymentDatesModel + '}';
        }
    }

    public static interface CommodityExerciseBuilder
    extends CommodityExercise,
    RosettaModelObjectBuilder {
        public CommodityAmericanExercise.CommodityAmericanExerciseBuilder getOrCreateAmericanExercise();

        @Override
        public CommodityAmericanExercise.CommodityAmericanExerciseBuilder getAmericanExercise();

        public CommodityEuropeanExercise.CommodityEuropeanExerciseBuilder getOrCreateEuropeanExercise();

        @Override
        public CommodityEuropeanExercise.CommodityEuropeanExerciseBuilder getEuropeanExercise();

        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateSettlementCurrency();

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getSettlementCurrency();

        public CommodityFx.CommodityFxBuilder getOrCreateFx();

        @Override
        public CommodityFx.CommodityFxBuilder getFx();

        public CommodityPaymentDatesModel.CommodityPaymentDatesModelBuilder getOrCreateCommodityPaymentDatesModel();

        @Override
        public CommodityPaymentDatesModel.CommodityPaymentDatesModelBuilder getCommodityPaymentDatesModel();

        public CommodityExerciseBuilder setAmericanExercise(CommodityAmericanExercise var1);

        public CommodityExerciseBuilder setEuropeanExercise(CommodityEuropeanExercise var1);

        public CommodityExerciseBuilder setAutomaticExercise(Boolean var1);

        public CommodityExerciseBuilder setWrittenConfirmation(Boolean var1);

        public CommodityExerciseBuilder setSettlementCurrency(IdentifiedCurrency var1);

        public CommodityExerciseBuilder setFx(CommodityFx var1);

        public CommodityExerciseBuilder setConversionFactor(BigDecimal var1);

        public CommodityExerciseBuilder setCommodityPaymentDatesModel(CommodityPaymentDatesModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("americanExercise"), processor, CommodityAmericanExercise.CommodityAmericanExerciseBuilder.class, this.getAmericanExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("europeanExercise"), processor, CommodityEuropeanExercise.CommodityEuropeanExerciseBuilder.class, this.getEuropeanExercise(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("automaticExercise"), Boolean.class, (Object)this.getAutomaticExercise(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("writtenConfirmation"), Boolean.class, (Object)this.getWrittenConfirmation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fx"), processor, CommodityFx.CommodityFxBuilder.class, this.getFx(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityPaymentDatesModel"), processor, CommodityPaymentDatesModel.CommodityPaymentDatesModelBuilder.class, this.getCommodityPaymentDatesModel(), new AttributeMeta[0]);
        }

        public CommodityExerciseBuilder prune();
    }

    public static class CommodityExerciseImpl
    implements CommodityExercise {
        private final CommodityAmericanExercise americanExercise;
        private final CommodityEuropeanExercise europeanExercise;
        private final Boolean automaticExercise;
        private final Boolean writtenConfirmation;
        private final IdentifiedCurrency settlementCurrency;
        private final CommodityFx fx;
        private final BigDecimal conversionFactor;
        private final CommodityPaymentDatesModel commodityPaymentDatesModel;

        protected CommodityExerciseImpl(CommodityExerciseBuilder builder) {
            this.americanExercise = Optional.ofNullable(builder.getAmericanExercise()).map(f -> f.build()).orElse(null);
            this.europeanExercise = Optional.ofNullable(builder.getEuropeanExercise()).map(f -> f.build()).orElse(null);
            this.automaticExercise = builder.getAutomaticExercise();
            this.writtenConfirmation = builder.getWrittenConfirmation();
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).map(f -> f.build()).orElse(null);
            this.fx = Optional.ofNullable(builder.getFx()).map(f -> f.build()).orElse(null);
            this.conversionFactor = builder.getConversionFactor();
            this.commodityPaymentDatesModel = Optional.ofNullable(builder.getCommodityPaymentDatesModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="americanExercise")
        @RuneAttribute(value="americanExercise")
        public CommodityAmericanExercise getAmericanExercise() {
            return this.americanExercise;
        }

        @Override
        @RosettaAttribute(value="europeanExercise")
        @RuneAttribute(value="europeanExercise")
        public CommodityEuropeanExercise getEuropeanExercise() {
            return this.europeanExercise;
        }

        @Override
        @RosettaAttribute(value="automaticExercise")
        @RuneAttribute(value="automaticExercise")
        public Boolean getAutomaticExercise() {
            return this.automaticExercise;
        }

        @Override
        @RosettaAttribute(value="writtenConfirmation")
        @RuneAttribute(value="writtenConfirmation")
        public Boolean getWrittenConfirmation() {
            return this.writtenConfirmation;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public IdentifiedCurrency getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="fx")
        @RuneAttribute(value="fx")
        public CommodityFx getFx() {
            return this.fx;
        }

        @Override
        @RosettaAttribute(value="conversionFactor")
        @RuneAttribute(value="conversionFactor")
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        @RosettaAttribute(value="commodityPaymentDatesModel", isRequired=true)
        @RuneAttribute(value="commodityPaymentDatesModel", isRequired=true)
        public CommodityPaymentDatesModel getCommodityPaymentDatesModel() {
            return this.commodityPaymentDatesModel;
        }

        @Override
        public CommodityExercise build() {
            return this;
        }

        @Override
        public CommodityExerciseBuilder toBuilder() {
            CommodityExerciseBuilder builder = CommodityExercise.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityExerciseBuilder builder) {
            Optional.ofNullable(this.getAmericanExercise()).ifPresent(builder::setAmericanExercise);
            Optional.ofNullable(this.getEuropeanExercise()).ifPresent(builder::setEuropeanExercise);
            Optional.ofNullable(this.getAutomaticExercise()).ifPresent(builder::setAutomaticExercise);
            Optional.ofNullable(this.getWrittenConfirmation()).ifPresent(builder::setWrittenConfirmation);
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getFx()).ifPresent(builder::setFx);
            Optional.ofNullable(this.getConversionFactor()).ifPresent(builder::setConversionFactor);
            Optional.ofNullable(this.getCommodityPaymentDatesModel()).ifPresent(builder::setCommodityPaymentDatesModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityExercise _that = this.getType().cast(o);
            if (!Objects.equals(this.americanExercise, _that.getAmericanExercise())) {
                return false;
            }
            if (!Objects.equals(this.europeanExercise, _that.getEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.automaticExercise, _that.getAutomaticExercise())) {
                return false;
            }
            if (!Objects.equals(this.writtenConfirmation, _that.getWrittenConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.fx, _that.getFx())) {
                return false;
            }
            if (!Objects.equals(this.conversionFactor, _that.getConversionFactor())) {
                return false;
            }
            return Objects.equals(this.commodityPaymentDatesModel, _that.getCommodityPaymentDatesModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.americanExercise != null ? this.americanExercise.hashCode() : 0);
            _result = 31 * _result + (this.europeanExercise != null ? this.europeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.automaticExercise != null ? this.automaticExercise.hashCode() : 0);
            _result = 31 * _result + (this.writtenConfirmation != null ? this.writtenConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.fx != null ? this.fx.hashCode() : 0);
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.commodityPaymentDatesModel != null ? this.commodityPaymentDatesModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityExercise {americanExercise=" + this.americanExercise + ", europeanExercise=" + this.europeanExercise + ", automaticExercise=" + this.automaticExercise + ", writtenConfirmation=" + this.writtenConfirmation + ", settlementCurrency=" + this.settlementCurrency + ", fx=" + this.fx + ", conversionFactor=" + this.conversionFactor + ", commodityPaymentDatesModel=" + this.commodityPaymentDatesModel + '}';
        }
    }
}

