/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CommodityExercisePeriods;
import fpml.confirmation.Frequency;
import fpml.confirmation.meta.CommodityAmericanExerciseSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityAmericanExerciseSequence", builder=CommodityAmericanExerciseSequenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CommodityAmericanExerciseSequence", model="fpml", builder=CommodityAmericanExerciseSequenceBuilderImpl.class, version="0.17.2")
public interface CommodityAmericanExerciseSequence
extends RosettaModelObject {
    public static final CommodityAmericanExerciseSequenceMeta metaData = new CommodityAmericanExerciseSequenceMeta();

    public List<? extends CommodityExercisePeriods> getExercisePeriod();

    public Frequency getExerciseFrequency();

    public CommodityAmericanExerciseSequence build();

    public CommodityAmericanExerciseSequenceBuilder toBuilder();

    public static CommodityAmericanExerciseSequenceBuilder builder() {
        return new CommodityAmericanExerciseSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityAmericanExerciseSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityAmericanExerciseSequence> getType() {
        return CommodityAmericanExerciseSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("exercisePeriod"), processor, CommodityExercisePeriods.class, this.getExercisePeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseFrequency"), processor, Frequency.class, this.getExerciseFrequency(), new AttributeMeta[0]);
    }

    public static class CommodityAmericanExerciseSequenceBuilderImpl
    implements CommodityAmericanExerciseSequenceBuilder {
        protected List<CommodityExercisePeriods.CommodityExercisePeriodsBuilder> exercisePeriod = new ArrayList<CommodityExercisePeriods.CommodityExercisePeriodsBuilder>();
        protected Frequency.FrequencyBuilder exerciseFrequency;

        @Override
        @RosettaAttribute(value="exercisePeriod", isRequired=true)
        @RuneAttribute(value="exercisePeriod", isRequired=true)
        public List<? extends CommodityExercisePeriods.CommodityExercisePeriodsBuilder> getExercisePeriod() {
            return this.exercisePeriod;
        }

        @Override
        public CommodityExercisePeriods.CommodityExercisePeriodsBuilder getOrCreateExercisePeriod(int index) {
            if (this.exercisePeriod == null) {
                this.exercisePeriod = new ArrayList<CommodityExercisePeriods.CommodityExercisePeriodsBuilder>();
            }
            return (CommodityExercisePeriods.CommodityExercisePeriodsBuilder)this.getIndex(this.exercisePeriod, index, () -> {
                CommodityExercisePeriods.CommodityExercisePeriodsBuilder newExercisePeriod = CommodityExercisePeriods.builder();
                return newExercisePeriod;
            });
        }

        @Override
        @RosettaAttribute(value="exerciseFrequency")
        @RuneAttribute(value="exerciseFrequency")
        public Frequency.FrequencyBuilder getExerciseFrequency() {
            return this.exerciseFrequency;
        }

        @Override
        public Frequency.FrequencyBuilder getOrCreateExerciseFrequency() {
            Frequency.FrequencyBuilder result = this.exerciseFrequency != null ? this.exerciseFrequency : (this.exerciseFrequency = Frequency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exercisePeriod", isRequired=true)
        @RuneAttribute(value="exercisePeriod", isRequired=true)
        public CommodityAmericanExerciseSequenceBuilder addExercisePeriod(CommodityExercisePeriods _exercisePeriod) {
            if (_exercisePeriod != null) {
                this.exercisePeriod.add(_exercisePeriod.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityAmericanExerciseSequenceBuilder addExercisePeriod(CommodityExercisePeriods _exercisePeriod, int idx) {
            this.getIndex(this.exercisePeriod, idx, () -> _exercisePeriod.toBuilder());
            return this;
        }

        @Override
        public CommodityAmericanExerciseSequenceBuilder addExercisePeriod(List<? extends CommodityExercisePeriods> exercisePeriods) {
            if (exercisePeriods != null) {
                for (CommodityExercisePeriods commodityExercisePeriods : exercisePeriods) {
                    this.exercisePeriod.add(commodityExercisePeriods.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="exercisePeriod")
        public CommodityAmericanExerciseSequenceBuilder setExercisePeriod(List<? extends CommodityExercisePeriods> exercisePeriods) {
            this.exercisePeriod = exercisePeriods == null ? new ArrayList<CommodityExercisePeriods.CommodityExercisePeriodsBuilder>() : (List)exercisePeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseFrequency")
        @RuneAttribute(value="exerciseFrequency")
        public CommodityAmericanExerciseSequenceBuilder setExerciseFrequency(Frequency _exerciseFrequency) {
            this.exerciseFrequency = _exerciseFrequency == null ? null : _exerciseFrequency.toBuilder();
            return this;
        }

        @Override
        public CommodityAmericanExerciseSequence build() {
            return new CommodityAmericanExerciseSequenceImpl(this);
        }

        @Override
        public CommodityAmericanExerciseSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityAmericanExerciseSequenceBuilder prune() {
            this.exercisePeriod = this.exercisePeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.exerciseFrequency != null && !this.exerciseFrequency.prune().hasData()) {
                this.exerciseFrequency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getExercisePeriod() != null && this.getExercisePeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getExerciseFrequency() != null && this.getExerciseFrequency().hasData();
        }

        public CommodityAmericanExerciseSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityAmericanExerciseSequenceBuilder o = (CommodityAmericanExerciseSequenceBuilder)other;
            merger.mergeRosetta(this.getExercisePeriod(), o.getExercisePeriod(), this::getOrCreateExercisePeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseFrequency(), (RosettaModelObjectBuilder)o.getExerciseFrequency(), this::setExerciseFrequency);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityAmericanExerciseSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.exercisePeriod, _that.getExercisePeriod())) {
                return false;
            }
            return Objects.equals(this.exerciseFrequency, _that.getExerciseFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.exercisePeriod != null ? this.exercisePeriod.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFrequency != null ? this.exerciseFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityAmericanExerciseSequenceBuilder {exercisePeriod=" + this.exercisePeriod + ", exerciseFrequency=" + this.exerciseFrequency + '}';
        }
    }

    public static interface CommodityAmericanExerciseSequenceBuilder
    extends CommodityAmericanExerciseSequence,
    RosettaModelObjectBuilder {
        public CommodityExercisePeriods.CommodityExercisePeriodsBuilder getOrCreateExercisePeriod(int var1);

        public List<? extends CommodityExercisePeriods.CommodityExercisePeriodsBuilder> getExercisePeriod();

        public Frequency.FrequencyBuilder getOrCreateExerciseFrequency();

        @Override
        public Frequency.FrequencyBuilder getExerciseFrequency();

        public CommodityAmericanExerciseSequenceBuilder addExercisePeriod(CommodityExercisePeriods var1);

        public CommodityAmericanExerciseSequenceBuilder addExercisePeriod(CommodityExercisePeriods var1, int var2);

        public CommodityAmericanExerciseSequenceBuilder addExercisePeriod(List<? extends CommodityExercisePeriods> var1);

        public CommodityAmericanExerciseSequenceBuilder setExercisePeriod(List<? extends CommodityExercisePeriods> var1);

        public CommodityAmericanExerciseSequenceBuilder setExerciseFrequency(Frequency var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("exercisePeriod"), processor, CommodityExercisePeriods.CommodityExercisePeriodsBuilder.class, this.getExercisePeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseFrequency"), processor, Frequency.FrequencyBuilder.class, this.getExerciseFrequency(), new AttributeMeta[0]);
        }

        public CommodityAmericanExerciseSequenceBuilder prune();
    }

    public static class CommodityAmericanExerciseSequenceImpl
    implements CommodityAmericanExerciseSequence {
        private final List<? extends CommodityExercisePeriods> exercisePeriod;
        private final Frequency exerciseFrequency;

        protected CommodityAmericanExerciseSequenceImpl(CommodityAmericanExerciseSequenceBuilder builder) {
            this.exercisePeriod = Optional.ofNullable(builder.getExercisePeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.exerciseFrequency = Optional.ofNullable(builder.getExerciseFrequency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="exercisePeriod", isRequired=true)
        @RuneAttribute(value="exercisePeriod", isRequired=true)
        public List<? extends CommodityExercisePeriods> getExercisePeriod() {
            return this.exercisePeriod;
        }

        @Override
        @RosettaAttribute(value="exerciseFrequency")
        @RuneAttribute(value="exerciseFrequency")
        public Frequency getExerciseFrequency() {
            return this.exerciseFrequency;
        }

        @Override
        public CommodityAmericanExerciseSequence build() {
            return this;
        }

        @Override
        public CommodityAmericanExerciseSequenceBuilder toBuilder() {
            CommodityAmericanExerciseSequenceBuilder builder = CommodityAmericanExerciseSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityAmericanExerciseSequenceBuilder builder) {
            Optional.ofNullable(this.getExercisePeriod()).ifPresent(builder::setExercisePeriod);
            Optional.ofNullable(this.getExerciseFrequency()).ifPresent(builder::setExerciseFrequency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityAmericanExerciseSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.exercisePeriod, _that.getExercisePeriod())) {
                return false;
            }
            return Objects.equals(this.exerciseFrequency, _that.getExerciseFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.exercisePeriod != null ? this.exercisePeriod.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFrequency != null ? this.exerciseFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityAmericanExerciseSequence {exercisePeriod=" + this.exercisePeriod + ", exerciseFrequency=" + this.exerciseFrequency + '}';
        }
    }
}

