/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.DayCountFraction;
import fpml.confirmation.Frequency;
import fpml.confirmation.meta.BondCalculationModelMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BondCalculationModel", builder=BondCalculationModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="BondCalculationModel", model="fpml", builder=BondCalculationModelBuilderImpl.class, version="0.17.2")
public interface BondCalculationModel
extends RosettaModelObject {
    public static final BondCalculationModelMeta metaData = new BondCalculationModelMeta();

    public Frequency getPaymentFrequency();

    public DayCountFraction getDayCountFraction();

    public BondCalculationModel build();

    public BondCalculationModelBuilder toBuilder();

    public static BondCalculationModelBuilder builder() {
        return new BondCalculationModelBuilderImpl();
    }

    default public RosettaMetaData<? extends BondCalculationModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BondCalculationModel> getType() {
        return BondCalculationModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Frequency.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
    }

    public static class BondCalculationModelBuilderImpl
    implements BondCalculationModelBuilder {
        protected Frequency.FrequencyBuilder paymentFrequency;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Frequency.FrequencyBuilder getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public Frequency.FrequencyBuilder getOrCreatePaymentFrequency() {
            Frequency.FrequencyBuilder result = this.paymentFrequency != null ? this.paymentFrequency : (this.paymentFrequency = Frequency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public BondCalculationModelBuilder setPaymentFrequency(Frequency _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public BondCalculationModelBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        public BondCalculationModel build() {
            return new BondCalculationModelImpl(this);
        }

        @Override
        public BondCalculationModelBuilder toBuilder() {
            return this;
        }

        @Override
        public BondCalculationModelBuilder prune() {
            if (this.paymentFrequency != null && !this.paymentFrequency.prune().hasData()) {
                this.paymentFrequency = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPaymentFrequency() != null && this.getPaymentFrequency().hasData()) {
                return true;
            }
            return this.getDayCountFraction() != null && this.getDayCountFraction().hasData();
        }

        public BondCalculationModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BondCalculationModelBuilder o = (BondCalculationModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentFrequency(), (RosettaModelObjectBuilder)o.getPaymentFrequency(), this::setPaymentFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondCalculationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondCalculationModelBuilder {paymentFrequency=" + this.paymentFrequency + ", dayCountFraction=" + this.dayCountFraction + '}';
        }
    }

    public static interface BondCalculationModelBuilder
    extends BondCalculationModel,
    RosettaModelObjectBuilder {
        public Frequency.FrequencyBuilder getOrCreatePaymentFrequency();

        @Override
        public Frequency.FrequencyBuilder getPaymentFrequency();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public BondCalculationModelBuilder setPaymentFrequency(Frequency var1);

        public BondCalculationModelBuilder setDayCountFraction(DayCountFraction var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Frequency.FrequencyBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
        }

        public BondCalculationModelBuilder prune();
    }

    public static class BondCalculationModelImpl
    implements BondCalculationModel {
        private final Frequency paymentFrequency;
        private final DayCountFraction dayCountFraction;

        protected BondCalculationModelImpl(BondCalculationModelBuilder builder) {
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Frequency getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public BondCalculationModel build() {
            return this;
        }

        @Override
        public BondCalculationModelBuilder toBuilder() {
            BondCalculationModelBuilder builder = BondCalculationModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BondCalculationModelBuilder builder) {
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondCalculationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondCalculationModel {paymentFrequency=" + this.paymentFrequency + ", dayCountFraction=" + this.dayCountFraction + '}';
        }
    }
}

