/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.ParentTaskIdentifier;
import fpml.confirmation.PartyReference;
import fpml.confirmation.TaskDates;
import fpml.confirmation.TaskIdentifier;
import fpml.confirmation.TaskStatusEnum;
import fpml.confirmation.meta.AbstractTaskMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractTask", builder=AbstractTaskBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AbstractTask", model="fpml", builder=AbstractTaskBuilderImpl.class, version="0.17.2")
public interface AbstractTask
extends RosettaModelObject {
    public static final AbstractTaskMeta metaData = new AbstractTaskMeta();

    public List<? extends TaskIdentifier> getTaskIdentifier();

    public ParentTaskIdentifier getParentTaskIdentifier();

    public TaskIdentifier getPreviousTaskIdentifier();

    public TaskIdentifier getCorrectedTaskIdentifier();

    public PartyReference getResponsibleParty();

    public TaskDates getDates();

    public TaskStatusEnum getStatus();

    public String getComment();

    public AbstractTask build();

    public AbstractTaskBuilder toBuilder();

    public static AbstractTaskBuilder builder() {
        return new AbstractTaskBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractTask> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractTask> getType() {
        return AbstractTask.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("taskIdentifier"), processor, TaskIdentifier.class, this.getTaskIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("parentTaskIdentifier"), processor, ParentTaskIdentifier.class, this.getParentTaskIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("previousTaskIdentifier"), processor, TaskIdentifier.class, this.getPreviousTaskIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correctedTaskIdentifier"), processor, TaskIdentifier.class, this.getCorrectedTaskIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("responsibleParty"), processor, PartyReference.class, this.getResponsibleParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dates"), processor, TaskDates.class, this.getDates(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("status"), TaskStatusEnum.class, (Object)this.getStatus(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AbstractTaskBuilderImpl
    implements AbstractTaskBuilder {
        protected List<TaskIdentifier.TaskIdentifierBuilder> taskIdentifier = new ArrayList<TaskIdentifier.TaskIdentifierBuilder>();
        protected ParentTaskIdentifier.ParentTaskIdentifierBuilder parentTaskIdentifier;
        protected TaskIdentifier.TaskIdentifierBuilder previousTaskIdentifier;
        protected TaskIdentifier.TaskIdentifierBuilder correctedTaskIdentifier;
        protected PartyReference.PartyReferenceBuilder responsibleParty;
        protected TaskDates.TaskDatesBuilder dates;
        protected TaskStatusEnum status;
        protected String comment;

        @Override
        @RosettaAttribute(value="taskIdentifier", isRequired=true)
        @RuneAttribute(value="taskIdentifier", isRequired=true)
        public List<? extends TaskIdentifier.TaskIdentifierBuilder> getTaskIdentifier() {
            return this.taskIdentifier;
        }

        @Override
        public TaskIdentifier.TaskIdentifierBuilder getOrCreateTaskIdentifier(int index) {
            if (this.taskIdentifier == null) {
                this.taskIdentifier = new ArrayList<TaskIdentifier.TaskIdentifierBuilder>();
            }
            return (TaskIdentifier.TaskIdentifierBuilder)this.getIndex(this.taskIdentifier, index, () -> {
                TaskIdentifier.TaskIdentifierBuilder newTaskIdentifier = TaskIdentifier.builder();
                return newTaskIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="parentTaskIdentifier")
        @RuneAttribute(value="parentTaskIdentifier")
        public ParentTaskIdentifier.ParentTaskIdentifierBuilder getParentTaskIdentifier() {
            return this.parentTaskIdentifier;
        }

        @Override
        public ParentTaskIdentifier.ParentTaskIdentifierBuilder getOrCreateParentTaskIdentifier() {
            ParentTaskIdentifier.ParentTaskIdentifierBuilder result = this.parentTaskIdentifier != null ? this.parentTaskIdentifier : (this.parentTaskIdentifier = ParentTaskIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="previousTaskIdentifier")
        @RuneAttribute(value="previousTaskIdentifier")
        public TaskIdentifier.TaskIdentifierBuilder getPreviousTaskIdentifier() {
            return this.previousTaskIdentifier;
        }

        @Override
        public TaskIdentifier.TaskIdentifierBuilder getOrCreatePreviousTaskIdentifier() {
            TaskIdentifier.TaskIdentifierBuilder result = this.previousTaskIdentifier != null ? this.previousTaskIdentifier : (this.previousTaskIdentifier = TaskIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="correctedTaskIdentifier")
        @RuneAttribute(value="correctedTaskIdentifier")
        public TaskIdentifier.TaskIdentifierBuilder getCorrectedTaskIdentifier() {
            return this.correctedTaskIdentifier;
        }

        @Override
        public TaskIdentifier.TaskIdentifierBuilder getOrCreateCorrectedTaskIdentifier() {
            TaskIdentifier.TaskIdentifierBuilder result = this.correctedTaskIdentifier != null ? this.correctedTaskIdentifier : (this.correctedTaskIdentifier = TaskIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="responsibleParty", isRequired=true)
        @RuneAttribute(value="responsibleParty", isRequired=true)
        public PartyReference.PartyReferenceBuilder getResponsibleParty() {
            return this.responsibleParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateResponsibleParty() {
            PartyReference.PartyReferenceBuilder result = this.responsibleParty != null ? this.responsibleParty : (this.responsibleParty = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dates", isRequired=true)
        @RuneAttribute(value="dates", isRequired=true)
        public TaskDates.TaskDatesBuilder getDates() {
            return this.dates;
        }

        @Override
        public TaskDates.TaskDatesBuilder getOrCreateDates() {
            TaskDates.TaskDatesBuilder result = this.dates != null ? this.dates : (this.dates = TaskDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public TaskStatusEnum getStatus() {
            return this.status;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public String getComment() {
            return this.comment;
        }

        @Override
        @RosettaAttribute(value="taskIdentifier", isRequired=true)
        @RuneAttribute(value="taskIdentifier", isRequired=true)
        public AbstractTaskBuilder addTaskIdentifier(TaskIdentifier _taskIdentifier) {
            if (_taskIdentifier != null) {
                this.taskIdentifier.add(_taskIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractTaskBuilder addTaskIdentifier(TaskIdentifier _taskIdentifier, int idx) {
            this.getIndex(this.taskIdentifier, idx, () -> _taskIdentifier.toBuilder());
            return this;
        }

        @Override
        public AbstractTaskBuilder addTaskIdentifier(List<? extends TaskIdentifier> taskIdentifiers) {
            if (taskIdentifiers != null) {
                for (TaskIdentifier taskIdentifier : taskIdentifiers) {
                    this.taskIdentifier.add(taskIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taskIdentifier")
        public AbstractTaskBuilder setTaskIdentifier(List<? extends TaskIdentifier> taskIdentifiers) {
            this.taskIdentifier = taskIdentifiers == null ? new ArrayList<TaskIdentifier.TaskIdentifierBuilder>() : (List)taskIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="parentTaskIdentifier")
        @RuneAttribute(value="parentTaskIdentifier")
        public AbstractTaskBuilder setParentTaskIdentifier(ParentTaskIdentifier _parentTaskIdentifier) {
            this.parentTaskIdentifier = _parentTaskIdentifier == null ? null : _parentTaskIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="previousTaskIdentifier")
        @RuneAttribute(value="previousTaskIdentifier")
        public AbstractTaskBuilder setPreviousTaskIdentifier(TaskIdentifier _previousTaskIdentifier) {
            this.previousTaskIdentifier = _previousTaskIdentifier == null ? null : _previousTaskIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correctedTaskIdentifier")
        @RuneAttribute(value="correctedTaskIdentifier")
        public AbstractTaskBuilder setCorrectedTaskIdentifier(TaskIdentifier _correctedTaskIdentifier) {
            this.correctedTaskIdentifier = _correctedTaskIdentifier == null ? null : _correctedTaskIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="responsibleParty", isRequired=true)
        @RuneAttribute(value="responsibleParty", isRequired=true)
        public AbstractTaskBuilder setResponsibleParty(PartyReference _responsibleParty) {
            this.responsibleParty = _responsibleParty == null ? null : _responsibleParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dates", isRequired=true)
        @RuneAttribute(value="dates", isRequired=true)
        public AbstractTaskBuilder setDates(TaskDates _dates) {
            this.dates = _dates == null ? null : _dates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public AbstractTaskBuilder setStatus(TaskStatusEnum _status) {
            this.status = _status == null ? null : _status;
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public AbstractTaskBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        public AbstractTask build() {
            return new AbstractTaskImpl(this);
        }

        @Override
        public AbstractTaskBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractTaskBuilder prune() {
            this.taskIdentifier = this.taskIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.parentTaskIdentifier != null && !this.parentTaskIdentifier.prune().hasData()) {
                this.parentTaskIdentifier = null;
            }
            if (this.previousTaskIdentifier != null && !this.previousTaskIdentifier.prune().hasData()) {
                this.previousTaskIdentifier = null;
            }
            if (this.correctedTaskIdentifier != null && !this.correctedTaskIdentifier.prune().hasData()) {
                this.correctedTaskIdentifier = null;
            }
            if (this.responsibleParty != null && !this.responsibleParty.prune().hasData()) {
                this.responsibleParty = null;
            }
            if (this.dates != null && !this.dates.prune().hasData()) {
                this.dates = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTaskIdentifier() != null && this.getTaskIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getParentTaskIdentifier() != null && this.getParentTaskIdentifier().hasData()) {
                return true;
            }
            if (this.getPreviousTaskIdentifier() != null && this.getPreviousTaskIdentifier().hasData()) {
                return true;
            }
            if (this.getCorrectedTaskIdentifier() != null && this.getCorrectedTaskIdentifier().hasData()) {
                return true;
            }
            if (this.getResponsibleParty() != null && this.getResponsibleParty().hasData()) {
                return true;
            }
            if (this.getDates() != null && this.getDates().hasData()) {
                return true;
            }
            if (this.getStatus() != null) {
                return true;
            }
            return this.getComment() != null;
        }

        public AbstractTaskBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AbstractTaskBuilder o = (AbstractTaskBuilder)other;
            merger.mergeRosetta(this.getTaskIdentifier(), o.getTaskIdentifier(), this::getOrCreateTaskIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getParentTaskIdentifier(), (RosettaModelObjectBuilder)o.getParentTaskIdentifier(), this::setParentTaskIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPreviousTaskIdentifier(), (RosettaModelObjectBuilder)o.getPreviousTaskIdentifier(), this::setPreviousTaskIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCorrectedTaskIdentifier(), (RosettaModelObjectBuilder)o.getCorrectedTaskIdentifier(), this::setCorrectedTaskIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getResponsibleParty(), (RosettaModelObjectBuilder)o.getResponsibleParty(), this::setResponsibleParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDates(), (RosettaModelObjectBuilder)o.getDates(), this::setDates);
            merger.mergeBasic((Object)this.getStatus(), (Object)o.getStatus(), this::setStatus, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getComment(), (Object)o.getComment(), this::setComment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractTask _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.taskIdentifier, _that.getTaskIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.parentTaskIdentifier, _that.getParentTaskIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.previousTaskIdentifier, _that.getPreviousTaskIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.correctedTaskIdentifier, _that.getCorrectedTaskIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.responsibleParty, _that.getResponsibleParty())) {
                return false;
            }
            if (!Objects.equals(this.dates, _that.getDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.status, (Object)_that.getStatus())) {
                return false;
            }
            return Objects.equals(this.comment, _that.getComment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.taskIdentifier != null ? this.taskIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.parentTaskIdentifier != null ? this.parentTaskIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.previousTaskIdentifier != null ? this.previousTaskIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.correctedTaskIdentifier != null ? this.correctedTaskIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.responsibleParty != null ? this.responsibleParty.hashCode() : 0);
            _result = 31 * _result + (this.dates != null ? this.dates.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? ((Object)((Object)this.status)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractTaskBuilder {taskIdentifier=" + this.taskIdentifier + ", parentTaskIdentifier=" + this.parentTaskIdentifier + ", previousTaskIdentifier=" + this.previousTaskIdentifier + ", correctedTaskIdentifier=" + this.correctedTaskIdentifier + ", responsibleParty=" + this.responsibleParty + ", dates=" + this.dates + ", status=" + (Object)((Object)this.status) + ", comment=" + this.comment + '}';
        }
    }

    public static interface AbstractTaskBuilder
    extends AbstractTask,
    RosettaModelObjectBuilder {
        public TaskIdentifier.TaskIdentifierBuilder getOrCreateTaskIdentifier(int var1);

        public List<? extends TaskIdentifier.TaskIdentifierBuilder> getTaskIdentifier();

        public ParentTaskIdentifier.ParentTaskIdentifierBuilder getOrCreateParentTaskIdentifier();

        @Override
        public ParentTaskIdentifier.ParentTaskIdentifierBuilder getParentTaskIdentifier();

        public TaskIdentifier.TaskIdentifierBuilder getOrCreatePreviousTaskIdentifier();

        @Override
        public TaskIdentifier.TaskIdentifierBuilder getPreviousTaskIdentifier();

        public TaskIdentifier.TaskIdentifierBuilder getOrCreateCorrectedTaskIdentifier();

        @Override
        public TaskIdentifier.TaskIdentifierBuilder getCorrectedTaskIdentifier();

        public PartyReference.PartyReferenceBuilder getOrCreateResponsibleParty();

        @Override
        public PartyReference.PartyReferenceBuilder getResponsibleParty();

        public TaskDates.TaskDatesBuilder getOrCreateDates();

        @Override
        public TaskDates.TaskDatesBuilder getDates();

        public AbstractTaskBuilder addTaskIdentifier(TaskIdentifier var1);

        public AbstractTaskBuilder addTaskIdentifier(TaskIdentifier var1, int var2);

        public AbstractTaskBuilder addTaskIdentifier(List<? extends TaskIdentifier> var1);

        public AbstractTaskBuilder setTaskIdentifier(List<? extends TaskIdentifier> var1);

        public AbstractTaskBuilder setParentTaskIdentifier(ParentTaskIdentifier var1);

        public AbstractTaskBuilder setPreviousTaskIdentifier(TaskIdentifier var1);

        public AbstractTaskBuilder setCorrectedTaskIdentifier(TaskIdentifier var1);

        public AbstractTaskBuilder setResponsibleParty(PartyReference var1);

        public AbstractTaskBuilder setDates(TaskDates var1);

        public AbstractTaskBuilder setStatus(TaskStatusEnum var1);

        public AbstractTaskBuilder setComment(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("taskIdentifier"), processor, TaskIdentifier.TaskIdentifierBuilder.class, this.getTaskIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("parentTaskIdentifier"), processor, ParentTaskIdentifier.ParentTaskIdentifierBuilder.class, this.getParentTaskIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("previousTaskIdentifier"), processor, TaskIdentifier.TaskIdentifierBuilder.class, this.getPreviousTaskIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correctedTaskIdentifier"), processor, TaskIdentifier.TaskIdentifierBuilder.class, this.getCorrectedTaskIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("responsibleParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getResponsibleParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dates"), processor, TaskDates.TaskDatesBuilder.class, this.getDates(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("status"), TaskStatusEnum.class, (Object)this.getStatus(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AbstractTaskBuilder prune();
    }

    public static class AbstractTaskImpl
    implements AbstractTask {
        private final List<? extends TaskIdentifier> taskIdentifier;
        private final ParentTaskIdentifier parentTaskIdentifier;
        private final TaskIdentifier previousTaskIdentifier;
        private final TaskIdentifier correctedTaskIdentifier;
        private final PartyReference responsibleParty;
        private final TaskDates dates;
        private final TaskStatusEnum status;
        private final String comment;

        protected AbstractTaskImpl(AbstractTaskBuilder builder) {
            this.taskIdentifier = Optional.ofNullable(builder.getTaskIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.parentTaskIdentifier = Optional.ofNullable(builder.getParentTaskIdentifier()).map(f -> f.build()).orElse(null);
            this.previousTaskIdentifier = Optional.ofNullable(builder.getPreviousTaskIdentifier()).map(f -> f.build()).orElse(null);
            this.correctedTaskIdentifier = Optional.ofNullable(builder.getCorrectedTaskIdentifier()).map(f -> f.build()).orElse(null);
            this.responsibleParty = Optional.ofNullable(builder.getResponsibleParty()).map(f -> f.build()).orElse(null);
            this.dates = Optional.ofNullable(builder.getDates()).map(f -> f.build()).orElse(null);
            this.status = builder.getStatus();
            this.comment = builder.getComment();
        }

        @Override
        @RosettaAttribute(value="taskIdentifier", isRequired=true)
        @RuneAttribute(value="taskIdentifier", isRequired=true)
        public List<? extends TaskIdentifier> getTaskIdentifier() {
            return this.taskIdentifier;
        }

        @Override
        @RosettaAttribute(value="parentTaskIdentifier")
        @RuneAttribute(value="parentTaskIdentifier")
        public ParentTaskIdentifier getParentTaskIdentifier() {
            return this.parentTaskIdentifier;
        }

        @Override
        @RosettaAttribute(value="previousTaskIdentifier")
        @RuneAttribute(value="previousTaskIdentifier")
        public TaskIdentifier getPreviousTaskIdentifier() {
            return this.previousTaskIdentifier;
        }

        @Override
        @RosettaAttribute(value="correctedTaskIdentifier")
        @RuneAttribute(value="correctedTaskIdentifier")
        public TaskIdentifier getCorrectedTaskIdentifier() {
            return this.correctedTaskIdentifier;
        }

        @Override
        @RosettaAttribute(value="responsibleParty", isRequired=true)
        @RuneAttribute(value="responsibleParty", isRequired=true)
        public PartyReference getResponsibleParty() {
            return this.responsibleParty;
        }

        @Override
        @RosettaAttribute(value="dates", isRequired=true)
        @RuneAttribute(value="dates", isRequired=true)
        public TaskDates getDates() {
            return this.dates;
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public TaskStatusEnum getStatus() {
            return this.status;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public String getComment() {
            return this.comment;
        }

        @Override
        public AbstractTask build() {
            return this;
        }

        @Override
        public AbstractTaskBuilder toBuilder() {
            AbstractTaskBuilder builder = AbstractTask.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractTaskBuilder builder) {
            Optional.ofNullable(this.getTaskIdentifier()).ifPresent(builder::setTaskIdentifier);
            Optional.ofNullable(this.getParentTaskIdentifier()).ifPresent(builder::setParentTaskIdentifier);
            Optional.ofNullable(this.getPreviousTaskIdentifier()).ifPresent(builder::setPreviousTaskIdentifier);
            Optional.ofNullable(this.getCorrectedTaskIdentifier()).ifPresent(builder::setCorrectedTaskIdentifier);
            Optional.ofNullable(this.getResponsibleParty()).ifPresent(builder::setResponsibleParty);
            Optional.ofNullable(this.getDates()).ifPresent(builder::setDates);
            Optional.ofNullable(this.getStatus()).ifPresent(builder::setStatus);
            Optional.ofNullable(this.getComment()).ifPresent(builder::setComment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AbstractTask _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.taskIdentifier, _that.getTaskIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.parentTaskIdentifier, _that.getParentTaskIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.previousTaskIdentifier, _that.getPreviousTaskIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.correctedTaskIdentifier, _that.getCorrectedTaskIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.responsibleParty, _that.getResponsibleParty())) {
                return false;
            }
            if (!Objects.equals(this.dates, _that.getDates())) {
                return false;
            }
            if (!Objects.equals((Object)this.status, (Object)_that.getStatus())) {
                return false;
            }
            return Objects.equals(this.comment, _that.getComment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.taskIdentifier != null ? this.taskIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.parentTaskIdentifier != null ? this.parentTaskIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.previousTaskIdentifier != null ? this.previousTaskIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.correctedTaskIdentifier != null ? this.correctedTaskIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.responsibleParty != null ? this.responsibleParty.hashCode() : 0);
            _result = 31 * _result + (this.dates != null ? this.dates.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? ((Object)((Object)this.status)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AbstractTask {taskIdentifier=" + this.taskIdentifier + ", parentTaskIdentifier=" + this.parentTaskIdentifier + ", previousTaskIdentifier=" + this.previousTaskIdentifier + ", correctedTaskIdentifier=" + this.correctedTaskIdentifier + ", responsibleParty=" + this.responsibleParty + ", dates=" + this.dates + ", status=" + (Object)((Object)this.status) + ", comment=" + this.comment + '}';
        }
    }
}

