/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.metafields;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.ReferenceWithMetaVoidMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ReferenceWithMetaVoid", builder=ReferenceWithMetaVoidBuilderImpl.class, version="0.0.0")
@RuneDataType(value="ReferenceWithMetaVoid", model="com", builder=ReferenceWithMetaVoidBuilderImpl.class, version="0.0.0")
public interface ReferenceWithMetaVoid
extends RosettaModelObject,
ReferenceWithMeta<Void> {
    public static final ReferenceWithMetaVoidMeta metaData = new ReferenceWithMetaVoidMeta();

    public Void getValue();

    public String getGlobalReference();

    public String getExternalReference();

    public Reference getReference();

    public ReferenceWithMetaVoid build();

    public ReferenceWithMetaVoidBuilder toBuilder();

    public static ReferenceWithMetaVoidBuilder builder() {
        return new ReferenceWithMetaVoidBuilderImpl();
    }

    default public RosettaMetaData<? extends ReferenceWithMetaVoid> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReferenceWithMetaVoid> getType() {
        return ReferenceWithMetaVoid.class;
    }

    default public Class<Void> getValueType() {
        return Void.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("value"), Void.class, (Object)this.getValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("globalReference"), String.class, (Object)this.getGlobalReference(), (RosettaModelObject)this, new AttributeMeta[]{AttributeMeta.META});
        processor.processBasic(path.newSubPath("externalReference"), String.class, (Object)this.getExternalReference(), (RosettaModelObject)this, new AttributeMeta[]{AttributeMeta.META});
        this.processRosetta(path.newSubPath("reference"), processor, Reference.class, (RosettaModelObject)this.getReference(), new AttributeMeta[0]);
    }

    public static class ReferenceWithMetaVoidBuilderImpl
    implements ReferenceWithMetaVoidBuilder {
        protected Void value;
        protected String globalReference;
        protected String externalReference;
        protected Reference.ReferenceBuilder reference;

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="@data")
        public Void getValue() {
            return this.value;
        }

        @Override
        @RosettaAttribute(value="globalReference")
        @RuneAttribute(value="@ref")
        public String getGlobalReference() {
            return this.globalReference;
        }

        @Override
        @RosettaAttribute(value="externalReference")
        @RuneAttribute(value="@ref:external")
        public String getExternalReference() {
            return this.externalReference;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="@ref:scoped")
        @RuneMetaType
        public Reference.ReferenceBuilder getReference() {
            return this.reference;
        }

        @Override
        public Reference.ReferenceBuilder getOrCreateReference() {
            Reference.ReferenceBuilder result = this.reference != null ? this.reference : (this.reference = Reference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="@data")
        public ReferenceWithMetaVoidBuilder setValue(Void _value) {
            this.value = _value == null ? null : _value;
            return this;
        }

        @Override
        @RosettaAttribute(value="globalReference")
        @RuneAttribute(value="@ref")
        public ReferenceWithMetaVoidBuilder setGlobalReference(String _globalReference) {
            this.globalReference = _globalReference == null ? null : _globalReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="externalReference")
        @RuneAttribute(value="@ref:external")
        public ReferenceWithMetaVoidBuilder setExternalReference(String _externalReference) {
            this.externalReference = _externalReference == null ? null : _externalReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="@ref:scoped")
        @RuneMetaType
        public ReferenceWithMetaVoidBuilder setReference(Reference _reference) {
            this.reference = _reference == null ? null : _reference.toBuilder();
            return this;
        }

        @Override
        public ReferenceWithMetaVoid build() {
            return new ReferenceWithMetaVoidImpl(this);
        }

        @Override
        public ReferenceWithMetaVoidBuilder toBuilder() {
            return this;
        }

        @Override
        public ReferenceWithMetaVoidBuilder prune() {
            if (this.reference != null && !this.reference.prune().hasData()) {
                this.reference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getValue() != null) {
                return true;
            }
            if (this.getGlobalReference() != null) {
                return true;
            }
            if (this.getExternalReference() != null) {
                return true;
            }
            return this.getReference() != null && this.getReference().hasData();
        }

        public ReferenceWithMetaVoidBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReferenceWithMetaVoidBuilder o = (ReferenceWithMetaVoidBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReference(), (RosettaModelObjectBuilder)o.getReference(), this::setReference);
            merger.mergeBasic((Object)this.getValue(), (Object)o.getValue(), this::setValue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGlobalReference(), (Object)o.getGlobalReference(), this::setGlobalReference, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExternalReference(), (Object)o.getExternalReference(), this::setExternalReference, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceWithMetaVoid _that = this.getType().cast(o);
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            if (!Objects.equals(this.globalReference, _that.getGlobalReference())) {
                return false;
            }
            if (!Objects.equals(this.externalReference, _that.getExternalReference())) {
                return false;
            }
            return Objects.equals(this.reference, _that.getReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.globalReference != null ? this.globalReference.hashCode() : 0);
            _result = 31 * _result + (this.externalReference != null ? this.externalReference.hashCode() : 0);
            _result = 31 * _result + (this.reference != null ? this.reference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceWithMetaVoidBuilder {value=" + this.value + ", globalReference=" + this.globalReference + ", externalReference=" + this.externalReference + ", reference=" + this.reference + '}';
        }
    }

    public static interface ReferenceWithMetaVoidBuilder
    extends ReferenceWithMetaVoid,
    RosettaModelObjectBuilder,
    ReferenceWithMeta.ReferenceWithMetaBuilder<Void> {
        public Reference.ReferenceBuilder getOrCreateReference();

        public Reference.ReferenceBuilder getReference();

        public ReferenceWithMetaVoidBuilder setValue(Void var1);

        public ReferenceWithMetaVoidBuilder setGlobalReference(String var1);

        public ReferenceWithMetaVoidBuilder setExternalReference(String var1);

        public ReferenceWithMetaVoidBuilder setReference(Reference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("value"), Void.class, (Object)this.getValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("globalReference"), String.class, (Object)this.getGlobalReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[]{AttributeMeta.META});
            processor.processBasic(path.newSubPath("externalReference"), String.class, (Object)this.getExternalReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[]{AttributeMeta.META});
            this.processRosetta(path.newSubPath("reference"), processor, Reference.ReferenceBuilder.class, (RosettaModelObjectBuilder)this.getReference(), new AttributeMeta[0]);
        }

        public ReferenceWithMetaVoidBuilder prune();
    }

    public static class ReferenceWithMetaVoidImpl
    implements ReferenceWithMetaVoid {
        private final Void value;
        private final String globalReference;
        private final String externalReference;
        private final Reference reference;

        protected ReferenceWithMetaVoidImpl(ReferenceWithMetaVoidBuilder builder) {
            this.value = builder.getValue();
            this.globalReference = builder.getGlobalReference();
            this.externalReference = builder.getExternalReference();
            this.reference = Optional.ofNullable(builder.getReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="@data")
        public Void getValue() {
            return this.value;
        }

        @Override
        @RosettaAttribute(value="globalReference")
        @RuneAttribute(value="@ref")
        public String getGlobalReference() {
            return this.globalReference;
        }

        @Override
        @RosettaAttribute(value="externalReference")
        @RuneAttribute(value="@ref:external")
        public String getExternalReference() {
            return this.externalReference;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="@ref:scoped")
        @RuneMetaType
        public Reference getReference() {
            return this.reference;
        }

        @Override
        public ReferenceWithMetaVoid build() {
            return this;
        }

        @Override
        public ReferenceWithMetaVoidBuilder toBuilder() {
            ReferenceWithMetaVoidBuilder builder = ReferenceWithMetaVoid.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReferenceWithMetaVoidBuilder builder) {
            Optional.ofNullable(this.getValue()).ifPresent(builder::setValue);
            Optional.ofNullable(this.getGlobalReference()).ifPresent(builder::setGlobalReference);
            Optional.ofNullable(this.getExternalReference()).ifPresent(builder::setExternalReference);
            Optional.ofNullable(this.getReference()).ifPresent(builder::setReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceWithMetaVoid _that = this.getType().cast(o);
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            if (!Objects.equals(this.globalReference, _that.getGlobalReference())) {
                return false;
            }
            if (!Objects.equals(this.externalReference, _that.getExternalReference())) {
                return false;
            }
            return Objects.equals(this.reference, _that.getReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.globalReference != null ? this.globalReference.hashCode() : 0);
            _result = 31 * _result + (this.externalReference != null ? this.externalReference.hashCode() : 0);
            _result = 31 * _result + (this.reference != null ? this.reference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceWithMetaVoid {value=" + this.value + ", globalReference=" + this.globalReference + ", externalReference=" + this.externalReference + ", reference=" + this.reference + '}';
        }
    }
}

