/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.AssetPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AssetPayoutUnderlierNotCash")
@ImplementedBy(value=Default.class)
public interface AssetPayoutUnderlierNotCash
extends Validator<AssetPayout> {
    public static final String NAME = "AssetPayoutUnderlierNotCash";
    public static final String DEFINITION = "underlier -> Cash is absent";

    public static class NoOp
    implements AssetPayoutUnderlierNotCash {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetPayout assetPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AssetPayoutUnderlierNotCash {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetPayout assetPayout) {
            ComparisonResult result = this.executeDataRule(assetPayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AssetPayoutUnderlierNotCash.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutUnderlierNotCash.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AssetPayoutUnderlierNotCash.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutUnderlierNotCash.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AssetPayout assetPayout) {
            try {
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)assetPayout).map("getUnderlier", _assetPayout -> _assetPayout.getUnderlier()).map("getCash", asset -> asset.getCash()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

