/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.processor;

import cdm.base.math.UnitType;
import cdm.observable.asset.PriceQuantity;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.observable.asset.processor.PriceQuantityHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class InterestRateForwardDebtPriceMappingProcessor
extends MappingProcessor {
    public InterestRateForwardDebtPriceMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path genenicProductPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        List<? extends RosettaModelObjectBuilder> priceQuantityBuilders = builders;
        Path tradePath = genenicProductPath.getParent();
        Path topLevelPath = tradePath.getParent();
        this.findMappings(this.getMappings(), topLevelPath.addElement("quote")).entrySet().forEach(entry -> {
            Path quotePath = (Path)entry.getKey();
            List quoteMappings = (List)entry.getValue();
            this.addPrice(genenicProductPath, InterestRateForwardDebtPriceMappingProcessor.getPriceQuantityBuilder(priceQuantityBuilders), quotePath, quoteMappings);
        });
    }

    private static PriceQuantity.PriceQuantityBuilder getPriceQuantityBuilder(List<PriceQuantity.PriceQuantityBuilder> priceQuantityBuilders) {
        return priceQuantityBuilders.stream().filter(RosettaModelObjectBuilder::hasData).findFirst().orElse(null);
    }

    private Map<Path, List<Mapping>> findMappings(List<Mapping> mappings, Path synonymPath) {
        return mappings.stream().filter(m -> synonymPath.nameStartMatches(m.getXmlPath())).filter(m -> Objects.nonNull(m.getXmlValue())).collect(Collectors.groupingBy(m -> m.getXmlPath().getParent()));
    }

    private void addPrice(Path genenicProductPath, PriceQuantity.PriceQuantityBuilder priceQuantityBuilder, Path quotePath, List<Mapping> quoteMappings) {
        Mapping valueMapping = MappingProcessorUtils.getNonNullMapping(quoteMappings, (Path)quotePath.addElement("value")).orElse(null);
        Mapping quoteUnitsMapping = MappingProcessorUtils.getNonNullMapping(quoteMappings, (Path)quotePath.addElement("quoteUnits")).orElse(null);
        if (InterestRateForwardDebtPriceMappingProcessor.isPriceNotation(quotePath, quoteMappings).booleanValue() && valueMapping != null) {
            BigDecimal rate = new BigDecimal(String.valueOf(valueMapping.getXmlValue()));
            if (quoteUnitsMapping != null && String.valueOf(quoteUnitsMapping.getXmlValue()).equals("Percentage")) {
                rate = rate.divide(BigDecimal.valueOf(100L));
            }
            UnitType.UnitTypeBuilder unitType = this.toCurrencyUnitType(genenicProductPath);
            PriceTypeEnum priceType = PriceTypeEnum.ASSET_PRICE;
            FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder fieldWithPriceScheduleBuilder = PriceQuantityHelper.toReferencablePriceBuilder(rate, unitType, unitType, priceType, null, null);
            Path baseModelPath = PathUtils.toPath((RosettaPath)this.getModelPath()).addElement("price", Integer.valueOf(0)).addElement("value");
            Path amountModelPath = PriceQuantityHelper.incrementPathElementIndex(baseModelPath, "price", CollectionUtils.emptyIfNull(priceQuantityBuilder.getPrice()).size());
            this.updateMapping(valueMapping, amountModelPath);
            priceQuantityBuilder.addPrice(fieldWithPriceScheduleBuilder);
        }
    }

    private static Boolean isPriceNotation(Path quotePath, List<Mapping> quoteMappings) {
        return MappingProcessorUtils.getNonNullMappedValue((Path)quotePath.addElement("measureType"), quoteMappings).map("PriceNotation"::equals).orElse(false);
    }

    private UnitType.UnitTypeBuilder toCurrencyUnitType(Path startsWithPath) {
        String currency = MappingProcessorUtils.getNonNullMappedValue((List)this.getMappings(), (Path)startsWithPath, (String[])new String[]{"notional", "currency"}).orElse(null);
        String currencyScheme = MappingProcessorUtils.getNonNullMappedValue((List)this.getMappings(), (Path)startsWithPath, (String[])new String[]{"notional", "currency", "currencyScheme"}).orElse(null);
        return UnitType.builder().setCurrency(FieldWithMetaString.builder().setValue(currency).setMeta(MetaFields.builder().setScheme(currencyScheme).build()));
    }

    private void updateMapping(Mapping mapping, Path modelPath) {
        mapping.setRosettaPath(modelPath);
        mapping.setError(null);
        mapping.setCondition(true);
        mapping.setDuplicate(false);
    }
}

