/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.AncillaryParty;
import cdm.base.staticdata.party.Counterparty;
import cdm.product.common.NotionalAdjustmentEnum;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.TradeLot;
import cdm.product.template.meta.TradableProductMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradableProduct", builder=TradableProductBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="TradableProduct", model="cdm", builder=TradableProductBuilderImpl.class, version="7.0.0-dev.50")
public interface TradableProduct
extends RosettaModelObject {
    public static final TradableProductMeta metaData = new TradableProductMeta();

    public NonTransferableProduct getProduct();

    public List<? extends TradeLot> getTradeLot();

    public List<? extends Counterparty> getCounterparty();

    public List<? extends AncillaryParty> getAncillaryParty();

    public NotionalAdjustmentEnum getAdjustment();

    public TradableProduct build();

    public TradableProductBuilder toBuilder();

    public static TradableProductBuilder builder() {
        return new TradableProductBuilderImpl();
    }

    default public RosettaMetaData<? extends TradableProduct> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradableProduct> getType() {
        return TradableProduct.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("product"), processor, NonTransferableProduct.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeLot"), processor, TradeLot.class, this.getTradeLot(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.class, this.getCounterparty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.class, this.getAncillaryParty(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustment"), NotionalAdjustmentEnum.class, (Object)this.getAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TradableProductBuilderImpl
    implements TradableProductBuilder {
        protected NonTransferableProduct.NonTransferableProductBuilder product;
        protected List<TradeLot.TradeLotBuilder> tradeLot = new ArrayList<TradeLot.TradeLotBuilder>();
        protected List<Counterparty.CounterpartyBuilder> counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();
        protected List<AncillaryParty.AncillaryPartyBuilder> ancillaryParty = new ArrayList<AncillaryParty.AncillaryPartyBuilder>();
        protected NotionalAdjustmentEnum adjustment;

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public NonTransferableProduct.NonTransferableProductBuilder getProduct() {
            return this.product;
        }

        @Override
        public NonTransferableProduct.NonTransferableProductBuilder getOrCreateProduct() {
            NonTransferableProduct.NonTransferableProductBuilder result = this.product != null ? this.product : (this.product = NonTransferableProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeLot", isRequired=true)
        @RuneAttribute(value="tradeLot", isRequired=true)
        public List<? extends TradeLot.TradeLotBuilder> getTradeLot() {
            return this.tradeLot;
        }

        @Override
        public TradeLot.TradeLotBuilder getOrCreateTradeLot(int index) {
            if (this.tradeLot == null) {
                this.tradeLot = new ArrayList<TradeLot.TradeLotBuilder>();
            }
            return (TradeLot.TradeLotBuilder)this.getIndex(this.tradeLot, index, () -> {
                TradeLot.TradeLotBuilder newTradeLot = TradeLot.builder();
                return newTradeLot;
            });
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty() {
            return this.counterparty;
        }

        @Override
        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int index) {
            if (this.counterparty == null) {
                this.counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();
            }
            return (Counterparty.CounterpartyBuilder)this.getIndex(this.counterparty, index, () -> {
                Counterparty.CounterpartyBuilder newCounterparty = Counterparty.builder();
                return newCounterparty;
            });
        }

        @Override
        @RosettaAttribute(value="ancillaryParty")
        @RuneAttribute(value="ancillaryParty")
        public List<? extends AncillaryParty.AncillaryPartyBuilder> getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty(int index) {
            if (this.ancillaryParty == null) {
                this.ancillaryParty = new ArrayList<AncillaryParty.AncillaryPartyBuilder>();
            }
            return (AncillaryParty.AncillaryPartyBuilder)this.getIndex(this.ancillaryParty, index, () -> {
                AncillaryParty.AncillaryPartyBuilder newAncillaryParty = AncillaryParty.builder();
                return newAncillaryParty;
            });
        }

        @Override
        @RosettaAttribute(value="adjustment")
        @RuneAttribute(value="adjustment")
        public NotionalAdjustmentEnum getAdjustment() {
            return this.adjustment;
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public TradableProductBuilder setProduct(NonTransferableProduct _product) {
            this.product = _product == null ? null : _product.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeLot", isRequired=true)
        @RuneAttribute(value="tradeLot", isRequired=true)
        public TradableProductBuilder addTradeLot(TradeLot _tradeLot) {
            if (_tradeLot != null) {
                this.tradeLot.add(_tradeLot.toBuilder());
            }
            return this;
        }

        @Override
        public TradableProductBuilder addTradeLot(TradeLot _tradeLot, int idx) {
            this.getIndex(this.tradeLot, idx, () -> _tradeLot.toBuilder());
            return this;
        }

        @Override
        public TradableProductBuilder addTradeLot(List<? extends TradeLot> tradeLots) {
            if (tradeLots != null) {
                for (TradeLot tradeLot : tradeLots) {
                    this.tradeLot.add(tradeLot.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeLot")
        public TradableProductBuilder setTradeLot(List<? extends TradeLot> tradeLots) {
            this.tradeLot = tradeLots == null ? new ArrayList<TradeLot.TradeLotBuilder>() : (List)tradeLots.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public TradableProductBuilder addCounterparty(Counterparty _counterparty) {
            if (_counterparty != null) {
                this.counterparty.add(_counterparty.toBuilder());
            }
            return this;
        }

        @Override
        public TradableProductBuilder addCounterparty(Counterparty _counterparty, int idx) {
            this.getIndex(this.counterparty, idx, () -> _counterparty.toBuilder());
            return this;
        }

        @Override
        public TradableProductBuilder addCounterparty(List<? extends Counterparty> counterpartys) {
            if (counterpartys != null) {
                for (Counterparty counterparty : counterpartys) {
                    this.counterparty.add(counterparty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="counterparty")
        public TradableProductBuilder setCounterparty(List<? extends Counterparty> counterpartys) {
            this.counterparty = counterpartys == null ? new ArrayList<Counterparty.CounterpartyBuilder>() : (List)counterpartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="ancillaryParty")
        @RuneAttribute(value="ancillaryParty")
        public TradableProductBuilder addAncillaryParty(AncillaryParty _ancillaryParty) {
            if (_ancillaryParty != null) {
                this.ancillaryParty.add(_ancillaryParty.toBuilder());
            }
            return this;
        }

        @Override
        public TradableProductBuilder addAncillaryParty(AncillaryParty _ancillaryParty, int idx) {
            this.getIndex(this.ancillaryParty, idx, () -> _ancillaryParty.toBuilder());
            return this;
        }

        @Override
        public TradableProductBuilder addAncillaryParty(List<? extends AncillaryParty> ancillaryPartys) {
            if (ancillaryPartys != null) {
                for (AncillaryParty ancillaryParty : ancillaryPartys) {
                    this.ancillaryParty.add(ancillaryParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="ancillaryParty")
        public TradableProductBuilder setAncillaryParty(List<? extends AncillaryParty> ancillaryPartys) {
            this.ancillaryParty = ancillaryPartys == null ? new ArrayList<AncillaryParty.AncillaryPartyBuilder>() : (List)ancillaryPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustment")
        @RuneAttribute(value="adjustment")
        public TradableProductBuilder setAdjustment(NotionalAdjustmentEnum _adjustment) {
            this.adjustment = _adjustment == null ? null : _adjustment;
            return this;
        }

        @Override
        public TradableProduct build() {
            return new TradableProductImpl(this);
        }

        @Override
        public TradableProductBuilder toBuilder() {
            return this;
        }

        @Override
        public TradableProductBuilder prune() {
            if (this.product != null && !this.product.prune().hasData()) {
                this.product = null;
            }
            this.tradeLot = this.tradeLot.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.counterparty = this.counterparty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.ancillaryParty = this.ancillaryParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getProduct() != null && this.getProduct().hasData()) {
                return true;
            }
            if (this.getTradeLot() != null && this.getTradeLot().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCounterparty() != null && this.getCounterparty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAncillaryParty() != null && this.getAncillaryParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAdjustment() != null;
        }

        public TradableProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradableProductBuilder o = (TradableProductBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProduct(), (RosettaModelObjectBuilder)o.getProduct(), this::setProduct);
            merger.mergeRosetta(this.getTradeLot(), o.getTradeLot(), this::getOrCreateTradeLot);
            merger.mergeRosetta(this.getCounterparty(), o.getCounterparty(), this::getOrCreateCounterparty);
            merger.mergeRosetta(this.getAncillaryParty(), o.getAncillaryParty(), this::getOrCreateAncillaryParty);
            merger.mergeBasic((Object)this.getAdjustment(), (Object)o.getAdjustment(), this::setAdjustment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradableProduct _that = this.getType().cast(o);
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeLot, _that.getTradeLot())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            return Objects.equals((Object)this.adjustment, (Object)_that.getAdjustment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.tradeLot != null ? this.tradeLot.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.adjustment != null ? ((Object)((Object)this.adjustment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradableProductBuilder {product=" + this.product + ", tradeLot=" + this.tradeLot + ", counterparty=" + this.counterparty + ", ancillaryParty=" + this.ancillaryParty + ", adjustment=" + (Object)((Object)this.adjustment) + '}';
        }
    }

    public static interface TradableProductBuilder
    extends TradableProduct,
    RosettaModelObjectBuilder {
        public NonTransferableProduct.NonTransferableProductBuilder getOrCreateProduct();

        @Override
        public NonTransferableProduct.NonTransferableProductBuilder getProduct();

        public TradeLot.TradeLotBuilder getOrCreateTradeLot(int var1);

        public List<? extends TradeLot.TradeLotBuilder> getTradeLot();

        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int var1);

        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty();

        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty(int var1);

        public List<? extends AncillaryParty.AncillaryPartyBuilder> getAncillaryParty();

        public TradableProductBuilder setProduct(NonTransferableProduct var1);

        public TradableProductBuilder addTradeLot(TradeLot var1);

        public TradableProductBuilder addTradeLot(TradeLot var1, int var2);

        public TradableProductBuilder addTradeLot(List<? extends TradeLot> var1);

        public TradableProductBuilder setTradeLot(List<? extends TradeLot> var1);

        public TradableProductBuilder addCounterparty(Counterparty var1);

        public TradableProductBuilder addCounterparty(Counterparty var1, int var2);

        public TradableProductBuilder addCounterparty(List<? extends Counterparty> var1);

        public TradableProductBuilder setCounterparty(List<? extends Counterparty> var1);

        public TradableProductBuilder addAncillaryParty(AncillaryParty var1);

        public TradableProductBuilder addAncillaryParty(AncillaryParty var1, int var2);

        public TradableProductBuilder addAncillaryParty(List<? extends AncillaryParty> var1);

        public TradableProductBuilder setAncillaryParty(List<? extends AncillaryParty> var1);

        public TradableProductBuilder setAdjustment(NotionalAdjustmentEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("product"), processor, NonTransferableProduct.NonTransferableProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeLot"), processor, TradeLot.TradeLotBuilder.class, this.getTradeLot(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.CounterpartyBuilder.class, this.getCounterparty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.AncillaryPartyBuilder.class, this.getAncillaryParty(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustment"), NotionalAdjustmentEnum.class, (Object)this.getAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TradableProductBuilder prune();
    }

    public static class TradableProductImpl
    implements TradableProduct {
        private final NonTransferableProduct product;
        private final List<? extends TradeLot> tradeLot;
        private final List<? extends Counterparty> counterparty;
        private final List<? extends AncillaryParty> ancillaryParty;
        private final NotionalAdjustmentEnum adjustment;

        protected TradableProductImpl(TradableProductBuilder builder) {
            this.product = Optional.ofNullable(builder.getProduct()).map(f -> f.build()).orElse(null);
            this.tradeLot = Optional.ofNullable(builder.getTradeLot()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.counterparty = Optional.ofNullable(builder.getCounterparty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.ancillaryParty = Optional.ofNullable(builder.getAncillaryParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.adjustment = builder.getAdjustment();
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public NonTransferableProduct getProduct() {
            return this.product;
        }

        @Override
        @RosettaAttribute(value="tradeLot", isRequired=true)
        @RuneAttribute(value="tradeLot", isRequired=true)
        public List<? extends TradeLot> getTradeLot() {
            return this.tradeLot;
        }

        @Override
        @RosettaAttribute(value="counterparty", isRequired=true)
        @RuneAttribute(value="counterparty", isRequired=true)
        public List<? extends Counterparty> getCounterparty() {
            return this.counterparty;
        }

        @Override
        @RosettaAttribute(value="ancillaryParty")
        @RuneAttribute(value="ancillaryParty")
        public List<? extends AncillaryParty> getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        @RosettaAttribute(value="adjustment")
        @RuneAttribute(value="adjustment")
        public NotionalAdjustmentEnum getAdjustment() {
            return this.adjustment;
        }

        @Override
        public TradableProduct build() {
            return this;
        }

        @Override
        public TradableProductBuilder toBuilder() {
            TradableProductBuilder builder = TradableProduct.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradableProductBuilder builder) {
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getTradeLot()).ifPresent(builder::setTradeLot);
            Optional.ofNullable(this.getCounterparty()).ifPresent(builder::setCounterparty);
            Optional.ofNullable(this.getAncillaryParty()).ifPresent(builder::setAncillaryParty);
            Optional.ofNullable(this.getAdjustment()).ifPresent(builder::setAdjustment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradableProduct _that = this.getType().cast(o);
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeLot, _that.getTradeLot())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            return Objects.equals((Object)this.adjustment, (Object)_that.getAdjustment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.tradeLot != null ? this.tradeLot.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.adjustment != null ? ((Object)((Object)this.adjustment)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradableProduct {product=" + this.product + ", tradeLot=" + this.tradeLot + ", counterparty=" + this.counterparty + ", ancillaryParty=" + this.ancillaryParty + ", adjustment=" + (Object)((Object)this.adjustment) + '}';
        }
    }
}

