/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.AssetDeliveryInformation;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.Underlier;
import cdm.product.template.meta.SettlementPayoutMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SettlementPayout", builder=SettlementPayoutBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="SettlementPayout", model="cdm", builder=SettlementPayoutBuilderImpl.class, version="7.0.0-dev.50")
public interface SettlementPayout
extends PayoutBase {
    public static final SettlementPayoutMeta metaData = new SettlementPayoutMeta();

    public Underlier getUnderlier();

    public String getDeliveryTerm();

    public AssetDeliveryInformation getDelivery();

    public CalculationSchedule getSchedule();

    @Override
    public SettlementPayout build();

    @Override
    public SettlementPayoutBuilder toBuilder();

    public static SettlementPayoutBuilder builder() {
        return new SettlementPayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends SettlementPayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SettlementPayout> getType() {
        return SettlementPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Underlier.class, this.getUnderlier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryTerm"), String.class, (Object)this.getDeliveryTerm(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("delivery"), processor, AssetDeliveryInformation.class, this.getDelivery(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.class, this.getSchedule(), new AttributeMeta[0]);
    }

    public static class SettlementPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements SettlementPayoutBuilder {
        protected Underlier.UnderlierBuilder underlier;
        protected String deliveryTerm;
        protected AssetDeliveryInformation.AssetDeliveryInformationBuilder delivery;
        protected CalculationSchedule.CalculationScheduleBuilder schedule;

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Underlier.UnderlierBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Underlier.UnderlierBuilder getOrCreateUnderlier() {
            Underlier.UnderlierBuilder result = this.underlier != null ? this.underlier : (this.underlier = Underlier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryTerm")
        @RuneAttribute(value="deliveryTerm")
        public String getDeliveryTerm() {
            return this.deliveryTerm;
        }

        @Override
        @RosettaAttribute(value="delivery")
        @RuneAttribute(value="delivery")
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getDelivery() {
            return this.delivery;
        }

        @Override
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getOrCreateDelivery() {
            AssetDeliveryInformation.AssetDeliveryInformationBuilder result = this.delivery != null ? this.delivery : (this.delivery = AssetDeliveryInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public CalculationSchedule.CalculationScheduleBuilder getSchedule() {
            return this.schedule;
        }

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule() {
            CalculationSchedule.CalculationScheduleBuilder result = this.schedule != null ? this.schedule : (this.schedule = CalculationSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public SettlementPayoutBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public SettlementPayoutBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public SettlementPayoutBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public SettlementPayoutBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public SettlementPayoutBuilder setUnderlier(Underlier _underlier) {
            this.underlier = _underlier == null ? null : _underlier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryTerm")
        @RuneAttribute(value="deliveryTerm")
        public SettlementPayoutBuilder setDeliveryTerm(String _deliveryTerm) {
            this.deliveryTerm = _deliveryTerm == null ? null : _deliveryTerm;
            return this;
        }

        @Override
        @RosettaAttribute(value="delivery")
        @RuneAttribute(value="delivery")
        public SettlementPayoutBuilder setDelivery(AssetDeliveryInformation _delivery) {
            this.delivery = _delivery == null ? null : _delivery.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public SettlementPayoutBuilder setSchedule(CalculationSchedule _schedule) {
            this.schedule = _schedule == null ? null : _schedule.toBuilder();
            return this;
        }

        @Override
        public SettlementPayout build() {
            return new SettlementPayoutImpl(this);
        }

        @Override
        public SettlementPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public SettlementPayoutBuilder prune() {
            super.prune();
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            if (this.delivery != null && !this.delivery.prune().hasData()) {
                this.delivery = null;
            }
            if (this.schedule != null && !this.schedule.prune().hasData()) {
                this.schedule = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getUnderlier() != null && this.getUnderlier().hasData()) {
                return true;
            }
            if (this.getDeliveryTerm() != null) {
                return true;
            }
            if (this.getDelivery() != null && this.getDelivery().hasData()) {
                return true;
            }
            return this.getSchedule() != null && this.getSchedule().hasData();
        }

        @Override
        public SettlementPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SettlementPayoutBuilder o = (SettlementPayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDelivery(), (RosettaModelObjectBuilder)o.getDelivery(), this::setDelivery);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSchedule(), (RosettaModelObjectBuilder)o.getSchedule(), this::setSchedule);
            merger.mergeBasic((Object)this.getDeliveryTerm(), (Object)o.getDeliveryTerm(), this::setDeliveryTerm, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SettlementPayout _that = (SettlementPayout)this.getType().cast(o);
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.deliveryTerm, _that.getDeliveryTerm())) {
                return false;
            }
            if (!Objects.equals(this.delivery, _that.getDelivery())) {
                return false;
            }
            return Objects.equals(this.schedule, _that.getSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.deliveryTerm != null ? this.deliveryTerm.hashCode() : 0);
            _result = 31 * _result + (this.delivery != null ? this.delivery.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SettlementPayoutBuilder {underlier=" + this.underlier + ", deliveryTerm=" + this.deliveryTerm + ", delivery=" + this.delivery + ", schedule=" + this.schedule + '}' + " " + super.toString();
        }
    }

    public static interface SettlementPayoutBuilder
    extends SettlementPayout,
    PayoutBase.PayoutBaseBuilder {
        public Underlier.UnderlierBuilder getOrCreateUnderlier();

        @Override
        public Underlier.UnderlierBuilder getUnderlier();

        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getOrCreateDelivery();

        @Override
        public AssetDeliveryInformation.AssetDeliveryInformationBuilder getDelivery();

        public CalculationSchedule.CalculationScheduleBuilder getOrCreateSchedule();

        @Override
        public CalculationSchedule.CalculationScheduleBuilder getSchedule();

        @Override
        public SettlementPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public SettlementPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public SettlementPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public SettlementPayoutBuilder setSettlementTerms(SettlementTerms var1);

        public SettlementPayoutBuilder setUnderlier(Underlier var1);

        public SettlementPayoutBuilder setDeliveryTerm(String var1);

        public SettlementPayoutBuilder setDelivery(AssetDeliveryInformation var1);

        public SettlementPayoutBuilder setSchedule(CalculationSchedule var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, (RosettaModelObjectBuilder)this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, (RosettaModelObjectBuilder)this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, (RosettaModelObjectBuilder)this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Underlier.UnderlierBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryTerm"), String.class, (Object)this.getDeliveryTerm(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("delivery"), processor, AssetDeliveryInformation.AssetDeliveryInformationBuilder.class, this.getDelivery(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, CalculationSchedule.CalculationScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
        }

        @Override
        public SettlementPayoutBuilder prune();
    }

    public static class SettlementPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements SettlementPayout {
        private final Underlier underlier;
        private final String deliveryTerm;
        private final AssetDeliveryInformation delivery;
        private final CalculationSchedule schedule;

        protected SettlementPayoutImpl(SettlementPayoutBuilder builder) {
            super(builder);
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
            this.deliveryTerm = builder.getDeliveryTerm();
            this.delivery = Optional.ofNullable(builder.getDelivery()).map(f -> f.build()).orElse(null);
            this.schedule = Optional.ofNullable(builder.getSchedule()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="underlier", isRequired=true)
        @RuneAttribute(value="underlier", isRequired=true)
        public Underlier getUnderlier() {
            return this.underlier;
        }

        @Override
        @RosettaAttribute(value="deliveryTerm")
        @RuneAttribute(value="deliveryTerm")
        public String getDeliveryTerm() {
            return this.deliveryTerm;
        }

        @Override
        @RosettaAttribute(value="delivery")
        @RuneAttribute(value="delivery")
        public AssetDeliveryInformation getDelivery() {
            return this.delivery;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public CalculationSchedule getSchedule() {
            return this.schedule;
        }

        @Override
        public SettlementPayout build() {
            return this;
        }

        @Override
        public SettlementPayoutBuilder toBuilder() {
            SettlementPayoutBuilder builder = SettlementPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SettlementPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
            Optional.ofNullable(this.getDeliveryTerm()).ifPresent(builder::setDeliveryTerm);
            Optional.ofNullable(this.getDelivery()).ifPresent(builder::setDelivery);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SettlementPayout _that = (SettlementPayout)this.getType().cast(o);
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!Objects.equals(this.deliveryTerm, _that.getDeliveryTerm())) {
                return false;
            }
            if (!Objects.equals(this.delivery, _that.getDelivery())) {
                return false;
            }
            return Objects.equals(this.schedule, _that.getSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.deliveryTerm != null ? this.deliveryTerm.hashCode() : 0);
            _result = 31 * _result + (this.delivery != null ? this.delivery.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SettlementPayout {underlier=" + this.underlier + ", deliveryTerm=" + this.deliveryTerm + ", delivery=" + this.delivery + ", schedule=" + this.schedule + '}' + " " + super.toString();
        }
    }
}

