/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDates;
import cdm.base.datetime.BusinessCenterTime;
import cdm.base.datetime.Period;
import cdm.base.staticdata.party.BuyerSeller;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.event.common.Transfer;
import cdm.product.common.schedule.FinalCalculationPeriodDateAdjustment;
import cdm.product.template.CallingPartyEnum;
import cdm.product.template.CancelableProvisionAdjustedDates;
import cdm.product.template.ExerciseNotice;
import cdm.product.template.ExerciseTerms;
import cdm.product.template.meta.CancelableProvisionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CancelableProvision", builder=CancelableProvisionBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="CancelableProvision", model="cdm", builder=CancelableProvisionBuilderImpl.class, version="7.0.0-dev.50")
public interface CancelableProvision
extends BuyerSeller {
    public static final CancelableProvisionMeta metaData = new CancelableProvisionMeta();

    public ExerciseNotice getExerciseNotice();

    public Boolean getFollowUpConfirmation();

    public CancelableProvisionAdjustedDates getCancelableProvisionAdjustedDates();

    public List<? extends FinalCalculationPeriodDateAdjustment> getFinalCalculationPeriodDateAdjustment();

    public Transfer getInitialFee();

    public CallingPartyEnum getCallingParty();

    public AdjustableOrRelativeDate getEarliestDate();

    public AdjustableOrRelativeDate getExpirationDate();

    public AdjustableOrRelativeDates getEffectiveDate();

    public Period getEffectivePeriod();

    public BusinessCenterTime getEarliestCancellationTime();

    public BusinessCenterTime getLatestCancelationTime();

    public ExerciseTerms getExerciseTerms();

    @Override
    public CancelableProvision build();

    @Override
    public CancelableProvisionBuilder toBuilder();

    public static CancelableProvisionBuilder builder() {
        return new CancelableProvisionBuilderImpl();
    }

    default public RosettaMetaData<? extends CancelableProvision> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CancelableProvision> getType() {
        return CancelableProvision.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("buyer"), CounterpartyRoleEnum.class, (Object)this.getBuyer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seller"), CounterpartyRoleEnum.class, (Object)this.getSeller(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseNotice"), processor, ExerciseNotice.class, this.getExerciseNotice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("followUpConfirmation"), Boolean.class, (Object)this.getFollowUpConfirmation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cancelableProvisionAdjustedDates"), processor, CancelableProvisionAdjustedDates.class, this.getCancelableProvisionAdjustedDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalCalculationPeriodDateAdjustment"), processor, FinalCalculationPeriodDateAdjustment.class, this.getFinalCalculationPeriodDateAdjustment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialFee"), processor, Transfer.class, this.getInitialFee(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callingParty"), CallingPartyEnum.class, (Object)this.getCallingParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earliestDate"), processor, AdjustableOrRelativeDate.class, this.getEarliestDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDates.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectivePeriod"), processor, Period.class, this.getEffectivePeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earliestCancellationTime"), processor, BusinessCenterTime.class, this.getEarliestCancellationTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("latestCancelationTime"), processor, BusinessCenterTime.class, this.getLatestCancelationTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseTerms"), processor, ExerciseTerms.class, this.getExerciseTerms(), new AttributeMeta[0]);
    }

    public static class CancelableProvisionBuilderImpl
    extends BuyerSeller.BuyerSellerBuilderImpl
    implements CancelableProvisionBuilder {
        protected ExerciseNotice.ExerciseNoticeBuilder exerciseNotice;
        protected Boolean followUpConfirmation;
        protected CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder cancelableProvisionAdjustedDates;
        protected List<FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder> finalCalculationPeriodDateAdjustment = new ArrayList<FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder>();
        protected Transfer.TransferBuilder initialFee;
        protected CallingPartyEnum callingParty;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder earliestDate;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder expirationDate;
        protected AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder effectiveDate;
        protected Period.PeriodBuilder effectivePeriod;
        protected BusinessCenterTime.BusinessCenterTimeBuilder earliestCancellationTime;
        protected BusinessCenterTime.BusinessCenterTimeBuilder latestCancelationTime;
        protected ExerciseTerms.ExerciseTermsBuilder exerciseTerms;

        @Override
        @RosettaAttribute(value="exerciseNotice")
        @RuneAttribute(value="exerciseNotice")
        public ExerciseNotice.ExerciseNoticeBuilder getExerciseNotice() {
            return this.exerciseNotice;
        }

        @Override
        public ExerciseNotice.ExerciseNoticeBuilder getOrCreateExerciseNotice() {
            ExerciseNotice.ExerciseNoticeBuilder result = this.exerciseNotice != null ? this.exerciseNotice : (this.exerciseNotice = ExerciseNotice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="followUpConfirmation", isRequired=true)
        @RuneAttribute(value="followUpConfirmation", isRequired=true)
        public Boolean getFollowUpConfirmation() {
            return this.followUpConfirmation;
        }

        @Override
        @RosettaAttribute(value="cancelableProvisionAdjustedDates")
        @RuneAttribute(value="cancelableProvisionAdjustedDates")
        public CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder getCancelableProvisionAdjustedDates() {
            return this.cancelableProvisionAdjustedDates;
        }

        @Override
        public CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder getOrCreateCancelableProvisionAdjustedDates() {
            CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder result = this.cancelableProvisionAdjustedDates != null ? this.cancelableProvisionAdjustedDates : (this.cancelableProvisionAdjustedDates = CancelableProvisionAdjustedDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="finalCalculationPeriodDateAdjustment")
        @RuneAttribute(value="finalCalculationPeriodDateAdjustment")
        public List<? extends FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder> getFinalCalculationPeriodDateAdjustment() {
            return this.finalCalculationPeriodDateAdjustment;
        }

        @Override
        public FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder getOrCreateFinalCalculationPeriodDateAdjustment(int index) {
            if (this.finalCalculationPeriodDateAdjustment == null) {
                this.finalCalculationPeriodDateAdjustment = new ArrayList<FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder>();
            }
            return (FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder)this.getIndex(this.finalCalculationPeriodDateAdjustment, index, () -> {
                FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder newFinalCalculationPeriodDateAdjustment = FinalCalculationPeriodDateAdjustment.builder();
                return newFinalCalculationPeriodDateAdjustment;
            });
        }

        @Override
        @RosettaAttribute(value="initialFee")
        @RuneAttribute(value="initialFee")
        public Transfer.TransferBuilder getInitialFee() {
            return this.initialFee;
        }

        @Override
        public Transfer.TransferBuilder getOrCreateInitialFee() {
            Transfer.TransferBuilder result = this.initialFee != null ? this.initialFee : (this.initialFee = Transfer.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="callingParty")
        @RuneAttribute(value="callingParty")
        public CallingPartyEnum getCallingParty() {
            return this.callingParty;
        }

        @Override
        @RosettaAttribute(value="earliestDate")
        @RuneAttribute(value="earliestDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEarliestDate() {
            return this.earliestDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEarliestDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.earliestDate != null ? this.earliestDate : (this.earliestDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.expirationDate != null ? this.expirationDate : (this.expirationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateEffectiveDate() {
            AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableOrRelativeDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectivePeriod")
        @RuneAttribute(value="effectivePeriod")
        public Period.PeriodBuilder getEffectivePeriod() {
            return this.effectivePeriod;
        }

        @Override
        public Period.PeriodBuilder getOrCreateEffectivePeriod() {
            Period.PeriodBuilder result = this.effectivePeriod != null ? this.effectivePeriod : (this.effectivePeriod = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="earliestCancellationTime")
        @RuneAttribute(value="earliestCancellationTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestCancellationTime() {
            return this.earliestCancellationTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestCancellationTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.earliestCancellationTime != null ? this.earliestCancellationTime : (this.earliestCancellationTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="latestCancelationTime")
        @RuneAttribute(value="latestCancelationTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getLatestCancelationTime() {
            return this.latestCancelationTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateLatestCancelationTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.latestCancelationTime != null ? this.latestCancelationTime : (this.latestCancelationTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseTerms", isRequired=true)
        @RuneAttribute(value="exerciseTerms", isRequired=true)
        public ExerciseTerms.ExerciseTermsBuilder getExerciseTerms() {
            return this.exerciseTerms;
        }

        @Override
        public ExerciseTerms.ExerciseTermsBuilder getOrCreateExerciseTerms() {
            ExerciseTerms.ExerciseTermsBuilder result = this.exerciseTerms != null ? this.exerciseTerms : (this.exerciseTerms = ExerciseTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="buyer", isRequired=true)
        @RuneAttribute(value="buyer", isRequired=true)
        public CancelableProvisionBuilder setBuyer(CounterpartyRoleEnum _buyer) {
            this.buyer = _buyer == null ? null : _buyer;
            return this;
        }

        @Override
        @RosettaAttribute(value="seller", isRequired=true)
        @RuneAttribute(value="seller", isRequired=true)
        public CancelableProvisionBuilder setSeller(CounterpartyRoleEnum _seller) {
            this.seller = _seller == null ? null : _seller;
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseNotice")
        @RuneAttribute(value="exerciseNotice")
        public CancelableProvisionBuilder setExerciseNotice(ExerciseNotice _exerciseNotice) {
            this.exerciseNotice = _exerciseNotice == null ? null : _exerciseNotice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="followUpConfirmation", isRequired=true)
        @RuneAttribute(value="followUpConfirmation", isRequired=true)
        public CancelableProvisionBuilder setFollowUpConfirmation(Boolean _followUpConfirmation) {
            this.followUpConfirmation = _followUpConfirmation == null ? null : _followUpConfirmation;
            return this;
        }

        @Override
        @RosettaAttribute(value="cancelableProvisionAdjustedDates")
        @RuneAttribute(value="cancelableProvisionAdjustedDates")
        public CancelableProvisionBuilder setCancelableProvisionAdjustedDates(CancelableProvisionAdjustedDates _cancelableProvisionAdjustedDates) {
            this.cancelableProvisionAdjustedDates = _cancelableProvisionAdjustedDates == null ? null : _cancelableProvisionAdjustedDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="finalCalculationPeriodDateAdjustment")
        @RuneAttribute(value="finalCalculationPeriodDateAdjustment")
        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(FinalCalculationPeriodDateAdjustment _finalCalculationPeriodDateAdjustment) {
            if (_finalCalculationPeriodDateAdjustment != null) {
                this.finalCalculationPeriodDateAdjustment.add(_finalCalculationPeriodDateAdjustment.toBuilder());
            }
            return this;
        }

        @Override
        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(FinalCalculationPeriodDateAdjustment _finalCalculationPeriodDateAdjustment, int idx) {
            this.getIndex(this.finalCalculationPeriodDateAdjustment, idx, () -> _finalCalculationPeriodDateAdjustment.toBuilder());
            return this;
        }

        @Override
        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(List<? extends FinalCalculationPeriodDateAdjustment> finalCalculationPeriodDateAdjustments) {
            if (finalCalculationPeriodDateAdjustments != null) {
                for (FinalCalculationPeriodDateAdjustment finalCalculationPeriodDateAdjustment : finalCalculationPeriodDateAdjustments) {
                    this.finalCalculationPeriodDateAdjustment.add(finalCalculationPeriodDateAdjustment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="finalCalculationPeriodDateAdjustment")
        public CancelableProvisionBuilder setFinalCalculationPeriodDateAdjustment(List<? extends FinalCalculationPeriodDateAdjustment> finalCalculationPeriodDateAdjustments) {
            this.finalCalculationPeriodDateAdjustment = finalCalculationPeriodDateAdjustments == null ? new ArrayList<FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder>() : (List)finalCalculationPeriodDateAdjustments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="initialFee")
        @RuneAttribute(value="initialFee")
        public CancelableProvisionBuilder setInitialFee(Transfer _initialFee) {
            this.initialFee = _initialFee == null ? null : _initialFee.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callingParty")
        @RuneAttribute(value="callingParty")
        public CancelableProvisionBuilder setCallingParty(CallingPartyEnum _callingParty) {
            this.callingParty = _callingParty == null ? null : _callingParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="earliestDate")
        @RuneAttribute(value="earliestDate")
        public CancelableProvisionBuilder setEarliestDate(AdjustableOrRelativeDate _earliestDate) {
            this.earliestDate = _earliestDate == null ? null : _earliestDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public CancelableProvisionBuilder setExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public CancelableProvisionBuilder setEffectiveDate(AdjustableOrRelativeDates _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectivePeriod")
        @RuneAttribute(value="effectivePeriod")
        public CancelableProvisionBuilder setEffectivePeriod(Period _effectivePeriod) {
            this.effectivePeriod = _effectivePeriod == null ? null : _effectivePeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="earliestCancellationTime")
        @RuneAttribute(value="earliestCancellationTime")
        public CancelableProvisionBuilder setEarliestCancellationTime(BusinessCenterTime _earliestCancellationTime) {
            this.earliestCancellationTime = _earliestCancellationTime == null ? null : _earliestCancellationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="latestCancelationTime")
        @RuneAttribute(value="latestCancelationTime")
        public CancelableProvisionBuilder setLatestCancelationTime(BusinessCenterTime _latestCancelationTime) {
            this.latestCancelationTime = _latestCancelationTime == null ? null : _latestCancelationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseTerms", isRequired=true)
        @RuneAttribute(value="exerciseTerms", isRequired=true)
        public CancelableProvisionBuilder setExerciseTerms(ExerciseTerms _exerciseTerms) {
            this.exerciseTerms = _exerciseTerms == null ? null : _exerciseTerms.toBuilder();
            return this;
        }

        @Override
        public CancelableProvision build() {
            return new CancelableProvisionImpl(this);
        }

        @Override
        public CancelableProvisionBuilder toBuilder() {
            return this;
        }

        @Override
        public CancelableProvisionBuilder prune() {
            super.prune();
            if (this.exerciseNotice != null && !this.exerciseNotice.prune().hasData()) {
                this.exerciseNotice = null;
            }
            if (this.cancelableProvisionAdjustedDates != null && !this.cancelableProvisionAdjustedDates.prune().hasData()) {
                this.cancelableProvisionAdjustedDates = null;
            }
            this.finalCalculationPeriodDateAdjustment = this.finalCalculationPeriodDateAdjustment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.initialFee != null && !this.initialFee.prune().hasData()) {
                this.initialFee = null;
            }
            if (this.earliestDate != null && !this.earliestDate.prune().hasData()) {
                this.earliestDate = null;
            }
            if (this.expirationDate != null && !this.expirationDate.prune().hasData()) {
                this.expirationDate = null;
            }
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.effectivePeriod != null && !this.effectivePeriod.prune().hasData()) {
                this.effectivePeriod = null;
            }
            if (this.earliestCancellationTime != null && !this.earliestCancellationTime.prune().hasData()) {
                this.earliestCancellationTime = null;
            }
            if (this.latestCancelationTime != null && !this.latestCancelationTime.prune().hasData()) {
                this.latestCancelationTime = null;
            }
            if (this.exerciseTerms != null && !this.exerciseTerms.prune().hasData()) {
                this.exerciseTerms = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExerciseNotice() != null && this.getExerciseNotice().hasData()) {
                return true;
            }
            if (this.getFollowUpConfirmation() != null) {
                return true;
            }
            if (this.getCancelableProvisionAdjustedDates() != null && this.getCancelableProvisionAdjustedDates().hasData()) {
                return true;
            }
            if (this.getFinalCalculationPeriodDateAdjustment() != null && this.getFinalCalculationPeriodDateAdjustment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getInitialFee() != null && this.getInitialFee().hasData()) {
                return true;
            }
            if (this.getCallingParty() != null) {
                return true;
            }
            if (this.getEarliestDate() != null && this.getEarliestDate().hasData()) {
                return true;
            }
            if (this.getExpirationDate() != null && this.getExpirationDate().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            if (this.getEffectivePeriod() != null && this.getEffectivePeriod().hasData()) {
                return true;
            }
            if (this.getEarliestCancellationTime() != null && this.getEarliestCancellationTime().hasData()) {
                return true;
            }
            if (this.getLatestCancelationTime() != null && this.getLatestCancelationTime().hasData()) {
                return true;
            }
            return this.getExerciseTerms() != null && this.getExerciseTerms().hasData();
        }

        @Override
        public CancelableProvisionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CancelableProvisionBuilder o = (CancelableProvisionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseNotice(), (RosettaModelObjectBuilder)o.getExerciseNotice(), this::setExerciseNotice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCancelableProvisionAdjustedDates(), (RosettaModelObjectBuilder)o.getCancelableProvisionAdjustedDates(), this::setCancelableProvisionAdjustedDates);
            merger.mergeRosetta(this.getFinalCalculationPeriodDateAdjustment(), o.getFinalCalculationPeriodDateAdjustment(), this::getOrCreateFinalCalculationPeriodDateAdjustment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInitialFee(), (RosettaModelObjectBuilder)o.getInitialFee(), this::setInitialFee);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarliestDate(), (RosettaModelObjectBuilder)o.getEarliestDate(), this::setEarliestDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirationDate(), (RosettaModelObjectBuilder)o.getExpirationDate(), this::setExpirationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectivePeriod(), (RosettaModelObjectBuilder)o.getEffectivePeriod(), this::setEffectivePeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarliestCancellationTime(), (RosettaModelObjectBuilder)o.getEarliestCancellationTime(), this::setEarliestCancellationTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLatestCancelationTime(), (RosettaModelObjectBuilder)o.getLatestCancelationTime(), this::setLatestCancelationTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseTerms(), (RosettaModelObjectBuilder)o.getExerciseTerms(), this::setExerciseTerms);
            merger.mergeBasic((Object)this.getFollowUpConfirmation(), (Object)o.getFollowUpConfirmation(), this::setFollowUpConfirmation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallingParty(), (Object)o.getCallingParty(), this::setCallingParty, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CancelableProvision _that = (CancelableProvision)this.getType().cast(o);
            if (!Objects.equals(this.exerciseNotice, _that.getExerciseNotice())) {
                return false;
            }
            if (!Objects.equals(this.followUpConfirmation, _that.getFollowUpConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.cancelableProvisionAdjustedDates, _that.getCancelableProvisionAdjustedDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.finalCalculationPeriodDateAdjustment, _that.getFinalCalculationPeriodDateAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.initialFee, _that.getInitialFee())) {
                return false;
            }
            if (!Objects.equals((Object)this.callingParty, (Object)_that.getCallingParty())) {
                return false;
            }
            if (!Objects.equals(this.earliestDate, _that.getEarliestDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.effectivePeriod, _that.getEffectivePeriod())) {
                return false;
            }
            if (!Objects.equals(this.earliestCancellationTime, _that.getEarliestCancellationTime())) {
                return false;
            }
            if (!Objects.equals(this.latestCancelationTime, _that.getLatestCancelationTime())) {
                return false;
            }
            return Objects.equals(this.exerciseTerms, _that.getExerciseTerms());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exerciseNotice != null ? this.exerciseNotice.hashCode() : 0);
            _result = 31 * _result + (this.followUpConfirmation != null ? this.followUpConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.cancelableProvisionAdjustedDates != null ? this.cancelableProvisionAdjustedDates.hashCode() : 0);
            _result = 31 * _result + (this.finalCalculationPeriodDateAdjustment != null ? this.finalCalculationPeriodDateAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.initialFee != null ? this.initialFee.hashCode() : 0);
            _result = 31 * _result + (this.callingParty != null ? ((Object)((Object)this.callingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.earliestDate != null ? this.earliestDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.effectivePeriod != null ? this.effectivePeriod.hashCode() : 0);
            _result = 31 * _result + (this.earliestCancellationTime != null ? this.earliestCancellationTime.hashCode() : 0);
            _result = 31 * _result + (this.latestCancelationTime != null ? this.latestCancelationTime.hashCode() : 0);
            _result = 31 * _result + (this.exerciseTerms != null ? this.exerciseTerms.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CancelableProvisionBuilder {exerciseNotice=" + this.exerciseNotice + ", followUpConfirmation=" + this.followUpConfirmation + ", cancelableProvisionAdjustedDates=" + this.cancelableProvisionAdjustedDates + ", finalCalculationPeriodDateAdjustment=" + this.finalCalculationPeriodDateAdjustment + ", initialFee=" + this.initialFee + ", callingParty=" + (Object)((Object)this.callingParty) + ", earliestDate=" + this.earliestDate + ", expirationDate=" + this.expirationDate + ", effectiveDate=" + this.effectiveDate + ", effectivePeriod=" + this.effectivePeriod + ", earliestCancellationTime=" + this.earliestCancellationTime + ", latestCancelationTime=" + this.latestCancelationTime + ", exerciseTerms=" + this.exerciseTerms + '}' + " " + super.toString();
        }
    }

    public static interface CancelableProvisionBuilder
    extends CancelableProvision,
    BuyerSeller.BuyerSellerBuilder {
        public ExerciseNotice.ExerciseNoticeBuilder getOrCreateExerciseNotice();

        @Override
        public ExerciseNotice.ExerciseNoticeBuilder getExerciseNotice();

        public CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder getOrCreateCancelableProvisionAdjustedDates();

        @Override
        public CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder getCancelableProvisionAdjustedDates();

        public FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder getOrCreateFinalCalculationPeriodDateAdjustment(int var1);

        public List<? extends FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder> getFinalCalculationPeriodDateAdjustment();

        public Transfer.TransferBuilder getOrCreateInitialFee();

        @Override
        public Transfer.TransferBuilder getInitialFee();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEarliestDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEarliestDate();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getExpirationDate();

        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateEffectiveDate();

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getEffectiveDate();

        public Period.PeriodBuilder getOrCreateEffectivePeriod();

        @Override
        public Period.PeriodBuilder getEffectivePeriod();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestCancellationTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestCancellationTime();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateLatestCancelationTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getLatestCancelationTime();

        public ExerciseTerms.ExerciseTermsBuilder getOrCreateExerciseTerms();

        @Override
        public ExerciseTerms.ExerciseTermsBuilder getExerciseTerms();

        @Override
        public CancelableProvisionBuilder setBuyer(CounterpartyRoleEnum var1);

        @Override
        public CancelableProvisionBuilder setSeller(CounterpartyRoleEnum var1);

        public CancelableProvisionBuilder setExerciseNotice(ExerciseNotice var1);

        public CancelableProvisionBuilder setFollowUpConfirmation(Boolean var1);

        public CancelableProvisionBuilder setCancelableProvisionAdjustedDates(CancelableProvisionAdjustedDates var1);

        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(FinalCalculationPeriodDateAdjustment var1);

        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(FinalCalculationPeriodDateAdjustment var1, int var2);

        public CancelableProvisionBuilder addFinalCalculationPeriodDateAdjustment(List<? extends FinalCalculationPeriodDateAdjustment> var1);

        public CancelableProvisionBuilder setFinalCalculationPeriodDateAdjustment(List<? extends FinalCalculationPeriodDateAdjustment> var1);

        public CancelableProvisionBuilder setInitialFee(Transfer var1);

        public CancelableProvisionBuilder setCallingParty(CallingPartyEnum var1);

        public CancelableProvisionBuilder setEarliestDate(AdjustableOrRelativeDate var1);

        public CancelableProvisionBuilder setExpirationDate(AdjustableOrRelativeDate var1);

        public CancelableProvisionBuilder setEffectiveDate(AdjustableOrRelativeDates var1);

        public CancelableProvisionBuilder setEffectivePeriod(Period var1);

        public CancelableProvisionBuilder setEarliestCancellationTime(BusinessCenterTime var1);

        public CancelableProvisionBuilder setLatestCancelationTime(BusinessCenterTime var1);

        public CancelableProvisionBuilder setExerciseTerms(ExerciseTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("buyer"), CounterpartyRoleEnum.class, (Object)this.getBuyer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seller"), CounterpartyRoleEnum.class, (Object)this.getSeller(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseNotice"), processor, ExerciseNotice.ExerciseNoticeBuilder.class, this.getExerciseNotice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("followUpConfirmation"), Boolean.class, (Object)this.getFollowUpConfirmation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cancelableProvisionAdjustedDates"), processor, CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDatesBuilder.class, this.getCancelableProvisionAdjustedDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalCalculationPeriodDateAdjustment"), processor, FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustmentBuilder.class, this.getFinalCalculationPeriodDateAdjustment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialFee"), processor, Transfer.TransferBuilder.class, this.getInitialFee(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callingParty"), CallingPartyEnum.class, (Object)this.getCallingParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earliestDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEarliestDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectivePeriod"), processor, Period.PeriodBuilder.class, this.getEffectivePeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earliestCancellationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getEarliestCancellationTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("latestCancelationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getLatestCancelationTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseTerms"), processor, ExerciseTerms.ExerciseTermsBuilder.class, this.getExerciseTerms(), new AttributeMeta[0]);
        }

        @Override
        public CancelableProvisionBuilder prune();
    }

    public static class CancelableProvisionImpl
    extends BuyerSeller.BuyerSellerImpl
    implements CancelableProvision {
        private final ExerciseNotice exerciseNotice;
        private final Boolean followUpConfirmation;
        private final CancelableProvisionAdjustedDates cancelableProvisionAdjustedDates;
        private final List<? extends FinalCalculationPeriodDateAdjustment> finalCalculationPeriodDateAdjustment;
        private final Transfer initialFee;
        private final CallingPartyEnum callingParty;
        private final AdjustableOrRelativeDate earliestDate;
        private final AdjustableOrRelativeDate expirationDate;
        private final AdjustableOrRelativeDates effectiveDate;
        private final Period effectivePeriod;
        private final BusinessCenterTime earliestCancellationTime;
        private final BusinessCenterTime latestCancelationTime;
        private final ExerciseTerms exerciseTerms;

        protected CancelableProvisionImpl(CancelableProvisionBuilder builder) {
            super(builder);
            this.exerciseNotice = Optional.ofNullable(builder.getExerciseNotice()).map(f -> f.build()).orElse(null);
            this.followUpConfirmation = builder.getFollowUpConfirmation();
            this.cancelableProvisionAdjustedDates = Optional.ofNullable(builder.getCancelableProvisionAdjustedDates()).map(f -> f.build()).orElse(null);
            this.finalCalculationPeriodDateAdjustment = Optional.ofNullable(builder.getFinalCalculationPeriodDateAdjustment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.initialFee = Optional.ofNullable(builder.getInitialFee()).map(f -> f.build()).orElse(null);
            this.callingParty = builder.getCallingParty();
            this.earliestDate = Optional.ofNullable(builder.getEarliestDate()).map(f -> f.build()).orElse(null);
            this.expirationDate = Optional.ofNullable(builder.getExpirationDate()).map(f -> f.build()).orElse(null);
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.effectivePeriod = Optional.ofNullable(builder.getEffectivePeriod()).map(f -> f.build()).orElse(null);
            this.earliestCancellationTime = Optional.ofNullable(builder.getEarliestCancellationTime()).map(f -> f.build()).orElse(null);
            this.latestCancelationTime = Optional.ofNullable(builder.getLatestCancelationTime()).map(f -> f.build()).orElse(null);
            this.exerciseTerms = Optional.ofNullable(builder.getExerciseTerms()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="exerciseNotice")
        @RuneAttribute(value="exerciseNotice")
        public ExerciseNotice getExerciseNotice() {
            return this.exerciseNotice;
        }

        @Override
        @RosettaAttribute(value="followUpConfirmation", isRequired=true)
        @RuneAttribute(value="followUpConfirmation", isRequired=true)
        public Boolean getFollowUpConfirmation() {
            return this.followUpConfirmation;
        }

        @Override
        @RosettaAttribute(value="cancelableProvisionAdjustedDates")
        @RuneAttribute(value="cancelableProvisionAdjustedDates")
        public CancelableProvisionAdjustedDates getCancelableProvisionAdjustedDates() {
            return this.cancelableProvisionAdjustedDates;
        }

        @Override
        @RosettaAttribute(value="finalCalculationPeriodDateAdjustment")
        @RuneAttribute(value="finalCalculationPeriodDateAdjustment")
        public List<? extends FinalCalculationPeriodDateAdjustment> getFinalCalculationPeriodDateAdjustment() {
            return this.finalCalculationPeriodDateAdjustment;
        }

        @Override
        @RosettaAttribute(value="initialFee")
        @RuneAttribute(value="initialFee")
        public Transfer getInitialFee() {
            return this.initialFee;
        }

        @Override
        @RosettaAttribute(value="callingParty")
        @RuneAttribute(value="callingParty")
        public CallingPartyEnum getCallingParty() {
            return this.callingParty;
        }

        @Override
        @RosettaAttribute(value="earliestDate")
        @RuneAttribute(value="earliestDate")
        public AdjustableOrRelativeDate getEarliestDate() {
            return this.earliestDate;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public AdjustableOrRelativeDate getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDates getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="effectivePeriod")
        @RuneAttribute(value="effectivePeriod")
        public Period getEffectivePeriod() {
            return this.effectivePeriod;
        }

        @Override
        @RosettaAttribute(value="earliestCancellationTime")
        @RuneAttribute(value="earliestCancellationTime")
        public BusinessCenterTime getEarliestCancellationTime() {
            return this.earliestCancellationTime;
        }

        @Override
        @RosettaAttribute(value="latestCancelationTime")
        @RuneAttribute(value="latestCancelationTime")
        public BusinessCenterTime getLatestCancelationTime() {
            return this.latestCancelationTime;
        }

        @Override
        @RosettaAttribute(value="exerciseTerms", isRequired=true)
        @RuneAttribute(value="exerciseTerms", isRequired=true)
        public ExerciseTerms getExerciseTerms() {
            return this.exerciseTerms;
        }

        @Override
        public CancelableProvision build() {
            return this;
        }

        @Override
        public CancelableProvisionBuilder toBuilder() {
            CancelableProvisionBuilder builder = CancelableProvision.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CancelableProvisionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExerciseNotice()).ifPresent(builder::setExerciseNotice);
            Optional.ofNullable(this.getFollowUpConfirmation()).ifPresent(builder::setFollowUpConfirmation);
            Optional.ofNullable(this.getCancelableProvisionAdjustedDates()).ifPresent(builder::setCancelableProvisionAdjustedDates);
            Optional.ofNullable(this.getFinalCalculationPeriodDateAdjustment()).ifPresent(builder::setFinalCalculationPeriodDateAdjustment);
            Optional.ofNullable(this.getInitialFee()).ifPresent(builder::setInitialFee);
            Optional.ofNullable(this.getCallingParty()).ifPresent(builder::setCallingParty);
            Optional.ofNullable(this.getEarliestDate()).ifPresent(builder::setEarliestDate);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getEffectivePeriod()).ifPresent(builder::setEffectivePeriod);
            Optional.ofNullable(this.getEarliestCancellationTime()).ifPresent(builder::setEarliestCancellationTime);
            Optional.ofNullable(this.getLatestCancelationTime()).ifPresent(builder::setLatestCancelationTime);
            Optional.ofNullable(this.getExerciseTerms()).ifPresent(builder::setExerciseTerms);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CancelableProvision _that = (CancelableProvision)this.getType().cast(o);
            if (!Objects.equals(this.exerciseNotice, _that.getExerciseNotice())) {
                return false;
            }
            if (!Objects.equals(this.followUpConfirmation, _that.getFollowUpConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.cancelableProvisionAdjustedDates, _that.getCancelableProvisionAdjustedDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.finalCalculationPeriodDateAdjustment, _that.getFinalCalculationPeriodDateAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.initialFee, _that.getInitialFee())) {
                return false;
            }
            if (!Objects.equals((Object)this.callingParty, (Object)_that.getCallingParty())) {
                return false;
            }
            if (!Objects.equals(this.earliestDate, _that.getEarliestDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.effectivePeriod, _that.getEffectivePeriod())) {
                return false;
            }
            if (!Objects.equals(this.earliestCancellationTime, _that.getEarliestCancellationTime())) {
                return false;
            }
            if (!Objects.equals(this.latestCancelationTime, _that.getLatestCancelationTime())) {
                return false;
            }
            return Objects.equals(this.exerciseTerms, _that.getExerciseTerms());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.exerciseNotice != null ? this.exerciseNotice.hashCode() : 0);
            _result = 31 * _result + (this.followUpConfirmation != null ? this.followUpConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.cancelableProvisionAdjustedDates != null ? this.cancelableProvisionAdjustedDates.hashCode() : 0);
            _result = 31 * _result + (this.finalCalculationPeriodDateAdjustment != null ? this.finalCalculationPeriodDateAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.initialFee != null ? this.initialFee.hashCode() : 0);
            _result = 31 * _result + (this.callingParty != null ? ((Object)((Object)this.callingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.earliestDate != null ? this.earliestDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.effectivePeriod != null ? this.effectivePeriod.hashCode() : 0);
            _result = 31 * _result + (this.earliestCancellationTime != null ? this.earliestCancellationTime.hashCode() : 0);
            _result = 31 * _result + (this.latestCancelationTime != null ? this.latestCancelationTime.hashCode() : 0);
            _result = 31 * _result + (this.exerciseTerms != null ? this.exerciseTerms.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CancelableProvision {exerciseNotice=" + this.exerciseNotice + ", followUpConfirmation=" + this.followUpConfirmation + ", cancelableProvisionAdjustedDates=" + this.cancelableProvisionAdjustedDates + ", finalCalculationPeriodDateAdjustment=" + this.finalCalculationPeriodDateAdjustment + ", initialFee=" + this.initialFee + ", callingParty=" + (Object)((Object)this.callingParty) + ", earliestDate=" + this.earliestDate + ", expirationDate=" + this.expirationDate + ", effectiveDate=" + this.effectiveDate + ", effectivePeriod=" + this.effectivePeriod + ", earliestCancellationTime=" + this.earliestCancellationTime + ", latestCancelationTime=" + this.latestCancelationTime + ", exerciseTerms=" + this.exerciseTerms + '}' + " " + super.toString();
        }
    }
}

