/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.Offset;
import cdm.product.asset.RollSourceCalendarEnum;
import cdm.product.common.settlement.meta.RollFeatureMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RollFeature", builder=RollFeatureBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="RollFeature", model="cdm", builder=RollFeatureBuilderImpl.class, version="7.0.0-dev.50")
public interface RollFeature
extends RosettaModelObject {
    public static final RollFeatureMeta metaData = new RollFeatureMeta();

    public RollSourceCalendarEnum getRollSourceCalendar();

    public Offset getDeliveryDateRollConvention();

    public RollFeature build();

    public RollFeatureBuilder toBuilder();

    public static RollFeatureBuilder builder() {
        return new RollFeatureBuilderImpl();
    }

    default public RosettaMetaData<? extends RollFeature> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RollFeature> getType() {
        return RollFeature.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("rollSourceCalendar"), RollSourceCalendarEnum.class, (Object)this.getRollSourceCalendar(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryDateRollConvention"), processor, Offset.class, this.getDeliveryDateRollConvention(), new AttributeMeta[0]);
    }

    public static class RollFeatureBuilderImpl
    implements RollFeatureBuilder {
        protected RollSourceCalendarEnum rollSourceCalendar;
        protected Offset.OffsetBuilder deliveryDateRollConvention;

        @Override
        @RosettaAttribute(value="rollSourceCalendar")
        @RuneAttribute(value="rollSourceCalendar")
        public RollSourceCalendarEnum getRollSourceCalendar() {
            return this.rollSourceCalendar;
        }

        @Override
        @RosettaAttribute(value="deliveryDateRollConvention")
        @RuneAttribute(value="deliveryDateRollConvention")
        public Offset.OffsetBuilder getDeliveryDateRollConvention() {
            return this.deliveryDateRollConvention;
        }

        @Override
        public Offset.OffsetBuilder getOrCreateDeliveryDateRollConvention() {
            Offset.OffsetBuilder result = this.deliveryDateRollConvention != null ? this.deliveryDateRollConvention : (this.deliveryDateRollConvention = Offset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rollSourceCalendar")
        @RuneAttribute(value="rollSourceCalendar")
        public RollFeatureBuilder setRollSourceCalendar(RollSourceCalendarEnum _rollSourceCalendar) {
            this.rollSourceCalendar = _rollSourceCalendar == null ? null : _rollSourceCalendar;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryDateRollConvention")
        @RuneAttribute(value="deliveryDateRollConvention")
        public RollFeatureBuilder setDeliveryDateRollConvention(Offset _deliveryDateRollConvention) {
            this.deliveryDateRollConvention = _deliveryDateRollConvention == null ? null : _deliveryDateRollConvention.toBuilder();
            return this;
        }

        @Override
        public RollFeature build() {
            return new RollFeatureImpl(this);
        }

        @Override
        public RollFeatureBuilder toBuilder() {
            return this;
        }

        @Override
        public RollFeatureBuilder prune() {
            if (this.deliveryDateRollConvention != null && !this.deliveryDateRollConvention.prune().hasData()) {
                this.deliveryDateRollConvention = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getRollSourceCalendar() != null) {
                return true;
            }
            return this.getDeliveryDateRollConvention() != null && this.getDeliveryDateRollConvention().hasData();
        }

        public RollFeatureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RollFeatureBuilder o = (RollFeatureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryDateRollConvention(), (RosettaModelObjectBuilder)o.getDeliveryDateRollConvention(), this::setDeliveryDateRollConvention);
            merger.mergeBasic((Object)this.getRollSourceCalendar(), (Object)o.getRollSourceCalendar(), this::setRollSourceCalendar, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RollFeature _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.rollSourceCalendar, (Object)_that.getRollSourceCalendar())) {
                return false;
            }
            return Objects.equals(this.deliveryDateRollConvention, _that.getDeliveryDateRollConvention());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rollSourceCalendar != null ? ((Object)((Object)this.rollSourceCalendar)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateRollConvention != null ? this.deliveryDateRollConvention.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RollFeatureBuilder {rollSourceCalendar=" + (Object)((Object)this.rollSourceCalendar) + ", deliveryDateRollConvention=" + this.deliveryDateRollConvention + '}';
        }
    }

    public static interface RollFeatureBuilder
    extends RollFeature,
    RosettaModelObjectBuilder {
        public Offset.OffsetBuilder getOrCreateDeliveryDateRollConvention();

        @Override
        public Offset.OffsetBuilder getDeliveryDateRollConvention();

        public RollFeatureBuilder setRollSourceCalendar(RollSourceCalendarEnum var1);

        public RollFeatureBuilder setDeliveryDateRollConvention(Offset var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("rollSourceCalendar"), RollSourceCalendarEnum.class, (Object)this.getRollSourceCalendar(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryDateRollConvention"), processor, Offset.OffsetBuilder.class, this.getDeliveryDateRollConvention(), new AttributeMeta[0]);
        }

        public RollFeatureBuilder prune();
    }

    public static class RollFeatureImpl
    implements RollFeature {
        private final RollSourceCalendarEnum rollSourceCalendar;
        private final Offset deliveryDateRollConvention;

        protected RollFeatureImpl(RollFeatureBuilder builder) {
            this.rollSourceCalendar = builder.getRollSourceCalendar();
            this.deliveryDateRollConvention = Optional.ofNullable(builder.getDeliveryDateRollConvention()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="rollSourceCalendar")
        @RuneAttribute(value="rollSourceCalendar")
        public RollSourceCalendarEnum getRollSourceCalendar() {
            return this.rollSourceCalendar;
        }

        @Override
        @RosettaAttribute(value="deliveryDateRollConvention")
        @RuneAttribute(value="deliveryDateRollConvention")
        public Offset getDeliveryDateRollConvention() {
            return this.deliveryDateRollConvention;
        }

        @Override
        public RollFeature build() {
            return this;
        }

        @Override
        public RollFeatureBuilder toBuilder() {
            RollFeatureBuilder builder = RollFeature.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RollFeatureBuilder builder) {
            Optional.ofNullable(this.getRollSourceCalendar()).ifPresent(builder::setRollSourceCalendar);
            Optional.ofNullable(this.getDeliveryDateRollConvention()).ifPresent(builder::setDeliveryDateRollConvention);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RollFeature _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.rollSourceCalendar, (Object)_that.getRollSourceCalendar())) {
                return false;
            }
            return Objects.equals(this.deliveryDateRollConvention, _that.getDeliveryDateRollConvention());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.rollSourceCalendar != null ? ((Object)((Object)this.rollSourceCalendar)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryDateRollConvention != null ? this.deliveryDateRollConvention.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RollFeature {rollSourceCalendar=" + (Object)((Object)this.rollSourceCalendar) + ", deliveryDateRollConvention=" + this.deliveryDateRollConvention + '}';
        }
    }
}

