/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.math.Quantity;
import cdm.base.staticdata.asset.commodity.ProductGradeEnum;
import cdm.base.staticdata.identifier.LocationIdentifier;
import cdm.product.asset.AssetDeliveryPeriods;
import cdm.product.asset.meta.AssetDeliveryInformationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetDeliveryInformation", builder=AssetDeliveryInformationBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="AssetDeliveryInformation", model="cdm", builder=AssetDeliveryInformationBuilderImpl.class, version="7.0.0-dev.50")
public interface AssetDeliveryInformation
extends RosettaModelObject {
    public static final AssetDeliveryInformationMeta metaData = new AssetDeliveryInformationMeta();

    public AssetDeliveryPeriods getPeriods();

    public List<? extends LocationIdentifier> getLocation();

    public Quantity getDeliveryCapacity();

    public List<ProductGradeEnum> getCommodityGrade();

    public AssetDeliveryInformation build();

    public AssetDeliveryInformationBuilder toBuilder();

    public static AssetDeliveryInformationBuilder builder() {
        return new AssetDeliveryInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetDeliveryInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetDeliveryInformation> getType() {
        return AssetDeliveryInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periods"), processor, AssetDeliveryPeriods.class, this.getPeriods(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("location"), processor, LocationIdentifier.class, this.getLocation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryCapacity"), processor, Quantity.class, this.getDeliveryCapacity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("commodityGrade"), ProductGradeEnum.class, this.getCommodityGrade(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AssetDeliveryInformationBuilderImpl
    implements AssetDeliveryInformationBuilder {
        protected AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder periods;
        protected List<LocationIdentifier.LocationIdentifierBuilder> location = new ArrayList<LocationIdentifier.LocationIdentifierBuilder>();
        protected Quantity.QuantityBuilder deliveryCapacity;
        protected List<ProductGradeEnum> commodityGrade = new ArrayList<ProductGradeEnum>();

        @Override
        @RosettaAttribute(value="periods")
        @RuneAttribute(value="periods")
        public AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder getPeriods() {
            return this.periods;
        }

        @Override
        public AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder getOrCreatePeriods() {
            AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder result = this.periods != null ? this.periods : (this.periods = AssetDeliveryPeriods.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public List<? extends LocationIdentifier.LocationIdentifierBuilder> getLocation() {
            return this.location;
        }

        @Override
        public LocationIdentifier.LocationIdentifierBuilder getOrCreateLocation(int index) {
            if (this.location == null) {
                this.location = new ArrayList<LocationIdentifier.LocationIdentifierBuilder>();
            }
            return (LocationIdentifier.LocationIdentifierBuilder)this.getIndex(this.location, index, () -> {
                LocationIdentifier.LocationIdentifierBuilder newLocation = LocationIdentifier.builder();
                return newLocation;
            });
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        @RuneAttribute(value="deliveryCapacity")
        public Quantity.QuantityBuilder getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        public Quantity.QuantityBuilder getOrCreateDeliveryCapacity() {
            Quantity.QuantityBuilder result = this.deliveryCapacity != null ? this.deliveryCapacity : (this.deliveryCapacity = Quantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodityGrade")
        @RuneAttribute(value="commodityGrade")
        public List<ProductGradeEnum> getCommodityGrade() {
            return this.commodityGrade;
        }

        @Override
        @RosettaAttribute(value="periods")
        @RuneAttribute(value="periods")
        public AssetDeliveryInformationBuilder setPeriods(AssetDeliveryPeriods _periods) {
            this.periods = _periods == null ? null : _periods.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public AssetDeliveryInformationBuilder addLocation(LocationIdentifier _location) {
            if (_location != null) {
                this.location.add(_location.toBuilder());
            }
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder addLocation(LocationIdentifier _location, int idx) {
            this.getIndex(this.location, idx, () -> _location.toBuilder());
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder addLocation(List<? extends LocationIdentifier> locations) {
            if (locations != null) {
                for (LocationIdentifier locationIdentifier : locations) {
                    this.location.add(locationIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="location")
        public AssetDeliveryInformationBuilder setLocation(List<? extends LocationIdentifier> locations) {
            this.location = locations == null ? new ArrayList<LocationIdentifier.LocationIdentifierBuilder>() : (List)locations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        @RuneAttribute(value="deliveryCapacity")
        public AssetDeliveryInformationBuilder setDeliveryCapacity(Quantity _deliveryCapacity) {
            this.deliveryCapacity = _deliveryCapacity == null ? null : _deliveryCapacity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityGrade")
        @RuneAttribute(value="commodityGrade")
        public AssetDeliveryInformationBuilder addCommodityGrade(ProductGradeEnum _commodityGrade) {
            if (_commodityGrade != null) {
                this.commodityGrade.add(_commodityGrade);
            }
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder addCommodityGrade(ProductGradeEnum _commodityGrade, int idx) {
            this.getIndex(this.commodityGrade, idx, () -> _commodityGrade);
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder addCommodityGrade(List<ProductGradeEnum> commodityGrades) {
            if (commodityGrades != null) {
                for (ProductGradeEnum toAdd : commodityGrades) {
                    this.commodityGrade.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityGrade")
        public AssetDeliveryInformationBuilder setCommodityGrade(List<ProductGradeEnum> commodityGrades) {
            this.commodityGrade = commodityGrades == null ? new ArrayList<ProductGradeEnum>() : (List)commodityGrades.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetDeliveryInformation build() {
            return new AssetDeliveryInformationImpl(this);
        }

        @Override
        public AssetDeliveryInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder prune() {
            if (this.periods != null && !this.periods.prune().hasData()) {
                this.periods = null;
            }
            this.location = this.location.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.deliveryCapacity != null && !this.deliveryCapacity.prune().hasData()) {
                this.deliveryCapacity = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPeriods() != null && this.getPeriods().hasData()) {
                return true;
            }
            if (this.getLocation() != null && this.getLocation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDeliveryCapacity() != null && this.getDeliveryCapacity().hasData()) {
                return true;
            }
            return this.getCommodityGrade() != null && !this.getCommodityGrade().isEmpty();
        }

        public AssetDeliveryInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetDeliveryInformationBuilder o = (AssetDeliveryInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriods(), (RosettaModelObjectBuilder)o.getPeriods(), this::setPeriods);
            merger.mergeRosetta(this.getLocation(), o.getLocation(), this::getOrCreateLocation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryCapacity(), (RosettaModelObjectBuilder)o.getDeliveryCapacity(), this::setDeliveryCapacity);
            merger.mergeBasic(this.getCommodityGrade(), o.getCommodityGrade(), this::addCommodityGrade);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.periods, _that.getPeriods())) {
                return false;
            }
            if (!ListEquals.listEquals(this.location, _that.getLocation())) {
                return false;
            }
            if (!Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity())) {
                return false;
            }
            return ListEquals.listEquals(this.commodityGrade, _that.getCommodityGrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periods != null ? this.periods.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            _result = 31 * _result + (this.commodityGrade != null ? this.commodityGrade.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryInformationBuilder {periods=" + this.periods + ", location=" + this.location + ", deliveryCapacity=" + this.deliveryCapacity + ", commodityGrade=" + this.commodityGrade + '}';
        }
    }

    public static interface AssetDeliveryInformationBuilder
    extends AssetDeliveryInformation,
    RosettaModelObjectBuilder {
        public AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder getOrCreatePeriods();

        @Override
        public AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder getPeriods();

        public LocationIdentifier.LocationIdentifierBuilder getOrCreateLocation(int var1);

        public List<? extends LocationIdentifier.LocationIdentifierBuilder> getLocation();

        public Quantity.QuantityBuilder getOrCreateDeliveryCapacity();

        @Override
        public Quantity.QuantityBuilder getDeliveryCapacity();

        public AssetDeliveryInformationBuilder setPeriods(AssetDeliveryPeriods var1);

        public AssetDeliveryInformationBuilder addLocation(LocationIdentifier var1);

        public AssetDeliveryInformationBuilder addLocation(LocationIdentifier var1, int var2);

        public AssetDeliveryInformationBuilder addLocation(List<? extends LocationIdentifier> var1);

        public AssetDeliveryInformationBuilder setLocation(List<? extends LocationIdentifier> var1);

        public AssetDeliveryInformationBuilder setDeliveryCapacity(Quantity var1);

        public AssetDeliveryInformationBuilder addCommodityGrade(ProductGradeEnum var1);

        public AssetDeliveryInformationBuilder addCommodityGrade(ProductGradeEnum var1, int var2);

        public AssetDeliveryInformationBuilder addCommodityGrade(List<ProductGradeEnum> var1);

        public AssetDeliveryInformationBuilder setCommodityGrade(List<ProductGradeEnum> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periods"), processor, AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder.class, this.getPeriods(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("location"), processor, LocationIdentifier.LocationIdentifierBuilder.class, this.getLocation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryCapacity"), processor, Quantity.QuantityBuilder.class, this.getDeliveryCapacity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("commodityGrade"), ProductGradeEnum.class, this.getCommodityGrade(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AssetDeliveryInformationBuilder prune();
    }

    public static class AssetDeliveryInformationImpl
    implements AssetDeliveryInformation {
        private final AssetDeliveryPeriods periods;
        private final List<? extends LocationIdentifier> location;
        private final Quantity deliveryCapacity;
        private final List<ProductGradeEnum> commodityGrade;

        protected AssetDeliveryInformationImpl(AssetDeliveryInformationBuilder builder) {
            this.periods = Optional.ofNullable(builder.getPeriods()).map(f -> f.build()).orElse(null);
            this.location = Optional.ofNullable(builder.getLocation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.deliveryCapacity = Optional.ofNullable(builder.getDeliveryCapacity()).map(f -> f.build()).orElse(null);
            this.commodityGrade = Optional.ofNullable(builder.getCommodityGrade()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periods")
        @RuneAttribute(value="periods")
        public AssetDeliveryPeriods getPeriods() {
            return this.periods;
        }

        @Override
        @RosettaAttribute(value="location")
        @RuneAttribute(value="location")
        public List<? extends LocationIdentifier> getLocation() {
            return this.location;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        @RuneAttribute(value="deliveryCapacity")
        public Quantity getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        @RosettaAttribute(value="commodityGrade")
        @RuneAttribute(value="commodityGrade")
        public List<ProductGradeEnum> getCommodityGrade() {
            return this.commodityGrade;
        }

        @Override
        public AssetDeliveryInformation build() {
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder toBuilder() {
            AssetDeliveryInformationBuilder builder = AssetDeliveryInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetDeliveryInformationBuilder builder) {
            Optional.ofNullable(this.getPeriods()).ifPresent(builder::setPeriods);
            Optional.ofNullable(this.getLocation()).ifPresent(builder::setLocation);
            Optional.ofNullable(this.getDeliveryCapacity()).ifPresent(builder::setDeliveryCapacity);
            Optional.ofNullable(this.getCommodityGrade()).ifPresent(builder::setCommodityGrade);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.periods, _that.getPeriods())) {
                return false;
            }
            if (!ListEquals.listEquals(this.location, _that.getLocation())) {
                return false;
            }
            if (!Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity())) {
                return false;
            }
            return ListEquals.listEquals(this.commodityGrade, _that.getCommodityGrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periods != null ? this.periods.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            _result = 31 * _result + (this.commodityGrade != null ? this.commodityGrade.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryInformation {periods=" + this.periods + ", location=" + this.location + ", deliveryCapacity=" + this.deliveryCapacity + ", commodityGrade=" + this.commodityGrade + '}';
        }
    }
}

