/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.functions.VectorOperation;
import cdm.observable.asset.calculatedrate.CalculatedRateDetails;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ApplyAveragingFormulaDefault.class)
public abstract class ApplyAveragingFormula
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected VectorOperation vectorOperation;

    public CalculatedRateDetails evaluate(List<BigDecimal> observations, List<BigDecimal> weights) {
        CalculatedRateDetails results;
        CalculatedRateDetails.CalculatedRateDetailsBuilder resultsBuilder = this.doEvaluate(observations, weights);
        if (resultsBuilder == null) {
            results = null;
        } else {
            results = resultsBuilder.build();
            this.objectValidator.validate(CalculatedRateDetails.class, (RosettaModelObject)results);
        }
        return results;
    }

    protected abstract CalculatedRateDetails.CalculatedRateDetailsBuilder doEvaluate(List<BigDecimal> var1, List<BigDecimal> var2);

    protected abstract MapperC<BigDecimal> weightedObservations(List<BigDecimal> var1, List<BigDecimal> var2);

    protected abstract MapperS<BigDecimal> totalWeightedObservations(List<BigDecimal> var1, List<BigDecimal> var2);

    protected abstract MapperS<BigDecimal> totalWeight(List<BigDecimal> var1, List<BigDecimal> var2);

    protected abstract MapperS<BigDecimal> calculatedRate(List<BigDecimal> var1, List<BigDecimal> var2);

    public static class ApplyAveragingFormulaDefault
    extends ApplyAveragingFormula {
        @Override
        protected CalculatedRateDetails.CalculatedRateDetailsBuilder doEvaluate(List<BigDecimal> observations, List<BigDecimal> weights) {
            if (observations == null) {
                observations = Collections.emptyList();
            }
            if (weights == null) {
                weights = Collections.emptyList();
            }
            CalculatedRateDetails.CalculatedRateDetailsBuilder results = CalculatedRateDetails.builder();
            return this.assignOutput(results, observations, weights);
        }

        protected CalculatedRateDetails.CalculatedRateDetailsBuilder assignOutput(CalculatedRateDetails.CalculatedRateDetailsBuilder results, List<BigDecimal> observations, List<BigDecimal> weights) {
            results.setAggregateValue((BigDecimal)this.totalWeightedObservations(observations, weights).get());
            results.setAggregateWeight((BigDecimal)this.totalWeight(observations, weights).get());
            results.setCalculatedRate((BigDecimal)this.calculatedRate(observations, weights).get());
            results.addWeightedRates(this.weightedObservations(observations, weights).getMulti());
            return Optional.ofNullable(results).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<BigDecimal> weightedObservations(List<BigDecimal> observations, List<BigDecimal> weights) {
            return MapperC.of(this.vectorOperation.evaluate(ArithmeticOperationEnum.MULTIPLY, observations, weights));
        }

        @Override
        protected MapperS<BigDecimal> totalWeightedObservations(List<BigDecimal> observations, List<BigDecimal> weights) {
            return this.weightedObservations(observations, weights).sumBigDecimal();
        }

        @Override
        protected MapperS<BigDecimal> totalWeight(List<BigDecimal> observations, List<BigDecimal> weights) {
            return MapperC.of(weights).sumBigDecimal();
        }

        @Override
        protected MapperS<BigDecimal> calculatedRate(List<BigDecimal> observations, List<BigDecimal> weights) {
            return MapperMaths.divide(this.totalWeightedObservations(observations, weights), this.totalWeight(observations, weights));
        }
    }
}

