/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.validation.datarule;

import cdm.margin.schedule.StandardizedSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="StandardizedSchedulePositiveNotional")
@ImplementedBy(value=Default.class)
public interface StandardizedSchedulePositiveNotional
extends Validator<StandardizedSchedule> {
    public static final String NAME = "StandardizedSchedulePositiveNotional";
    public static final String DEFINITION = "notional > 0";

    public static class NoOp
    implements StandardizedSchedulePositiveNotional {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StandardizedSchedule standardizedSchedule) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements StandardizedSchedulePositiveNotional {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StandardizedSchedule standardizedSchedule) {
            ComparisonResult result = this.executeDataRule(standardizedSchedule);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)StandardizedSchedulePositiveNotional.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StandardizedSchedule", (RosettaPath)path, (String)StandardizedSchedulePositiveNotional.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)StandardizedSchedulePositiveNotional.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StandardizedSchedule", (RosettaPath)path, (String)StandardizedSchedulePositiveNotional.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(StandardizedSchedule standardizedSchedule) {
            try {
                return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)standardizedSchedule).map("getNotional", _standardizedSchedule -> _standardizedSchedule.getNotional()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

