/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.master.isda;

import cdm.legaldocumentation.common.AddressForNotices;
import cdm.legaldocumentation.csa.CreditSupportDocument;
import cdm.legaldocumentation.csa.CreditSupportProvider;
import cdm.legaldocumentation.master.MasterAgreementBase;
import cdm.legaldocumentation.master.isda.AutomaticEarlyTermination;
import cdm.legaldocumentation.master.isda.SpecifiedEntities;
import cdm.legaldocumentation.master.isda.TerminationCurrency;
import cdm.legaldocumentation.master.isda.meta.MasterAgreementMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MasterAgreement", builder=MasterAgreementBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="MasterAgreement", model="cdm", builder=MasterAgreementBuilderImpl.class, version="7.0.0-dev.50")
public interface MasterAgreement
extends MasterAgreementBase {
    public static final MasterAgreementMeta metaData = new MasterAgreementMeta();

    public AutomaticEarlyTermination getAutomaticEarlyTermination();

    public TerminationCurrency getTerminationCurrency();

    public AddressForNotices getAddressForNotices();

    public Boolean getNonContractualObligations();

    public CreditSupportDocument getCreditSupportDocument();

    public CreditSupportProvider getCreditSupportProvider();

    public List<? extends SpecifiedEntities> getSpecifiedEntities();

    @Override
    public MasterAgreement build();

    @Override
    public MasterAgreementBuilder toBuilder();

    public static MasterAgreementBuilder builder() {
        return new MasterAgreementBuilderImpl();
    }

    default public RosettaMetaData<? extends MasterAgreement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MasterAgreement> getType() {
        return MasterAgreement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("automaticEarlyTermination"), processor, AutomaticEarlyTermination.class, this.getAutomaticEarlyTermination(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationCurrency"), processor, TerminationCurrency.class, this.getTerminationCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("addressForNotices"), processor, AddressForNotices.class, this.getAddressForNotices(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonContractualObligations"), Boolean.class, (Object)this.getNonContractualObligations(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditSupportDocument"), processor, CreditSupportDocument.class, this.getCreditSupportDocument(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditSupportProvider"), processor, CreditSupportProvider.class, this.getCreditSupportProvider(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("specifiedEntities"), processor, SpecifiedEntities.class, this.getSpecifiedEntities(), new AttributeMeta[0]);
    }

    public static class MasterAgreementBuilderImpl
    extends MasterAgreementBase.MasterAgreementBaseBuilderImpl
    implements MasterAgreementBuilder {
        protected AutomaticEarlyTermination.AutomaticEarlyTerminationBuilder automaticEarlyTermination;
        protected TerminationCurrency.TerminationCurrencyBuilder terminationCurrency;
        protected AddressForNotices.AddressForNoticesBuilder addressForNotices;
        protected Boolean nonContractualObligations;
        protected CreditSupportDocument.CreditSupportDocumentBuilder creditSupportDocument;
        protected CreditSupportProvider.CreditSupportProviderBuilder creditSupportProvider;
        protected List<SpecifiedEntities.SpecifiedEntitiesBuilder> specifiedEntities = new ArrayList<SpecifiedEntities.SpecifiedEntitiesBuilder>();

        @Override
        @RosettaAttribute(value="automaticEarlyTermination", isRequired=true)
        @RuneAttribute(value="automaticEarlyTermination", isRequired=true)
        public AutomaticEarlyTermination.AutomaticEarlyTerminationBuilder getAutomaticEarlyTermination() {
            return this.automaticEarlyTermination;
        }

        @Override
        public AutomaticEarlyTermination.AutomaticEarlyTerminationBuilder getOrCreateAutomaticEarlyTermination() {
            AutomaticEarlyTermination.AutomaticEarlyTerminationBuilder result = this.automaticEarlyTermination != null ? this.automaticEarlyTermination : (this.automaticEarlyTermination = AutomaticEarlyTermination.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="terminationCurrency", isRequired=true)
        @RuneAttribute(value="terminationCurrency", isRequired=true)
        public TerminationCurrency.TerminationCurrencyBuilder getTerminationCurrency() {
            return this.terminationCurrency;
        }

        @Override
        public TerminationCurrency.TerminationCurrencyBuilder getOrCreateTerminationCurrency() {
            TerminationCurrency.TerminationCurrencyBuilder result = this.terminationCurrency != null ? this.terminationCurrency : (this.terminationCurrency = TerminationCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="addressForNotices", isRequired=true)
        @RuneAttribute(value="addressForNotices", isRequired=true)
        public AddressForNotices.AddressForNoticesBuilder getAddressForNotices() {
            return this.addressForNotices;
        }

        @Override
        public AddressForNotices.AddressForNoticesBuilder getOrCreateAddressForNotices() {
            AddressForNotices.AddressForNoticesBuilder result = this.addressForNotices != null ? this.addressForNotices : (this.addressForNotices = AddressForNotices.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonContractualObligations", isRequired=true)
        @RuneAttribute(value="nonContractualObligations", isRequired=true)
        public Boolean getNonContractualObligations() {
            return this.nonContractualObligations;
        }

        @Override
        @RosettaAttribute(value="creditSupportDocument", isRequired=true)
        @RuneAttribute(value="creditSupportDocument", isRequired=true)
        public CreditSupportDocument.CreditSupportDocumentBuilder getCreditSupportDocument() {
            return this.creditSupportDocument;
        }

        @Override
        public CreditSupportDocument.CreditSupportDocumentBuilder getOrCreateCreditSupportDocument() {
            CreditSupportDocument.CreditSupportDocumentBuilder result = this.creditSupportDocument != null ? this.creditSupportDocument : (this.creditSupportDocument = CreditSupportDocument.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditSupportProvider", isRequired=true)
        @RuneAttribute(value="creditSupportProvider", isRequired=true)
        public CreditSupportProvider.CreditSupportProviderBuilder getCreditSupportProvider() {
            return this.creditSupportProvider;
        }

        @Override
        public CreditSupportProvider.CreditSupportProviderBuilder getOrCreateCreditSupportProvider() {
            CreditSupportProvider.CreditSupportProviderBuilder result = this.creditSupportProvider != null ? this.creditSupportProvider : (this.creditSupportProvider = CreditSupportProvider.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="specifiedEntities", isRequired=true)
        @RuneAttribute(value="specifiedEntities", isRequired=true)
        public List<? extends SpecifiedEntities.SpecifiedEntitiesBuilder> getSpecifiedEntities() {
            return this.specifiedEntities;
        }

        @Override
        public SpecifiedEntities.SpecifiedEntitiesBuilder getOrCreateSpecifiedEntities(int index) {
            if (this.specifiedEntities == null) {
                this.specifiedEntities = new ArrayList<SpecifiedEntities.SpecifiedEntitiesBuilder>();
            }
            return (SpecifiedEntities.SpecifiedEntitiesBuilder)this.getIndex(this.specifiedEntities, index, () -> {
                SpecifiedEntities.SpecifiedEntitiesBuilder newSpecifiedEntities = SpecifiedEntities.builder();
                return newSpecifiedEntities;
            });
        }

        @Override
        @RosettaAttribute(value="automaticEarlyTermination", isRequired=true)
        @RuneAttribute(value="automaticEarlyTermination", isRequired=true)
        public MasterAgreementBuilder setAutomaticEarlyTermination(AutomaticEarlyTermination _automaticEarlyTermination) {
            this.automaticEarlyTermination = _automaticEarlyTermination == null ? null : _automaticEarlyTermination.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationCurrency", isRequired=true)
        @RuneAttribute(value="terminationCurrency", isRequired=true)
        public MasterAgreementBuilder setTerminationCurrency(TerminationCurrency _terminationCurrency) {
            this.terminationCurrency = _terminationCurrency == null ? null : _terminationCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="addressForNotices", isRequired=true)
        @RuneAttribute(value="addressForNotices", isRequired=true)
        public MasterAgreementBuilder setAddressForNotices(AddressForNotices _addressForNotices) {
            this.addressForNotices = _addressForNotices == null ? null : _addressForNotices.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonContractualObligations", isRequired=true)
        @RuneAttribute(value="nonContractualObligations", isRequired=true)
        public MasterAgreementBuilder setNonContractualObligations(Boolean _nonContractualObligations) {
            this.nonContractualObligations = _nonContractualObligations == null ? null : _nonContractualObligations;
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportDocument", isRequired=true)
        @RuneAttribute(value="creditSupportDocument", isRequired=true)
        public MasterAgreementBuilder setCreditSupportDocument(CreditSupportDocument _creditSupportDocument) {
            this.creditSupportDocument = _creditSupportDocument == null ? null : _creditSupportDocument.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportProvider", isRequired=true)
        @RuneAttribute(value="creditSupportProvider", isRequired=true)
        public MasterAgreementBuilder setCreditSupportProvider(CreditSupportProvider _creditSupportProvider) {
            this.creditSupportProvider = _creditSupportProvider == null ? null : _creditSupportProvider.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="specifiedEntities", isRequired=true)
        @RuneAttribute(value="specifiedEntities", isRequired=true)
        public MasterAgreementBuilder addSpecifiedEntities(SpecifiedEntities _specifiedEntities) {
            if (_specifiedEntities != null) {
                this.specifiedEntities.add(_specifiedEntities.toBuilder());
            }
            return this;
        }

        @Override
        public MasterAgreementBuilder addSpecifiedEntities(SpecifiedEntities _specifiedEntities, int idx) {
            this.getIndex(this.specifiedEntities, idx, () -> _specifiedEntities.toBuilder());
            return this;
        }

        @Override
        public MasterAgreementBuilder addSpecifiedEntities(List<? extends SpecifiedEntities> specifiedEntitiess) {
            if (specifiedEntitiess != null) {
                for (SpecifiedEntities specifiedEntities : specifiedEntitiess) {
                    this.specifiedEntities.add(specifiedEntities.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="specifiedEntities")
        public MasterAgreementBuilder setSpecifiedEntities(List<? extends SpecifiedEntities> specifiedEntitiess) {
            this.specifiedEntities = specifiedEntitiess == null ? new ArrayList<SpecifiedEntities.SpecifiedEntitiesBuilder>() : (List)specifiedEntitiess.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MasterAgreement build() {
            return new MasterAgreementImpl(this);
        }

        @Override
        public MasterAgreementBuilder toBuilder() {
            return this;
        }

        @Override
        public MasterAgreementBuilder prune() {
            super.prune();
            if (this.automaticEarlyTermination != null && !this.automaticEarlyTermination.prune().hasData()) {
                this.automaticEarlyTermination = null;
            }
            if (this.terminationCurrency != null && !this.terminationCurrency.prune().hasData()) {
                this.terminationCurrency = null;
            }
            if (this.addressForNotices != null && !this.addressForNotices.prune().hasData()) {
                this.addressForNotices = null;
            }
            if (this.creditSupportDocument != null && !this.creditSupportDocument.prune().hasData()) {
                this.creditSupportDocument = null;
            }
            if (this.creditSupportProvider != null && !this.creditSupportProvider.prune().hasData()) {
                this.creditSupportProvider = null;
            }
            this.specifiedEntities = this.specifiedEntities.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAutomaticEarlyTermination() != null && this.getAutomaticEarlyTermination().hasData()) {
                return true;
            }
            if (this.getTerminationCurrency() != null && this.getTerminationCurrency().hasData()) {
                return true;
            }
            if (this.getAddressForNotices() != null && this.getAddressForNotices().hasData()) {
                return true;
            }
            if (this.getNonContractualObligations() != null) {
                return true;
            }
            if (this.getCreditSupportDocument() != null && this.getCreditSupportDocument().hasData()) {
                return true;
            }
            if (this.getCreditSupportProvider() != null && this.getCreditSupportProvider().hasData()) {
                return true;
            }
            return this.getSpecifiedEntities() != null && this.getSpecifiedEntities().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public MasterAgreementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MasterAgreementBuilder o = (MasterAgreementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAutomaticEarlyTermination(), (RosettaModelObjectBuilder)o.getAutomaticEarlyTermination(), this::setAutomaticEarlyTermination);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerminationCurrency(), (RosettaModelObjectBuilder)o.getTerminationCurrency(), this::setTerminationCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAddressForNotices(), (RosettaModelObjectBuilder)o.getAddressForNotices(), this::setAddressForNotices);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditSupportDocument(), (RosettaModelObjectBuilder)o.getCreditSupportDocument(), this::setCreditSupportDocument);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditSupportProvider(), (RosettaModelObjectBuilder)o.getCreditSupportProvider(), this::setCreditSupportProvider);
            merger.mergeRosetta(this.getSpecifiedEntities(), o.getSpecifiedEntities(), this::getOrCreateSpecifiedEntities);
            merger.mergeBasic((Object)this.getNonContractualObligations(), (Object)o.getNonContractualObligations(), this::setNonContractualObligations, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MasterAgreement _that = (MasterAgreement)this.getType().cast(o);
            if (!Objects.equals(this.automaticEarlyTermination, _that.getAutomaticEarlyTermination())) {
                return false;
            }
            if (!Objects.equals(this.terminationCurrency, _that.getTerminationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.addressForNotices, _that.getAddressForNotices())) {
                return false;
            }
            if (!Objects.equals(this.nonContractualObligations, _that.getNonContractualObligations())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportDocument, _that.getCreditSupportDocument())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportProvider, _that.getCreditSupportProvider())) {
                return false;
            }
            return ListEquals.listEquals(this.specifiedEntities, _that.getSpecifiedEntities());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.automaticEarlyTermination != null ? this.automaticEarlyTermination.hashCode() : 0);
            _result = 31 * _result + (this.terminationCurrency != null ? this.terminationCurrency.hashCode() : 0);
            _result = 31 * _result + (this.addressForNotices != null ? this.addressForNotices.hashCode() : 0);
            _result = 31 * _result + (this.nonContractualObligations != null ? this.nonContractualObligations.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportDocument != null ? this.creditSupportDocument.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportProvider != null ? this.creditSupportProvider.hashCode() : 0);
            _result = 31 * _result + (this.specifiedEntities != null ? this.specifiedEntities.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MasterAgreementBuilder {automaticEarlyTermination=" + this.automaticEarlyTermination + ", terminationCurrency=" + this.terminationCurrency + ", addressForNotices=" + this.addressForNotices + ", nonContractualObligations=" + this.nonContractualObligations + ", creditSupportDocument=" + this.creditSupportDocument + ", creditSupportProvider=" + this.creditSupportProvider + ", specifiedEntities=" + this.specifiedEntities + '}' + " " + super.toString();
        }
    }

    public static interface MasterAgreementBuilder
    extends MasterAgreement,
    MasterAgreementBase.MasterAgreementBaseBuilder {
        public AutomaticEarlyTermination.AutomaticEarlyTerminationBuilder getOrCreateAutomaticEarlyTermination();

        @Override
        public AutomaticEarlyTermination.AutomaticEarlyTerminationBuilder getAutomaticEarlyTermination();

        public TerminationCurrency.TerminationCurrencyBuilder getOrCreateTerminationCurrency();

        @Override
        public TerminationCurrency.TerminationCurrencyBuilder getTerminationCurrency();

        public AddressForNotices.AddressForNoticesBuilder getOrCreateAddressForNotices();

        @Override
        public AddressForNotices.AddressForNoticesBuilder getAddressForNotices();

        public CreditSupportDocument.CreditSupportDocumentBuilder getOrCreateCreditSupportDocument();

        @Override
        public CreditSupportDocument.CreditSupportDocumentBuilder getCreditSupportDocument();

        public CreditSupportProvider.CreditSupportProviderBuilder getOrCreateCreditSupportProvider();

        @Override
        public CreditSupportProvider.CreditSupportProviderBuilder getCreditSupportProvider();

        public SpecifiedEntities.SpecifiedEntitiesBuilder getOrCreateSpecifiedEntities(int var1);

        public List<? extends SpecifiedEntities.SpecifiedEntitiesBuilder> getSpecifiedEntities();

        public MasterAgreementBuilder setAutomaticEarlyTermination(AutomaticEarlyTermination var1);

        public MasterAgreementBuilder setTerminationCurrency(TerminationCurrency var1);

        public MasterAgreementBuilder setAddressForNotices(AddressForNotices var1);

        public MasterAgreementBuilder setNonContractualObligations(Boolean var1);

        public MasterAgreementBuilder setCreditSupportDocument(CreditSupportDocument var1);

        public MasterAgreementBuilder setCreditSupportProvider(CreditSupportProvider var1);

        public MasterAgreementBuilder addSpecifiedEntities(SpecifiedEntities var1);

        public MasterAgreementBuilder addSpecifiedEntities(SpecifiedEntities var1, int var2);

        public MasterAgreementBuilder addSpecifiedEntities(List<? extends SpecifiedEntities> var1);

        public MasterAgreementBuilder setSpecifiedEntities(List<? extends SpecifiedEntities> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("automaticEarlyTermination"), processor, AutomaticEarlyTermination.AutomaticEarlyTerminationBuilder.class, this.getAutomaticEarlyTermination(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationCurrency"), processor, TerminationCurrency.TerminationCurrencyBuilder.class, this.getTerminationCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("addressForNotices"), processor, AddressForNotices.AddressForNoticesBuilder.class, this.getAddressForNotices(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonContractualObligations"), Boolean.class, (Object)this.getNonContractualObligations(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditSupportDocument"), processor, CreditSupportDocument.CreditSupportDocumentBuilder.class, this.getCreditSupportDocument(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditSupportProvider"), processor, CreditSupportProvider.CreditSupportProviderBuilder.class, this.getCreditSupportProvider(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("specifiedEntities"), processor, SpecifiedEntities.SpecifiedEntitiesBuilder.class, this.getSpecifiedEntities(), new AttributeMeta[0]);
        }

        @Override
        public MasterAgreementBuilder prune();
    }

    public static class MasterAgreementImpl
    extends MasterAgreementBase.MasterAgreementBaseImpl
    implements MasterAgreement {
        private final AutomaticEarlyTermination automaticEarlyTermination;
        private final TerminationCurrency terminationCurrency;
        private final AddressForNotices addressForNotices;
        private final Boolean nonContractualObligations;
        private final CreditSupportDocument creditSupportDocument;
        private final CreditSupportProvider creditSupportProvider;
        private final List<? extends SpecifiedEntities> specifiedEntities;

        protected MasterAgreementImpl(MasterAgreementBuilder builder) {
            super(builder);
            this.automaticEarlyTermination = Optional.ofNullable(builder.getAutomaticEarlyTermination()).map(f -> f.build()).orElse(null);
            this.terminationCurrency = Optional.ofNullable(builder.getTerminationCurrency()).map(f -> f.build()).orElse(null);
            this.addressForNotices = Optional.ofNullable(builder.getAddressForNotices()).map(f -> f.build()).orElse(null);
            this.nonContractualObligations = builder.getNonContractualObligations();
            this.creditSupportDocument = Optional.ofNullable(builder.getCreditSupportDocument()).map(f -> f.build()).orElse(null);
            this.creditSupportProvider = Optional.ofNullable(builder.getCreditSupportProvider()).map(f -> f.build()).orElse(null);
            this.specifiedEntities = Optional.ofNullable(builder.getSpecifiedEntities()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="automaticEarlyTermination", isRequired=true)
        @RuneAttribute(value="automaticEarlyTermination", isRequired=true)
        public AutomaticEarlyTermination getAutomaticEarlyTermination() {
            return this.automaticEarlyTermination;
        }

        @Override
        @RosettaAttribute(value="terminationCurrency", isRequired=true)
        @RuneAttribute(value="terminationCurrency", isRequired=true)
        public TerminationCurrency getTerminationCurrency() {
            return this.terminationCurrency;
        }

        @Override
        @RosettaAttribute(value="addressForNotices", isRequired=true)
        @RuneAttribute(value="addressForNotices", isRequired=true)
        public AddressForNotices getAddressForNotices() {
            return this.addressForNotices;
        }

        @Override
        @RosettaAttribute(value="nonContractualObligations", isRequired=true)
        @RuneAttribute(value="nonContractualObligations", isRequired=true)
        public Boolean getNonContractualObligations() {
            return this.nonContractualObligations;
        }

        @Override
        @RosettaAttribute(value="creditSupportDocument", isRequired=true)
        @RuneAttribute(value="creditSupportDocument", isRequired=true)
        public CreditSupportDocument getCreditSupportDocument() {
            return this.creditSupportDocument;
        }

        @Override
        @RosettaAttribute(value="creditSupportProvider", isRequired=true)
        @RuneAttribute(value="creditSupportProvider", isRequired=true)
        public CreditSupportProvider getCreditSupportProvider() {
            return this.creditSupportProvider;
        }

        @Override
        @RosettaAttribute(value="specifiedEntities", isRequired=true)
        @RuneAttribute(value="specifiedEntities", isRequired=true)
        public List<? extends SpecifiedEntities> getSpecifiedEntities() {
            return this.specifiedEntities;
        }

        @Override
        public MasterAgreement build() {
            return this;
        }

        @Override
        public MasterAgreementBuilder toBuilder() {
            MasterAgreementBuilder builder = MasterAgreement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MasterAgreementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAutomaticEarlyTermination()).ifPresent(builder::setAutomaticEarlyTermination);
            Optional.ofNullable(this.getTerminationCurrency()).ifPresent(builder::setTerminationCurrency);
            Optional.ofNullable(this.getAddressForNotices()).ifPresent(builder::setAddressForNotices);
            Optional.ofNullable(this.getNonContractualObligations()).ifPresent(builder::setNonContractualObligations);
            Optional.ofNullable(this.getCreditSupportDocument()).ifPresent(builder::setCreditSupportDocument);
            Optional.ofNullable(this.getCreditSupportProvider()).ifPresent(builder::setCreditSupportProvider);
            Optional.ofNullable(this.getSpecifiedEntities()).ifPresent(builder::setSpecifiedEntities);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MasterAgreement _that = (MasterAgreement)this.getType().cast(o);
            if (!Objects.equals(this.automaticEarlyTermination, _that.getAutomaticEarlyTermination())) {
                return false;
            }
            if (!Objects.equals(this.terminationCurrency, _that.getTerminationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.addressForNotices, _that.getAddressForNotices())) {
                return false;
            }
            if (!Objects.equals(this.nonContractualObligations, _that.getNonContractualObligations())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportDocument, _that.getCreditSupportDocument())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportProvider, _that.getCreditSupportProvider())) {
                return false;
            }
            return ListEquals.listEquals(this.specifiedEntities, _that.getSpecifiedEntities());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.automaticEarlyTermination != null ? this.automaticEarlyTermination.hashCode() : 0);
            _result = 31 * _result + (this.terminationCurrency != null ? this.terminationCurrency.hashCode() : 0);
            _result = 31 * _result + (this.addressForNotices != null ? this.addressForNotices.hashCode() : 0);
            _result = 31 * _result + (this.nonContractualObligations != null ? this.nonContractualObligations.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportDocument != null ? this.creditSupportDocument.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportProvider != null ? this.creditSupportProvider.hashCode() : 0);
            _result = 31 * _result + (this.specifiedEntities != null ? this.specifiedEntities.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MasterAgreement {automaticEarlyTermination=" + this.automaticEarlyTermination + ", terminationCurrency=" + this.terminationCurrency + ", addressForNotices=" + this.addressForNotices + ", nonContractualObligations=" + this.nonContractualObligations + ", creditSupportDocument=" + this.creditSupportDocument + ", creditSupportProvider=" + this.creditSupportProvider + ", specifiedEntities=" + this.specifiedEntities + '}' + " " + super.toString();
        }
    }
}

