/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.RatingAgencyAmount;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="RatingAgencyAmountRestrictingCreditNotation")
@ImplementedBy(value=Default.class)
public interface RatingAgencyAmountRestrictingCreditNotation
extends Validator<RatingAgencyAmount> {
    public static final String NAME = "RatingAgencyAmountRestrictingCreditNotation";
    public static final String DEFINITION = "ratingVariableSet -> scale is absent and ratingVariableSet -> outlook is absent and ratingVariableSet -> debt is absent and ratingVariableSet -> creditWatch is absent and ratingVariableSet -> agency exists and ratingVariableSet -> notation exists";

    public static class NoOp
    implements RatingAgencyAmountRestrictingCreditNotation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RatingAgencyAmount ratingAgencyAmount) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements RatingAgencyAmountRestrictingCreditNotation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RatingAgencyAmount ratingAgencyAmount) {
            ComparisonResult result = this.executeDataRule(ratingAgencyAmount);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)RatingAgencyAmountRestrictingCreditNotation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RatingAgencyAmount", (RosettaPath)path, (String)RatingAgencyAmountRestrictingCreditNotation.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)RatingAgencyAmountRestrictingCreditNotation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RatingAgencyAmount", (RosettaPath)path, (String)RatingAgencyAmountRestrictingCreditNotation.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(RatingAgencyAmount ratingAgencyAmount) {
            try {
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyAmount).mapC("getRatingVariableSet", _ratingAgencyAmount -> _ratingAgencyAmount.getRatingVariableSet()).map("getScale", creditNotation -> creditNotation.getScale())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyAmount).mapC("getRatingVariableSet", _ratingAgencyAmount -> _ratingAgencyAmount.getRatingVariableSet()).map("getOutlook", creditNotation -> creditNotation.getOutlook()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyAmount).mapC("getRatingVariableSet", _ratingAgencyAmount -> _ratingAgencyAmount.getRatingVariableSet()).map("getDebt", creditNotation -> creditNotation.getDebt()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)ratingAgencyAmount).mapC("getRatingVariableSet", _ratingAgencyAmount -> _ratingAgencyAmount.getRatingVariableSet()).map("getCreditWatch", creditNotation -> creditNotation.getCreditWatch()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)ratingAgencyAmount).mapC("getRatingVariableSet", _ratingAgencyAmount -> _ratingAgencyAmount.getRatingVariableSet()).map("getAgency", creditNotation -> creditNotation.getAgency()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)ratingAgencyAmount).mapC("getRatingVariableSet", _ratingAgencyAmount -> _ratingAgencyAmount.getRatingVariableSet()).map("getNotation", creditNotation -> creditNotation.getNotation())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

