/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.common.ExecutionLocationEnum;
import cdm.legaldocumentation.csa.ExecutionLocation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ExecutionLocationOtherLanguage")
@ImplementedBy(value=Default.class)
public interface ExecutionLocationOtherLanguage
extends Validator<ExecutionLocation> {
    public static final String NAME = "ExecutionLocationOtherLanguage";
    public static final String DEFINITION = "if executionLocation = ExecutionLocationEnum -> OtherLocation then otherLanguage exists";

    public static class NoOp
    implements ExecutionLocationOtherLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionLocation executionLocation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ExecutionLocationOtherLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionLocation executionLocation) {
            ComparisonResult result = this.executeDataRule(executionLocation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ExecutionLocationOtherLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExecutionLocation", (RosettaPath)path, (String)ExecutionLocationOtherLanguage.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ExecutionLocationOtherLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExecutionLocation", (RosettaPath)path, (String)ExecutionLocationOtherLanguage.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ExecutionLocation executionLocation) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)executionLocation).map("getExecutionLocation", _executionLocation -> _executionLocation.getExecutionLocation()), (Mapper)MapperS.of((Object)((Object)ExecutionLocationEnum.OTHER_LOCATION)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)executionLocation).map("getOtherLanguage", _executionLocation -> _executionLocation.getOtherLanguage()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

