/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.ExecutionLanguage;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ExecutionLanguageNumberOfOriginals")
@ImplementedBy(value=Default.class)
public interface ExecutionLanguageNumberOfOriginals
extends Validator<ExecutionLanguage> {
    public static final String NAME = "ExecutionLanguageNumberOfOriginals";
    public static final String DEFINITION = "if standardLanguage = False then numberOfOriginals is absent";

    public static class NoOp
    implements ExecutionLanguageNumberOfOriginals {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionLanguage executionLanguage) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ExecutionLanguageNumberOfOriginals {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionLanguage executionLanguage) {
            ComparisonResult result = this.executeDataRule(executionLanguage);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ExecutionLanguageNumberOfOriginals.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExecutionLanguage", (RosettaPath)path, (String)ExecutionLanguageNumberOfOriginals.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ExecutionLanguageNumberOfOriginals.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExecutionLanguage", (RosettaPath)path, (String)ExecutionLanguageNumberOfOriginals.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ExecutionLanguage executionLanguage) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)executionLanguage).map("getStandardLanguage", _executionLanguage -> _executionLanguage.getStandardLanguage()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)executionLanguage).map("getNumberOfOriginals", _executionLanguage -> _executionLanguage.getNumberOfOriginals()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

