/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.DirectionRating;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="DirectionRatingRestrictingCreditNotation")
@ImplementedBy(value=Default.class)
public interface DirectionRatingRestrictingCreditNotation
extends Validator<DirectionRating> {
    public static final String NAME = "DirectionRatingRestrictingCreditNotation";
    public static final String DEFINITION = "(scale is absent and debt is absent and outlook is absent and creditWatch is absent) and (agency exists and notation exists)";

    public static class NoOp
    implements DirectionRatingRestrictingCreditNotation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DirectionRating directionRating) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements DirectionRatingRestrictingCreditNotation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DirectionRating directionRating) {
            ComparisonResult result = this.executeDataRule(directionRating);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)DirectionRatingRestrictingCreditNotation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DirectionRating", (RosettaPath)path, (String)DirectionRatingRestrictingCreditNotation.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)DirectionRatingRestrictingCreditNotation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DirectionRating", (RosettaPath)path, (String)DirectionRatingRestrictingCreditNotation.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(DirectionRating directionRating) {
            try {
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)directionRating).map("getScale", _directionRating -> _directionRating.getScale())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)directionRating).map("getDebt", _directionRating -> _directionRating.getDebt()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)directionRating).map("getOutlook", _directionRating -> _directionRating.getOutlook()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)directionRating).map("getCreditWatch", _directionRating -> _directionRating.getCreditWatch()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)directionRating).map("getAgency", _directionRating -> _directionRating.getAgency())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)directionRating).map("getNotation", _directionRating -> _directionRating.getNotation()))));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

