/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.product.collateral.CollateralInterestCalculationParameters;
import cdm.product.collateral.CollateralInterestHandlingEnum;
import cdm.product.collateral.CollateralInterestHandlingParameters;
import cdm.product.collateral.CollateralInterestParameters;
import cdm.product.collateral.DeliveryAmount;
import cdm.product.collateral.DeliveryAmountElectionEnum;
import cdm.product.collateral.DistributionAndInterestPayment;
import cdm.product.collateral.InterestAmountApplication;
import cdm.product.collateral.ReturnAmount;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.util.CollectionUtils;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class DistributionAndInterestPaymentMappingProcessor
extends MappingProcessor {
    public DistributionAndInterestPaymentMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        AtomicInteger index = new AtomicInteger(0);
        Path baseSynonymPath = synonymPath.getParent().getParent();
        CollectionUtils.emptyIfNull(((DistributionAndInterestPayment.DistributionAndInterestPaymentBuilder)builder).getInterestParameters()).forEach(b -> this.mapInterestParameters(baseSynonymPath, (CollateralInterestParameters.CollateralInterestParametersBuilder)b, index.getAndIncrement()));
    }

    private void mapInterestParameters(Path baseSynonymPath, CollateralInterestParameters.CollateralInterestParametersBuilder interestParametersBuilder, int index) {
        this.mapInterestHandlingParameters(baseSynonymPath, interestParametersBuilder.getOrCreateInterestHandlingParameters());
        this.mapCreateInterestCalculationParameters(baseSynonymPath, interestParametersBuilder.getOrCreateInterestCalculationParameters());
    }

    private void mapInterestHandlingParameters(Path baseSynonymPath, CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder interestHandlingParameters) {
        Path interestTransferPath = baseSynonymPath.addElement("interest_transfer").addElement("interest_transfer");
        boolean interestTransfer = this.getValueAndUpdateMappings(interestTransferPath).map("applicable"::equals).orElse(false);
        Path interestAdjustmentPath = baseSynonymPath.addElement("interest_adjustment").addElement("is_applicable");
        boolean interestAdjustment = this.getValueAndUpdateMappings(interestAdjustmentPath).map("applicable"::equals).orElse(false);
        Optional.ofNullable(interestTransfer && interestAdjustment ? CollateralInterestHandlingEnum.TRANSFER_OR_ADJUST : (interestTransfer ? CollateralInterestHandlingEnum.TRANSFER : (interestAdjustment ? CollateralInterestHandlingEnum.ADJUST : null))).ifPresent(interestHandlingParameters::setInterestPaymentHandling);
        Path interestPaymentNettingPath = baseSynonymPath.addElement("interest_payment_netting").addElement("interest_payment_netting");
        this.setValueAndUpdateMappings(interestPaymentNettingPath, value -> interestHandlingParameters.setNetPostedAndHeldInterest("applicable".equals(value)));
        this.mapInterestAmountApplication(baseSynonymPath, interestHandlingParameters.getOrCreateInterestAmountApplication());
        Path alternativePath = baseSynonymPath.addElement("alternative_to_interest_amounts_and_interest_payment");
        boolean specifyAlternative = this.getValueAndUpdateMappings(alternativePath.addElement("specify_alternative")).map("true"::equals).orElse(false);
        if (specifyAlternative) {
            this.setValueAndUpdateMappings(alternativePath.addElement("specify"), value -> interestHandlingParameters.setAlternativeProvision((String)value));
        }
    }

    private void mapInterestAmountApplication(Path baseSynonymPath, InterestAmountApplication.InterestAmountApplicationBuilder interestAmountApplication) {
        this.mapDeliveryAmount(baseSynonymPath, interestAmountApplication.getOrCreateDeliveryAmount());
        this.mapReturnAmount(baseSynonymPath, interestAmountApplication.getOrCreateReturnAmount());
    }

    private void mapDeliveryAmount(Path baseSynonymPath, DeliveryAmount.DeliveryAmountBuilder deliveryAmount) {
        Path returnAndDeliveryAmountPath = baseSynonymPath.addElement("return_amount_delivery_amount");
        this.setValueAndUpdateMappings(returnAndDeliveryAmountPath.addElement("delivery_amount"), value -> this.getSynonymToEnumMap().getEnumValueOptional(DeliveryAmountElectionEnum.class, value).ifPresent(deliveryAmount::setStandardElection));
        this.setValueAndUpdateMappings(returnAndDeliveryAmountPath.addElement("specify_delivery_amount"), deliveryAmount::setCustomElection);
    }

    private void mapReturnAmount(Path baseSynonymPath, ReturnAmount.ReturnAmountBuilder returnAmount) {
        Path returnAndDeliveryAmountPath = baseSynonymPath.addElement("return_amount_delivery_amount");
        this.setValueAndUpdateMappings(returnAndDeliveryAmountPath.addElement("return_amount"), value -> returnAmount.setIncludesDefaultLanguage("include".equals(value)));
        this.setValueAndUpdateMappings(returnAndDeliveryAmountPath.addElement("specify_return_amount"), returnAmount::setCustomElection);
    }

    private void mapCreateInterestCalculationParameters(Path baseSynonymPath, CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder interestCalculationParameters) {
        this.setValueAndUpdateMappings(baseSynonymPath.addElement("negative_interest").addElement("negative_interest"), value -> interestCalculationParameters.getOrCreateFloatingRate().setNegativeInterest("applicable".equals(value)));
    }
}

