/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.legaldocumentation.csa.AdditionalTypeEnum;
import cdm.legaldocumentation.csa.ApplicableRegime;
import cdm.legaldocumentation.csa.Regime;
import cdm.legaldocumentation.csa.RegimeTerms;
import cdm.legaldocumentation.csa.RegulatoryRegimeEnum;
import cdm.legaldocumentation.csa.processor.RegimeMappingHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class ApplicableRegimeMappingProcessor
extends MappingProcessor {
    private final RegimeMappingHelper helper;

    public ApplicableRegimeMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
        this.helper = new RegimeMappingHelper(modelPath, mappingContext.getMappings(), mappingContext.getSynonymToEnumMap());
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        Regime.RegimeBuilder regimeBuilder = (Regime.RegimeBuilder)parent;
        if (synonymPath.endsWith(new String[]{"additional_regimes"})) {
            this.mapAdditionalRegimes(synonymPath, regimeBuilder);
        } else {
            this.mapApplicableRegime(synonymPath, regimeBuilder);
        }
    }

    private void mapApplicableRegime(Path synonymPath, Regime.RegimeBuilder regimeBuilder) {
        List<RegimeTerms> termedParties = CreateiQMappingProcessorUtils.PARTIES.stream().map(party -> this.helper.getRegimeTerms(synonymPath, (String)party, null)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (termedParties.size() > 0) {
            ApplicableRegime.ApplicableRegimeBuilder applicableRegimeBuilder = ApplicableRegime.builder();
            regimeBuilder.addApplicableRegime(applicableRegimeBuilder);
            this.getSynonymToEnumMap().getEnumValueOptional(RegulatoryRegimeEnum.class, synonymPath.getLastElement().getPathName()).ifPresent(applicableRegimeBuilder::setRegime);
            termedParties.forEach(applicableRegimeBuilder::addRegimeTerms);
            this.setValueAndUpdateMappings(synonymPath.addElement("additional_type"), value -> this.getSynonymToEnumMap().getEnumValueOptional(AdditionalTypeEnum.class, value).ifPresent(applicableRegimeBuilder::setAdditionalType));
            this.setValueAndUpdateMappings(synonymPath.addElement("additional_type_specify"), applicableRegimeBuilder::setAdditionalTerms);
        }
    }

    private void mapAdditionalRegimes(Path additionalRegimesPath, Regime.RegimeBuilder regimeBuilder) {
        Optional<ApplicableRegime.ApplicableRegimeBuilder> additionalRegime;
        Path regimesPath = additionalRegimesPath.addElement("regimes");
        List applicableMappings = MappingProcessorUtils.filterMappings((List)this.getMappings(), (Path)additionalRegimesPath.addElement("is_applicable"));
        Optional applicable = MappingProcessorUtils.getNonNullMappedValue((List)applicableMappings);
        if (applicable.isPresent()) {
            applicableMappings.forEach(m -> MappingProcessorUtils.updateMappingSuccess((Mapping)m, (RosettaPath)this.getModelPath()));
        }
        if (!applicable.isPresent() || ((String)applicable.get()).equals("not_applicable")) {
            MappingProcessorUtils.updateMappings((Path)regimesPath, (List)this.getMappings(), (RosettaPath)this.getModelPath());
            return;
        }
        int index = 0;
        while ((additionalRegime = this.getAdditionalRegime(regimesPath, index++)).isPresent()) {
            regimeBuilder.addApplicableRegime(additionalRegime.get());
        }
        MappingProcessorUtils.updateMappings((Path)additionalRegimesPath, (List)this.getMappings(), (RosettaPath)this.getModelPath());
    }

    private Optional<ApplicableRegime.ApplicableRegimeBuilder> getAdditionalRegime(Path regimesPath, Integer index) {
        ApplicableRegime.ApplicableRegimeBuilder additionalRegimeBuilder = ApplicableRegime.builder();
        this.setValueAndUpdateMappings(regimesPath.addElement("regime_name", index), value -> {
            additionalRegimeBuilder.setAdditionalRegime((String)value);
            CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.helper.getRegimeTerms(regimesPath, (String)party, index).ifPresent(additionalRegimeBuilder::addRegimeTerms));
        });
        this.setValueAndUpdateMappings(regimesPath.addElement("additional_type", index), value -> this.getSynonymToEnumMap().getEnumValueOptional(AdditionalTypeEnum.class, value).ifPresent(additionalRegimeBuilder::setAdditionalType));
        this.setValueAndUpdateMappings(regimesPath.addElement("additional_type_specify", index), additionalRegimeBuilder::setAdditionalTerms);
        return additionalRegimeBuilder.hasData() ? Optional.of(additionalRegimeBuilder) : Optional.empty();
    }
}

