/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PartyContactInformation;
import cdm.legaldocumentation.csa.meta.ProcessAgentElectionMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ProcessAgentElection", builder=ProcessAgentElectionBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="ProcessAgentElection", model="cdm", builder=ProcessAgentElectionBuilderImpl.class, version="7.0.0-dev.50")
public interface ProcessAgentElection
extends RosettaModelObject {
    public static final ProcessAgentElectionMeta metaData = new ProcessAgentElectionMeta();

    public CounterpartyRoleEnum getParty();

    public Boolean getIsApplicable();

    public PartyContactInformation getProcessAgent();

    public ProcessAgentElection build();

    public ProcessAgentElectionBuilder toBuilder();

    public static ProcessAgentElectionBuilder builder() {
        return new ProcessAgentElectionBuilderImpl();
    }

    default public RosettaMetaData<? extends ProcessAgentElection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ProcessAgentElection> getType() {
        return ProcessAgentElection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isApplicable"), Boolean.class, (Object)this.getIsApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("processAgent"), processor, PartyContactInformation.class, this.getProcessAgent(), new AttributeMeta[0]);
    }

    public static class ProcessAgentElectionBuilderImpl
    implements ProcessAgentElectionBuilder {
        protected CounterpartyRoleEnum party;
        protected Boolean isApplicable;
        protected PartyContactInformation.PartyContactInformationBuilder processAgent;

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="isApplicable", isRequired=true)
        @RuneAttribute(value="isApplicable", isRequired=true)
        public Boolean getIsApplicable() {
            return this.isApplicable;
        }

        @Override
        @RosettaAttribute(value="processAgent")
        @RuneAttribute(value="processAgent")
        public PartyContactInformation.PartyContactInformationBuilder getProcessAgent() {
            return this.processAgent;
        }

        @Override
        public PartyContactInformation.PartyContactInformationBuilder getOrCreateProcessAgent() {
            PartyContactInformation.PartyContactInformationBuilder result = this.processAgent != null ? this.processAgent : (this.processAgent = PartyContactInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public ProcessAgentElectionBuilder setParty(CounterpartyRoleEnum _party) {
            this.party = _party == null ? null : _party;
            return this;
        }

        @Override
        @RosettaAttribute(value="isApplicable", isRequired=true)
        @RuneAttribute(value="isApplicable", isRequired=true)
        public ProcessAgentElectionBuilder setIsApplicable(Boolean _isApplicable) {
            this.isApplicable = _isApplicable == null ? null : _isApplicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="processAgent")
        @RuneAttribute(value="processAgent")
        public ProcessAgentElectionBuilder setProcessAgent(PartyContactInformation _processAgent) {
            this.processAgent = _processAgent == null ? null : _processAgent.toBuilder();
            return this;
        }

        @Override
        public ProcessAgentElection build() {
            return new ProcessAgentElectionImpl(this);
        }

        @Override
        public ProcessAgentElectionBuilder toBuilder() {
            return this;
        }

        @Override
        public ProcessAgentElectionBuilder prune() {
            if (this.processAgent != null && !this.processAgent.prune().hasData()) {
                this.processAgent = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getParty() != null) {
                return true;
            }
            if (this.getIsApplicable() != null) {
                return true;
            }
            return this.getProcessAgent() != null && this.getProcessAgent().hasData();
        }

        public ProcessAgentElectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ProcessAgentElectionBuilder o = (ProcessAgentElectionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProcessAgent(), (RosettaModelObjectBuilder)o.getProcessAgent(), this::setProcessAgent);
            merger.mergeBasic((Object)this.getParty(), (Object)o.getParty(), this::setParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIsApplicable(), (Object)o.getIsApplicable(), this::setIsApplicable, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProcessAgentElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.isApplicable, _that.getIsApplicable())) {
                return false;
            }
            return Objects.equals(this.processAgent, _that.getProcessAgent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.isApplicable != null ? this.isApplicable.hashCode() : 0);
            _result = 31 * _result + (this.processAgent != null ? this.processAgent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProcessAgentElectionBuilder {party=" + (Object)((Object)this.party) + ", isApplicable=" + this.isApplicable + ", processAgent=" + this.processAgent + '}';
        }
    }

    public static interface ProcessAgentElectionBuilder
    extends ProcessAgentElection,
    RosettaModelObjectBuilder {
        public PartyContactInformation.PartyContactInformationBuilder getOrCreateProcessAgent();

        @Override
        public PartyContactInformation.PartyContactInformationBuilder getProcessAgent();

        public ProcessAgentElectionBuilder setParty(CounterpartyRoleEnum var1);

        public ProcessAgentElectionBuilder setIsApplicable(Boolean var1);

        public ProcessAgentElectionBuilder setProcessAgent(PartyContactInformation var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("party"), CounterpartyRoleEnum.class, (Object)this.getParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isApplicable"), Boolean.class, (Object)this.getIsApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("processAgent"), processor, PartyContactInformation.PartyContactInformationBuilder.class, this.getProcessAgent(), new AttributeMeta[0]);
        }

        public ProcessAgentElectionBuilder prune();
    }

    public static class ProcessAgentElectionImpl
    implements ProcessAgentElection {
        private final CounterpartyRoleEnum party;
        private final Boolean isApplicable;
        private final PartyContactInformation processAgent;

        protected ProcessAgentElectionImpl(ProcessAgentElectionBuilder builder) {
            this.party = builder.getParty();
            this.isApplicable = builder.getIsApplicable();
            this.processAgent = Optional.ofNullable(builder.getProcessAgent()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public CounterpartyRoleEnum getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="isApplicable", isRequired=true)
        @RuneAttribute(value="isApplicable", isRequired=true)
        public Boolean getIsApplicable() {
            return this.isApplicable;
        }

        @Override
        @RosettaAttribute(value="processAgent")
        @RuneAttribute(value="processAgent")
        public PartyContactInformation getProcessAgent() {
            return this.processAgent;
        }

        @Override
        public ProcessAgentElection build() {
            return this;
        }

        @Override
        public ProcessAgentElectionBuilder toBuilder() {
            ProcessAgentElectionBuilder builder = ProcessAgentElection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ProcessAgentElectionBuilder builder) {
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getIsApplicable()).ifPresent(builder::setIsApplicable);
            Optional.ofNullable(this.getProcessAgent()).ifPresent(builder::setProcessAgent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProcessAgentElection _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.party, (Object)_that.getParty())) {
                return false;
            }
            if (!Objects.equals(this.isApplicable, _that.getIsApplicable())) {
                return false;
            }
            return Objects.equals(this.processAgent, _that.getProcessAgent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.party != null ? ((Object)((Object)this.party)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.isApplicable != null ? this.isApplicable.hashCode() : 0);
            _result = 31 * _result + (this.processAgent != null ? this.processAgent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProcessAgentElection {party=" + (Object)((Object)this.party) + ", isApplicable=" + this.isApplicable + ", processAgent=" + this.processAgent + '}';
        }
    }
}

