/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.workflowstep.functions;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.Identifier;
import cdm.event.common.ActionEnum;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.Instruction;
import cdm.event.workflow.EventInstruction;
import cdm.event.workflow.EventTimestamp;
import cdm.event.workflow.WorkflowStep;
import cdm.ingest.fpml.confirmation.datetime.functions.MapEventTimestampQualification;
import cdm.ingest.fpml.confirmation.tradestate.functions.MapTradeState;
import cdm.ingest.fpml.confirmation.workflowstep.functions.MapMessageInformation;
import cdm.ingest.fpml.confirmation.workflowstep.functions.MapPrimitiveInstruction;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import fpml.confirmation.MessageHeaderModel;
import fpml.confirmation.MessageId;
import fpml.confirmation.PartiesAndAccountsModel;
import fpml.confirmation.PostTradeEventsBaseModel;
import fpml.confirmation.Trade;
import fpml.confirmation.TradingEventsBaseModel;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapWorkflowStepDefault.class)
public abstract class MapWorkflowStep
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapEventTimestampQualification mapEventTimestampQualification;
    @Inject
    protected MapMessageInformation mapMessageInformation;
    @Inject
    protected MapPrimitiveInstruction mapPrimitiveInstruction;
    @Inject
    protected MapTradeState mapTradeState;

    public WorkflowStep evaluate(MessageId messageId, MessageHeaderModel messageHeaderModel, ActionEnum action, Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel, EventIntentEnum intent, Date eventDate, Date effectiveDate, PostTradeEventsBaseModel fpmlPostTradeEventsBaseModel, TradingEventsBaseModel tradingEventsBaseModel) {
        WorkflowStep workflowStep;
        WorkflowStep.WorkflowStepBuilder workflowStepBuilder = this.doEvaluate(messageId, messageHeaderModel, action, fpmlTrade, fpmlPartiesAndAccountsModel, intent, eventDate, effectiveDate, fpmlPostTradeEventsBaseModel, tradingEventsBaseModel);
        if (workflowStepBuilder == null) {
            workflowStep = null;
        } else {
            workflowStep = workflowStepBuilder.build();
            this.objectValidator.validate(WorkflowStep.class, (RosettaModelObject)workflowStep);
        }
        return workflowStep;
    }

    protected abstract WorkflowStep.WorkflowStepBuilder doEvaluate(MessageId var1, MessageHeaderModel var2, ActionEnum var3, Trade var4, PartiesAndAccountsModel var5, EventIntentEnum var6, Date var7, Date var8, PostTradeEventsBaseModel var9, TradingEventsBaseModel var10);

    public static class MapWorkflowStepDefault
    extends MapWorkflowStep {
        @Override
        protected WorkflowStep.WorkflowStepBuilder doEvaluate(MessageId messageId, MessageHeaderModel messageHeaderModel, ActionEnum action, Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel, EventIntentEnum intent, Date eventDate, Date effectiveDate, PostTradeEventsBaseModel fpmlPostTradeEventsBaseModel, TradingEventsBaseModel tradingEventsBaseModel) {
            WorkflowStep.WorkflowStepBuilder workflowStep = WorkflowStep.builder();
            return this.assignOutput(workflowStep, messageId, messageHeaderModel, action, fpmlTrade, fpmlPartiesAndAccountsModel, intent, eventDate, effectiveDate, fpmlPostTradeEventsBaseModel, tradingEventsBaseModel);
        }

        protected WorkflowStep.WorkflowStepBuilder assignOutput(WorkflowStep.WorkflowStepBuilder workflowStep, MessageId messageId, MessageHeaderModel messageHeaderModel, ActionEnum action, Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel, EventIntentEnum intent, Date eventDate, Date effectiveDate, PostTradeEventsBaseModel fpmlPostTradeEventsBaseModel, TradingEventsBaseModel tradingEventsBaseModel) {
            EventTimestamp eventTimestamp = EventTimestamp.builder().setDateTime((ZonedDateTime)MapperS.of((Object)messageHeaderModel).map("getCreationTimestamp", _messageHeaderModel -> _messageHeaderModel.getCreationTimestamp()).get()).setQualification(this.mapEventTimestampQualification.evaluate(messageHeaderModel, fpmlTrade)).build();
            AssignedIdentifier assignedIdentifier = AssignedIdentifier.builder().setIdentifierValue((String)MapperS.of((Object)messageId).map("getValue", _messageId -> _messageId.getValue()).get()).build();
            Identifier identifier = Identifier.builder().setAssignedIdentifier(assignedIdentifier == null ? Collections.emptyList() : Collections.singletonList(assignedIdentifier)).build();
            workflowStep = (WorkflowStep.WorkflowStepBuilder)this.toBuilder(WorkflowStep.builder().setProposedEvent(EventInstruction.builder().setIntent(intent).setEventDate(eventDate).setEffectiveDate(effectiveDate).setInstruction(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)Instruction.builder().setPrimitiveInstruction(this.mapPrimitiveInstruction.evaluate(fpmlTrade, fpmlPostTradeEventsBaseModel, tradingEventsBaseModel)).setBeforeValue(this.mapTradeState.evaluate(fpmlTrade, fpmlPartiesAndAccountsModel)).build())}).getMulti()).build()).setTimestamp(eventTimestamp == null ? Collections.emptyList() : Collections.singletonList(eventTimestamp)).setEventIdentifier(identifier == null ? Collections.emptyList() : Collections.singletonList(identifier)).setMessageInformation(this.mapMessageInformation.evaluate(messageId, messageHeaderModel)).setAction(action).build());
            return Optional.ofNullable(workflowStep).map(o -> o.prune()).orElse(null);
        }
    }
}

