/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.genericproduct.functions;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.datetime.functions.MapAdjustable2;
import cdm.ingest.fpml.confirmation.product.genericproduct.functions.MapGenericProductPayout;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.AdjustableDate2;
import fpml.confirmation.GenericProduct;
import fpml.confirmation.PartyTradeInformation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapGenericProductEconomicTermsDefault.class)
public abstract class MapGenericProductEconomicTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAdjustable2 mapAdjustable2;
    @Inject
    protected MapGenericProductPayout mapGenericProductPayout;

    public EconomicTerms evaluate(GenericProduct fpmlGenericProduct, List<? extends Counterparty> cdmCounterpartyList, List<? extends PartyTradeInformation> fpmlPartyTradeInformation) {
        EconomicTerms economicTerms;
        EconomicTerms.EconomicTermsBuilder economicTermsBuilder = this.doEvaluate(fpmlGenericProduct, cdmCounterpartyList, fpmlPartyTradeInformation);
        if (economicTermsBuilder == null) {
            economicTerms = null;
        } else {
            economicTerms = economicTermsBuilder.build();
            this.objectValidator.validate(EconomicTerms.class, (RosettaModelObject)economicTerms);
        }
        return economicTerms;
    }

    protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(GenericProduct var1, List<? extends Counterparty> var2, List<? extends PartyTradeInformation> var3);

    public static class MapGenericProductEconomicTermsDefault
    extends MapGenericProductEconomicTerms {
        @Override
        protected EconomicTerms.EconomicTermsBuilder doEvaluate(GenericProduct fpmlGenericProduct, List<? extends Counterparty> cdmCounterpartyList, List<? extends PartyTradeInformation> fpmlPartyTradeInformation) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            if (fpmlPartyTradeInformation == null) {
                fpmlPartyTradeInformation = Collections.emptyList();
            }
            EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
            return this.assignOutput(economicTerms, fpmlGenericProduct, cdmCounterpartyList, fpmlPartyTradeInformation);
        }

        protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, GenericProduct fpmlGenericProduct, List<? extends Counterparty> cdmCounterpartyList, List<? extends PartyTradeInformation> fpmlPartyTradeInformation) {
            Payout payout = this.mapGenericProductPayout.evaluate(fpmlGenericProduct, cdmCounterpartyList);
            MapperC thenArg0 = MapperC.of(fpmlPartyTradeInformation).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getNonStandardTerms", partyTradeInformation -> partyTradeInformation.getNonStandardTerms())).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getNonStandardTerms", partyTradeInformation -> partyTradeInformation.getNonStandardTerms()));
            economicTerms = (EconomicTerms.EconomicTermsBuilder)this.toBuilder(EconomicTerms.builder().setEffectiveDate(AdjustableOrRelativeDate.builder().setAdjustableDate(this.mapAdjustable2.evaluate((AdjustableDate2)MapperS.of((Object)fpmlGenericProduct).map("getEffectiveDate", genericProduct -> genericProduct.getEffectiveDate()).get())).build()).setTerminationDate(AdjustableOrRelativeDate.builder().setAdjustableDate(this.mapAdjustable2.evaluate((AdjustableDate2)MapperS.of((Object)fpmlGenericProduct).map("getTerminationDate", genericProduct -> genericProduct.getTerminationDate()).get())).build()).setDateAdjustments(null).setPayout(payout == null ? Collections.emptyList() : Collections.singletonList(payout)).setTerminationProvision(null).setNonStandardisedTerms((Boolean)MapperS.of((Object)((Boolean)ExpressionOperators.distinct((Mapper)thenArg1).get())).get()).setCollateral(null).build());
            return Optional.ofNullable(economicTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

