/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.fra.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.ingest.fpml.confirmation.datetime.functions.MapAdjustableDate;
import cdm.ingest.fpml.confirmation.other.functions.MapDayCountFractionEnum;
import cdm.ingest.fpml.confirmation.party.functions.MapSellerAsPayerAndBuyerAsReceiver;
import cdm.ingest.fpml.confirmation.product.fra.functions.MapFraCalculationPeriodDates;
import cdm.ingest.fpml.confirmation.product.fra.functions.MapFraDiscountingMethod;
import cdm.ingest.fpml.confirmation.product.fra.functions.MapFraToFixedInterestRatePayout;
import cdm.ingest.fpml.confirmation.product.fra.functions.MapFraToFloatingInterestRatePayout;
import cdm.product.asset.DiscountingMethod;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.BuyerSellerModel;
import fpml.confirmation.Fra;
import fpml.confirmation.FraDiscountingEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapFraPayoutListDefault.class)
public abstract class MapFraPayoutList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAdjustableDate mapAdjustableDate;
    @Inject
    protected MapDayCountFractionEnum mapDayCountFractionEnum;
    @Inject
    protected MapFraCalculationPeriodDates mapFraCalculationPeriodDates;
    @Inject
    protected MapFraDiscountingMethod mapFraDiscountingMethod;
    @Inject
    protected MapFraToFixedInterestRatePayout mapFraToFixedInterestRatePayout;
    @Inject
    protected MapFraToFloatingInterestRatePayout mapFraToFloatingInterestRatePayout;
    @Inject
    protected MapSellerAsPayerAndBuyerAsReceiver mapSellerAsPayerAndBuyerAsReceiver;

    public List<? extends Payout> evaluate(Fra fpmlFra, List<? extends Counterparty> cdmCounterpartyList) {
        List payoutList;
        List<Payout.PayoutBuilder> payoutListBuilder = this.doEvaluate(fpmlFra, cdmCounterpartyList);
        if (payoutListBuilder == null) {
            payoutList = null;
        } else {
            payoutList = payoutListBuilder.stream().map(Payout::build).collect(Collectors.toList());
            this.objectValidator.validate(Payout.class, payoutList);
        }
        return payoutList;
    }

    protected abstract List<Payout.PayoutBuilder> doEvaluate(Fra var1, List<? extends Counterparty> var2);

    protected abstract MapperS<? extends PayerReceiver> floatingPayerReceiver(Fra var1, List<? extends Counterparty> var2);

    protected abstract MapperS<DayCountFractionEnum> dayCountFraction(Fra var1, List<? extends Counterparty> var2);

    protected abstract MapperS<? extends CalculationPeriodDates> calculationPeriodDates(Fra var1, List<? extends Counterparty> var2);

    protected abstract MapperS<? extends AdjustableDate> paymentDate(Fra var1, List<? extends Counterparty> var2);

    protected abstract MapperS<? extends DiscountingMethod> discountingMethod(Fra var1, List<? extends Counterparty> var2);

    public static class MapFraPayoutListDefault
    extends MapFraPayoutList {
        @Override
        protected List<Payout.PayoutBuilder> doEvaluate(Fra fpmlFra, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            ArrayList<Payout.PayoutBuilder> payoutList = new ArrayList<Payout.PayoutBuilder>();
            return this.assignOutput(payoutList, fpmlFra, cdmCounterpartyList);
        }

        protected List<Payout.PayoutBuilder> assignOutput(List<Payout.PayoutBuilder> payoutList, Fra fpmlFra, List<? extends Counterparty> cdmCounterpartyList) {
            Payout payout0 = this.mapFraToFixedInterestRatePayout.evaluate(fpmlFra, (PayerReceiver)this.floatingPayerReceiver(fpmlFra, cdmCounterpartyList).get(), (DayCountFractionEnum)((Object)this.dayCountFraction(fpmlFra, cdmCounterpartyList).get()), (CalculationPeriodDates)this.calculationPeriodDates(fpmlFra, cdmCounterpartyList).get(), (AdjustableDate)this.paymentDate(fpmlFra, cdmCounterpartyList).get(), (DiscountingMethod)this.discountingMethod(fpmlFra, cdmCounterpartyList).get());
            if (payout0 == null) {
                payoutList.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                payoutList.addAll(this.toBuilder(Collections.singletonList(payout0)));
            }
            Payout payout1 = this.mapFraToFloatingInterestRatePayout.evaluate(fpmlFra, (PayerReceiver)this.floatingPayerReceiver(fpmlFra, cdmCounterpartyList).get(), (DayCountFractionEnum)((Object)this.dayCountFraction(fpmlFra, cdmCounterpartyList).get()), (CalculationPeriodDates)this.calculationPeriodDates(fpmlFra, cdmCounterpartyList).get(), (AdjustableDate)this.paymentDate(fpmlFra, cdmCounterpartyList).get(), (DiscountingMethod)this.discountingMethod(fpmlFra, cdmCounterpartyList).get());
            if (payout1 == null) {
                payoutList.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                payoutList.addAll(this.toBuilder(Collections.singletonList(payout1)));
            }
            return Optional.ofNullable(payoutList).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends PayerReceiver> floatingPayerReceiver(Fra fpmlFra, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)this.mapSellerAsPayerAndBuyerAsReceiver.evaluate((BuyerSellerModel)MapperS.of((Object)fpmlFra).map("getBuyerSellerModel", fra -> fra.getBuyerSellerModel()).get(), cdmCounterpartyList));
        }

        @Override
        protected MapperS<DayCountFractionEnum> dayCountFraction(Fra fpmlFra, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)((Object)this.mapDayCountFractionEnum.evaluate((String)MapperS.of((Object)fpmlFra).map("getDayCountFraction", fra -> fra.getDayCountFraction()).map("getValue", _dayCountFraction -> _dayCountFraction.getValue()).get())));
        }

        @Override
        protected MapperS<? extends CalculationPeriodDates> calculationPeriodDates(Fra fpmlFra, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)this.mapFraCalculationPeriodDates.evaluate(fpmlFra));
        }

        @Override
        protected MapperS<? extends AdjustableDate> paymentDate(Fra fpmlFra, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)this.mapAdjustableDate.evaluate((fpml.confirmation.AdjustableDate)MapperS.of((Object)fpmlFra).map("getPaymentDate", fra -> fra.getPaymentDate()).get()));
        }

        @Override
        protected MapperS<? extends DiscountingMethod> discountingMethod(Fra fpmlFra, List<? extends Counterparty> cdmCounterpartyList) {
            return MapperS.of((Object)this.mapFraDiscountingMethod.evaluate((FraDiscountingEnum)((Object)MapperS.of((Object)fpmlFra).map("getFraDiscounting", fra -> fra.getFraDiscounting()).get())));
        }
    }
}

