/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.equityoption.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.product.equityoption.functions.MapEquityOptionPayout;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.confirmation.EquityOption;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapEquityOptionEconomicTermsDefault.class)
public abstract class MapEquityOptionEconomicTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapEquityOptionPayout mapEquityOptionPayout;

    public EconomicTerms evaluate(EquityOption fpmlEquityOption, List<? extends Counterparty> cdmCounterpartyList) {
        EconomicTerms economicTerms;
        EconomicTerms.EconomicTermsBuilder economicTermsBuilder = this.doEvaluate(fpmlEquityOption, cdmCounterpartyList);
        if (economicTermsBuilder == null) {
            economicTerms = null;
        } else {
            economicTerms = economicTermsBuilder.build();
            this.objectValidator.validate(EconomicTerms.class, (RosettaModelObject)economicTerms);
        }
        return economicTerms;
    }

    protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(EquityOption var1, List<? extends Counterparty> var2);

    public static class MapEquityOptionEconomicTermsDefault
    extends MapEquityOptionEconomicTerms {
        @Override
        protected EconomicTerms.EconomicTermsBuilder doEvaluate(EquityOption fpmlEquityOption, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
            return this.assignOutput(economicTerms, fpmlEquityOption, cdmCounterpartyList);
        }

        protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, EquityOption fpmlEquityOption, List<? extends Counterparty> cdmCounterpartyList) {
            Payout payout = this.mapEquityOptionPayout.evaluate(fpmlEquityOption, cdmCounterpartyList);
            economicTerms = (EconomicTerms.EconomicTermsBuilder)this.toBuilder(EconomicTerms.builder().setPayout(payout == null ? Collections.emptyList() : Collections.singletonList(payout)).build());
            return Optional.ofNullable(economicTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

