/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.DeliveryDateParameters;
import cdm.ingest.fpml.confirmation.datetime.functions.MapCommodityDeliveryDates;
import cdm.ingest.fpml.confirmation.other.functions.MapQuotationSideEnum;
import cdm.ingest.fpml.confirmation.pricequantity.functions.MapAssetIdentifierList;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.Commodity;
import fpml.confirmation.SpecifiedPriceEnum;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapAssetCommodityDefault.class)
public abstract class MapAssetCommodity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAssetIdentifierList mapAssetIdentifierList;
    @Inject
    protected MapCommodityDeliveryDates mapCommodityDeliveryDates;
    @Inject
    protected MapQuotationSideEnum mapQuotationSideEnum;

    public Asset evaluate(Commodity fpmlCommodity) {
        Asset asset;
        Asset.AssetBuilder assetBuilder = this.doEvaluate(fpmlCommodity);
        if (assetBuilder == null) {
            asset = null;
        } else {
            asset = assetBuilder.build();
            this.objectValidator.validate(Asset.class, (RosettaModelObject)asset);
        }
        return asset;
    }

    protected abstract Asset.AssetBuilder doEvaluate(Commodity var1);

    public static class MapAssetCommodityDefault
    extends MapAssetCommodity {
        @Override
        protected Asset.AssetBuilder doEvaluate(Commodity fpmlCommodity) {
            Asset.AssetBuilder asset = Asset.builder();
            return this.assignOutput(asset, fpmlCommodity);
        }

        protected Asset.AssetBuilder assignOutput(Asset.AssetBuilder asset, Commodity fpmlCommodity) {
            asset = (Asset.AssetBuilder)this.toBuilder(Asset.builder().setCommodity(cdm.base.staticdata.asset.common.Commodity.builder().setIdentifier(new ArrayList<AssetIdentifier>(this.mapAssetIdentifierList.evaluate(fpmlCommodity))).setPriceQuoteType(this.mapQuotationSideEnum.evaluate((String)MapperS.of((Object)fpmlCommodity).map("getCommodityProductModel", commodity -> commodity.getCommodityProductModel()).map("getSpecifiedPrice", commodityProductModel -> commodityProductModel.getSpecifiedPrice()).map("to-string", SpecifiedPriceEnum::toDisplayString).get())).setDeliveryDateReference(DeliveryDateParameters.builder().setDeliveryNearby(this.mapCommodityDeliveryDates.evaluate(fpmlCommodity)).build()).build()).build());
            return Optional.ofNullable(asset).map(o -> o.prune()).orElse(null);
        }
    }
}

