/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.datetime.functions;

import cdm.base.datetime.Offset;
import cdm.base.datetime.PeriodEnum;
import cdm.ingest.fpml.confirmation.datetime.functions.MapDeliveryDatesToPeriodMultiplier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.Commodity;
import fpml.confirmation.DeliveryDatesEnum;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCommodityDeliveryDatesDefault.class)
public abstract class MapCommodityDeliveryDates
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapDeliveryDatesToPeriodMultiplier mapDeliveryDatesToPeriodMultiplier;

    public Offset evaluate(Commodity fpmlCommodity) {
        Offset offset;
        Offset.OffsetBuilder offsetBuilder = this.doEvaluate(fpmlCommodity);
        if (offsetBuilder == null) {
            offset = null;
        } else {
            offset = offsetBuilder.build();
            this.objectValidator.validate(Offset.class, (RosettaModelObject)offset);
        }
        return offset;
    }

    protected abstract Offset.OffsetBuilder doEvaluate(Commodity var1);

    protected abstract MapperS<DeliveryDatesEnum> deliveryDates(Commodity var1);

    public static class MapCommodityDeliveryDatesDefault
    extends MapCommodityDeliveryDates {
        @Override
        protected Offset.OffsetBuilder doEvaluate(Commodity fpmlCommodity) {
            Offset.OffsetBuilder offset = Offset.builder();
            return this.assignOutput(offset, fpmlCommodity);
        }

        protected Offset.OffsetBuilder assignOutput(Offset.OffsetBuilder offset, Commodity fpmlCommodity) {
            PeriodEnum ifThenElseResult = null;
            if (ExpressionOperators.exists(this.deliveryDates(fpmlCommodity)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = PeriodEnum.M;
            }
            offset = (Offset.OffsetBuilder)this.toBuilder(Offset.builder().setPeriod(ifThenElseResult).setPeriodMultiplier(this.mapDeliveryDatesToPeriodMultiplier.evaluate((DeliveryDatesEnum)((Object)this.deliveryDates(fpmlCommodity).get()))).build());
            return Optional.ofNullable(offset).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<DeliveryDatesEnum> deliveryDates(Commodity fpmlCommodity) {
            return MapperS.of((Object)fpmlCommodity).map("getCommodityProductModel", commodity -> commodity.getCommodityProductModel()).map("getCommodityProductModelSequence", commodityProductModel -> commodityProductModel.getCommodityProductModelSequence()).map("getCommodityProductModelSequenceChoice", commodityProductModelSequence -> commodityProductModelSequence.getCommodityProductModelSequenceChoice()).map("getDeliveryDates", commodityProductModelSequenceChoice -> commodityProductModelSequenceChoice.getDeliveryDates());
        }
    }
}

