/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.common.functions;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.ingest.fpml.confirmation.common.functions.MapAssetClassWithScheme;
import cdm.ingest.fpml.confirmation.common.functions.MapStringWithScheme;
import cdm.ingest.fpml.confirmation.common.functions.MapTaxonomySourceEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.ProductModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapProductTaxonomyListDefault.class)
public abstract class MapProductTaxonomyList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapAssetClassWithScheme mapAssetClassWithScheme;
    @Inject
    protected MapStringWithScheme mapStringWithScheme;
    @Inject
    protected MapTaxonomySourceEnum mapTaxonomySourceEnum;

    public List<? extends ProductTaxonomy> evaluate(ProductModel fpmlProductModel) {
        List taxonomy;
        List<ProductTaxonomy.ProductTaxonomyBuilder> taxonomyBuilder = this.doEvaluate(fpmlProductModel);
        if (taxonomyBuilder == null) {
            taxonomy = null;
        } else {
            taxonomy = taxonomyBuilder.stream().map(ProductTaxonomy::build).collect(Collectors.toList());
            this.objectValidator.validate(ProductTaxonomy.class, taxonomy);
        }
        return taxonomy;
    }

    protected abstract List<ProductTaxonomy.ProductTaxonomyBuilder> doEvaluate(ProductModel var1);

    public static class MapProductTaxonomyListDefault
    extends MapProductTaxonomyList {
        @Override
        protected List<ProductTaxonomy.ProductTaxonomyBuilder> doEvaluate(ProductModel fpmlProductModel) {
            ArrayList<ProductTaxonomy.ProductTaxonomyBuilder> taxonomy = new ArrayList<ProductTaxonomy.ProductTaxonomyBuilder>();
            return this.assignOutput(taxonomy, fpmlProductModel);
        }

        protected List<ProductTaxonomy.ProductTaxonomyBuilder> assignOutput(List<ProductTaxonomy.ProductTaxonomyBuilder> taxonomy, ProductModel fpmlProductModel) {
            ProductTaxonomy productTaxonomy = ProductTaxonomy.builder().setPrimaryAssetClass(this.mapAssetClassWithScheme.evaluate((String)MapperS.of((Object)fpmlProductModel).map("getPrimaryAssetClass", productModel -> productModel.getPrimaryAssetClass()).map("getValue", assetClass -> assetClass.getValue()).get(), (String)MapperS.of((Object)fpmlProductModel).map("getPrimaryAssetClass", productModel -> productModel.getPrimaryAssetClass()).map("getAssetClassScheme", assetClass -> assetClass.getAssetClassScheme()).get())).build();
            if (productTaxonomy == null) {
                taxonomy.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                taxonomy.addAll(this.toBuilder(Collections.singletonList(productTaxonomy)));
            }
            taxonomy.addAll(this.toBuilder(MapperS.of((Object)fpmlProductModel).mapC("getProductType", productModel -> productModel.getProductType()).mapItem(item -> MapperS.of((Object)ProductTaxonomy.builder().setSource(this.mapTaxonomySourceEnum.evaluate((String)item.map("getProductTypeScheme", productType -> productType.getProductTypeScheme()).get())).setValue(TaxonomyValue.builder().setName(this.mapStringWithScheme.evaluate((String)item.map("getValue", productType -> productType.getValue()).get(), (String)item.map("getProductTypeScheme", productType -> productType.getProductTypeScheme()).get())).build()).build())).getMulti()));
            return Optional.ofNullable(taxonomy).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

