/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.event.common.SpinOff;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SpinOffEquityPrice")
@ImplementedBy(value=Default.class)
public interface SpinOffEquityPrice
extends Validator<SpinOff> {
    public static final String NAME = "SpinOffEquityPrice";
    public static final String DEFINITION = "parentSecurity -> instrumentType = InstrumentTypeEnum -> Equity and childSecurity -> instrumentType = InstrumentTypeEnum -> Equity";

    public static class NoOp
    implements SpinOffEquityPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpinOff spinOff) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SpinOffEquityPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpinOff spinOff) {
            ComparisonResult result = this.executeDataRule(spinOff);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SpinOffEquityPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SpinOff", (RosettaPath)path, (String)SpinOffEquityPrice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SpinOffEquityPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SpinOff", (RosettaPath)path, (String)SpinOffEquityPrice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SpinOff spinOff) {
            try {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)spinOff).map("getParentSecurity", _spinOff -> _spinOff.getParentSecurity()).map("getInstrumentType", security -> security.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)spinOff).map("getChildSecurity", _spinOff -> _spinOff.getChildSecurity()).map("getInstrumentType", security -> security.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

