/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.event.common.Merger;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MergerEquityPrice")
@ImplementedBy(value=Default.class)
public interface MergerEquityPrice
extends Validator<Merger> {
    public static final String NAME = "MergerEquityPrice";
    public static final String DEFINITION = "purchaserSecurity -> instrumentType = InstrumentTypeEnum -> Equity and acquiredSecurity -> instrumentType = InstrumentTypeEnum -> Equity";

    public static class NoOp
    implements MergerEquityPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Merger merger) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MergerEquityPrice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Merger merger) {
            ComparisonResult result = this.executeDataRule(merger);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MergerEquityPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Merger", (RosettaPath)path, (String)MergerEquityPrice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MergerEquityPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Merger", (RosettaPath)path, (String)MergerEquityPrice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Merger merger) {
            try {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)merger).map("getPurchaserSecurity", _merger -> _merger.getPurchaserSecurity()).map("getInstrumentType", security -> security.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)merger).map("getAcquiredSecurity", _merger -> _merger.getAcquiredSecurity()).map("getInstrumentType", security -> security.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

