/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party.processor;

import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.Arrays;

public class BuyerSellerPartyHelper {
    public static boolean isBuyerAsReceiver(Path synonymPath, RosettaPath modelPath) {
        return !BuyerSellerPartyHelper.isCreditFundingLeg(modelPath, synonymPath) && !BuyerSellerPartyHelper.isFra(modelPath, synonymPath);
    }

    public static boolean isSellerAsPayer(Path synonymPath, RosettaPath modelPath) {
        return !BuyerSellerPartyHelper.isCreditFundingLeg(modelPath, synonymPath) && !BuyerSellerPartyHelper.isFra(modelPath, synonymPath);
    }

    private static boolean isCreditFundingLeg(RosettaPath modelPath, Path synonymPath) {
        boolean interestRatePayout = MappingProcessorUtils.subPath((String)"InterestRatePayout", (Path)PathUtils.toPath((RosettaPath)modelPath)).isPresent();
        boolean creditDefaultSwapGeneralTerms = MappingProcessorUtils.subPath((String)"generalTerms", (Path)synonymPath).map(path -> path.endsWith(new String[]{"creditDefaultSwap", "generalTerms"})).orElse(false);
        return interestRatePayout && creditDefaultSwapGeneralTerms;
    }

    private static boolean isFra(RosettaPath modelPath, Path synonymPath) {
        boolean interestRatePayout = MappingProcessorUtils.subPath((String)"InterestRatePayout", (Path)PathUtils.toPath((RosettaPath)modelPath)).isPresent();
        boolean fra = Arrays.stream(synonymPath.getPathNames()).anyMatch("fra"::equals);
        return interestRatePayout && fra;
    }
}

