/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.TaxonomyValue;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TaxonomyValueValueExists")
@ImplementedBy(value=Default.class)
public interface TaxonomyValueValueExists
extends Validator<TaxonomyValue> {
    public static final String NAME = "TaxonomyValueValueExists";
    public static final String DEFINITION = "name exists or classification exists";

    public static class NoOp
    implements TaxonomyValueValueExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TaxonomyValue taxonomyValue) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TaxonomyValueValueExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TaxonomyValue taxonomyValue) {
            ComparisonResult result = this.executeDataRule(taxonomyValue);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TaxonomyValueValueExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TaxonomyValue", (RosettaPath)path, (String)TaxonomyValueValueExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TaxonomyValueValueExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TaxonomyValue", (RosettaPath)path, (String)TaxonomyValueValueExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TaxonomyValue taxonomyValue) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)taxonomyValue).map("getName", _taxonomyValue -> _taxonomyValue.getName())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)taxonomyValue).mapC("getClassification", _taxonomyValue -> _taxonomyValue.getClassification())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

