# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['EligibleCollateralCriteria']

from cdm.product.collateral.CollateralCriteriaBase import CollateralCriteriaBase

class EligibleCollateralCriteria(CollateralCriteriaBase):
    """
    Represents a set of criteria used to specify eligible collateral.
    """
    collateralCriteria: cdm.product.collateral.CollateralCriteria.CollateralCriteria = Field(..., description="The specific criteria in an Eligible Collateral Schedule. This is a mandatory attribute of an ECS so an override is required to enforce the cardinality.")
    """
    The specific criteria in an Eligible Collateral Schedule. This is a mandatory attribute of an ECS so an override is required to enforce the cardinality.
    """
    treatment: cdm.product.collateral.CollateralTreatment.CollateralTreatment = Field(..., description="Identifies the treatment of specified collateral, e.g., haircuts,holding limits or exclusions.")
    """
    Identifies the treatment of specified collateral, e.g., haircuts,holding limits or exclusions.
    """
    
    @rosetta_condition
    def condition_0_ConcentrationLimitTypeIssueOSAmountDebtOnly(self):
        """
        Specifies a condition that concentration limit type 'IssueOutstandingAmount' is restricted to be used only if the asset type is described as 'Security' and 'Debt'.
        """
        item = self
        def _then_fn0():
            return (CriteriaMatchesAssetType(rosetta_resolve_attr(self, "collateralCriteria"), Debt) or all_elements(list(map(lambda item: CriteriaMatchesAssetType(rosetta_resolve_attr(rosetta_resolve_attr(item, "concentrationLimitCriteria"), "collateralCriteria"), Debt), rosetta_resolve_attr(rosetta_resolve_attr(self, "treatment"), "concentrationLimit"))), "=", True))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "treatment"), "concentrationLimit"), "concentrationLimitCriteria"), "concentrationLimitType")), "=", rosetta_resolve_attr(ConcentrationLimitTypeEnum, "ISSUE_OUTSTANDING_AMOUNT")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_ConcentrationLimitTypeMarketCapEquityOnly(self):
        """
        Specifies a condition that concentration limit type 'MarketCapitalisation' is restricted to be used only if the asset type is described as 'Security' and 'Equity'.
        """
        item = self
        def _then_fn0():
            return (CriteriaMatchesAssetType(rosetta_resolve_attr(self, "collateralCriteria"), Equity) or all_elements(list(map(lambda item: CriteriaMatchesAssetType(rosetta_resolve_attr(rosetta_resolve_attr(item, "concentrationLimitCriteria"), "collateralCriteria"), Equity), rosetta_resolve_attr(rosetta_resolve_attr(self, "treatment"), "concentrationLimit"))), "=", True))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "treatment"), "concentrationLimit"), "concentrationLimitCriteria"), "concentrationLimitType")), "=", rosetta_resolve_attr(ConcentrationLimitTypeEnum, "MARKET_CAPITALISATION")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_AverageTradingVolumeEquityOnly(self):
        """
        Specifies a condition that concentration limit 'AverageTradingVolume' is restricted to be used only if the asset type is described as 'Security' and 'Equity'.
        """
        item = self
        def _then_fn0():
            return (CriteriaMatchesAssetType(rosetta_resolve_attr(self, "collateralCriteria"), Equity) or all_elements(list(map(lambda item: CriteriaMatchesAssetType(rosetta_resolve_attr(rosetta_resolve_attr(item, "concentrationLimitCriteria"), "collateralCriteria"), Equity), rosetta_resolve_attr(rosetta_resolve_attr(self, "treatment"), "concentrationLimit"))), "=", True))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "treatment"), "concentrationLimit"), "concentrationLimitCriteria"), "averageTradingVolume")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.collateral.CollateralCriteria
import cdm.product.collateral.CollateralTreatment
from cdm.product.collateral.ConcentrationLimitTypeEnum import ConcentrationLimitTypeEnum
from cdm.product.collateral.functions.CriteriaMatchesAssetType import CriteriaMatchesAssetType
