# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['FxAdditionalTerms']


class FxAdditionalTerms(BaseDataClass):
    """
    TransactionAdditionalTerms which apply to the CurrencyPair asset class.
    """
    disruptionEvents: Optional[cdm.legaldocumentation.transaction.additionalterms.FxDisruptionEvents.FxDisruptionEvents] = Field(None, description="")
    determinationTerms: Optional[cdm.legaldocumentation.transaction.additionalterms.DeterminationRolesAndTerms.DeterminationRolesAndTerms] = Field(None, description="")
    noFaultTermination: Optional[bool] = Field(None, description="")
    
    @rosetta_condition
    def condition_0_SpecificDeterminationRetrictionsForFx(self):
        item = self
        return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "determinationTerms"), "determinationRole"), "=", rosetta_resolve_attr(DeterminationRoleEnum, "CALCULATION_AGENT"))
    
    @rosetta_condition
    def condition_1_NoFaultTerminationOrDisruptionTerms(self):
        item = self
        return (((rosetta_attr_exists(rosetta_resolve_attr(self, "disruptionEvents")) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "noFaultTermination")))) or all_elements(rosetta_resolve_attr(self, "noFaultTermination"), "=", False)) or ((not rosetta_attr_exists(rosetta_resolve_attr(self, "disruptionEvents"))) and all_elements(rosetta_resolve_attr(self, "noFaultTermination"), "=", True)))

import cdm 
import cdm.legaldocumentation.transaction.additionalterms.FxDisruptionEvents
import cdm.legaldocumentation.transaction.additionalterms.DeterminationRolesAndTerms
from cdm.legaldocumentation.transaction.additionalterms.DeterminationRoleEnum import DeterminationRoleEnum
