# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ValuationAgentPartyEnum']

class ValuationAgentPartyEnum(Enum):
    """
    Specification of which party calculating the value of collateral to be delivered or returned.
    """
    PARTY_1 = "Party 1"
    """
    Party 1 will calculate the value of collateral to be delivered or returned.
    """
    PARTY_2 = "Party 2"
    """
    Party 2 will calculate the value of collateral to be delivered or returned.
    """
    PARTY_MAKING_DEMAND = "Party Making the Demand"
    """
    The party making the demand will calculate the value of collateral to be delivered or returned.
    """
