# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SensitivityMethodology']


class SensitivityMethodology(BaseDataClass):
    """
    A class to specify the methodology according to which sensitivities are computed.
    """
    specifiedMethodology: Optional[cdm.legaldocumentation.csa.SensitivitiesEnum.SensitivitiesEnum] = Field(None, description="The methodology according to which sensitivities will be computed, when specified through a normalized election.")
    """
    The methodology according to which sensitivities will be computed, when specified through a normalized election.
    """
    customMethodology: Optional[str] = Field(None, description="The methodology according to which sensitivities will be computed, when specified through a custom election.")
    """
    The methodology according to which sensitivities will be computed, when specified through a custom election.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'specifiedMethodology', 'customMethodology', necessity=True)

import cdm 
import cdm.legaldocumentation.csa.SensitivitiesEnum
