# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['RecalculationOfValueElectionEnum']

class RecalculationOfValueElectionEnum(Enum):
    """
    Values to specify the procedure under which the market value of posted collateral will be recalculated.
    """
    CONSULATION_PROCEDURE = "ConsulationProcedure"
    """
    The parties agree to consult.
    """
    NOT_APPLICABLE = "NotApplicable"
    """
    Description to be added.
    """
    OTHER_REGULATORY_CSA_PROCEDURE = "OtherRegulatoryCSAProcedure"
    """
    The procedures specified in an Other Regulatory CSA.
    """
    SPECIFIED = "Specified"
    """
    Bespoke Recalculation of value terms are specified in the agreement.
    """
