# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ProcessAgentElection']


class ProcessAgentElection(BaseDataClass):
    """
    A class to specify the parties' respective elections with respect to the Process Agent.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    isApplicable: bool = Field(..., description="The qualification of whether the Process Agent is applicable (True) or not applicable (False).")
    """
    The qualification of whether the Process Agent is applicable (True) or not applicable (False).
    """
    processAgent: Optional[cdm.base.staticdata.party.PartyContactInformation.PartyContactInformation] = Field(None, description="The Process Agent specification, when applicable.")
    """
    The Process Agent specification, when applicable.
    """
    
    @rosetta_condition
    def condition_0_Applicable(self):
        """
        A data rule to enforce that the Process Agent must be specified when it is applicable.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "processAgent"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", True), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_NotApplicable(self):
        """
        A data rule to enforce that the Process Agent cannot be specified if deemed not applicable.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "processAgent")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", False), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.base.staticdata.party.PartyContactInformation
